<?php 

$options = array('size'=>30);

echo CHtml::tag("div", array( 'class'=>'explanation' ), "Choose a device name " . 
                        CHtml::image("css/info.png", "info",  array( "id" => "DeviceNameInfo") ) . " ". 
                        CHtml::tag("span", array( "id" => "DeviceNameInfoText") , "Serial number can be overwritten by a more descriptive name. For example, reception, spa, etc" )
                );

echo CHtml::openTag("div", array( 'class'=>'simple') );
//echo CHtml::activeLabel($config, "deviceName");
echo CHtml::activeTextField($config, "deviceName", $options);
echo CHtml::closeTag("div")."\n";

echo CHtml::tag("div", array( 'class'=>'explanation extra_top' ), "Choose a multiscreen ID " . 
                        CHtml::image("css/info.png", "info",  array( "id" => "DeviceIDInfo") ) . " " . 
                        CHtml::tag("span", array( "id" => "DeviceIDInfoText") , "Multiscreen project requires every screen to have its own multiscreen ID. For example, screen-1-1, screen-1-2, etc" )
                );

if ( $config->screenId == Yii::app()->user->info->serial )
    $config->screenId = "";

echo CHtml::openTag("div", array( 'class'=>'simple') );
//echo CHtml::activeLabel($config, "screenId");
echo CHtml::activeTextField($config, "screenId", $options);
echo CHtml::closeTag("div")."\n";

?>

<script type="text/javascript">//<![CDATA[
$( function() {
    $("#DeviceNameInfoText").hide();
    $("#DeviceNameInfo").click( function() {
        if ( $("#DeviceNameInfoText").is(":visible") )
            $("#DeviceNameInfoText").hide();
        else
            $("#DeviceNameInfoText").show();
    });
    
    $("#DeviceIDInfoText").hide();
    $("#DeviceIDInfo").click( function() {
        if ( $("#DeviceIDInfoText").is(":visible") )
            $("#DeviceIDInfoText").hide();
        else
            $("#DeviceIDInfoText").show();
    });
    
});
//]]></script>