#! /bin/sh
#
# Name: bootclean.sh 
# Date: 2003-06-23 18:00
# Author: MontaVista Software, Inc. <source@mvista.com>
# Copyright: Copyright 1999-2003 MontaVista Software, Inc.
# License: 2003 (c) MontaVista Software, Inc. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
# 
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start: 
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: S
# Default-Stop: 0 1 2 3 4 5 6
# Short-Description: Miscellaneous things to be done during bootup.
# Description: Miscellaneous things to be done during bootup.
### END INIT INFO 
# chkconfig: S 38 0

# Init script information
INIT_NAME=rcS

# Load init script configuration
[ -f /etc/default/$INIT_NAME ] && . /etc/default/$INIT_NAME

# Source the init script functions
. /etc/init.d/init-functions

test -f /usr/bin/find -a -f /bin/grep -a -f /bin/sed || exit 5

RET=0 ERROR=""

#
# Wipe /tmp (and don't erase `lost+found', `quota.user' or `quota.group')!
# Note that files _in_ lost+found _are_ deleted.
#
log_status_msg "Cleaning: /tmp " -n
#
#       If $TMPTIME is set to 0, we do not use any ctime expression
#       at all, so we can also delete files with timestamps
#       in the future!
#
[ "$TMPTIME" = ""  ] && TEXPR="" || TEXPR="! -ctime -$TMPTIME"
( cd /tmp && \
  find . -xdev \
  $TEXPR \
  ! -name . \
  ! \( -name lost+found -uid 0 \) \
  ! \( -name quota.user -uid 0 \) \
  ! \( -name quota.group -uid 0 \) \
    -depth -exec rm -rf -- {} \; )
rm -f /tmp/.X*-lock

#
# Clean up any stale locks.
#
log_status_msg "/var/lock " -n
( cd /var/lock && find . -type f -exec rm -f -- {} \; )
#
# Clean up /var/run.
#
log_status_msg "/var/run " -n
( cd /var/run && \
        find . ! -type d ! -name utmp ! -name random-seed \
        -exec rm -f -- {} \; )
echo "done."

#
log_status_msg ""
exit 0


