#!/bin/sh
#
# chkconfig: 235 15 0
#
# Runs a bootloader update for Sakura hardware and
# then disables this startup script.

# Init script information
INIT_NAME=bootloader-update-sakura.sh
DESC=""

start() {
    local ret

    echo "Bootloader check / update for Sakura"

    # We just need to run once at boot, even if update fails
    initdconfig --del "$INIT_NAME"

    grep -q '^Hardware[[:space:]]\+:[[:space:]]\+Sakura$' /proc/cpuinfo
    if [ $? -ne 0 ]; then
	echo "Hardware is not Sakura, skipping"
	return 0
    fi

    spxblflash -H Sakura -u
    ret=$?

    # reboot for new bootloader to take effect
    if [ $ret -eq 0 ]; then
	echo "rebooting for new bootloader to take effect"
	shutdown -r now "rebooting for new bootloader to take effect"
    fi
}

case "$1" in
    start)

	start 2>&1 | logger -s -p daemon.notice -t "$INIT_NAME"

    ;;
    stop)
    ;;
esac



