<?php

//require_once(dirname(__FILE__).'/../extensions/jui/EJqueryUiWidget.php');

Yii::import('zii.widgets.jui.CJuiWidget');

class EditPlaylist extends CJuiWidget {
  public $theme='spxfusion';
	public $name;
    public $playlist;
    public $options = array("settings"=>false, 
                            "duration"=>true, 
                            "validity"=>false, 
                            "visible"=>false, 
                            "dates"=>false,
                            "addImage"=> false,
                            "addVideo"=> false,
                            "addAudio"=> false,
                            "addProject"=> false,
                            "apply"=>false,
                            "save"=>true,
                            "saveas" => true,
                            "hasslides" => false,
                            'hasvideo'=>false,
                            'hashyper'=>false,
                        );
    public $sources = array();
    
	//***************************************************************************
	// Initializes the widget
	//***************************************************************************
	public function init(){
        parent::init();
        
		if(!isset($this->name)){
			throw new CHttpException(500,'Page must have a name');
		}
        
        if(!isset($this->playlist)){
			throw new CHttpException(500,'Need a playlist');
		}
        
	}
	//***************************************************************************
	// Run the widget
	//***************************************************************************
	public function run(){

    $options=$this->options;
    
// let's write the table as JS

$actions = CHtml::openTag("td", array( 'class'=>"pl_item actions" ) );
if ($options['save'] ) {
    
    $actions .=CHtml::image("images/up.gif",  Yii::t('app', "Up"), 
                                            array(  "onclick" => "upItem( getIdx($(this)) )",
                                                    "title" => Yii::t('app', "Up"),
                                                    "alt" => Yii::t('app', "Up"),
                                                    'class'=>'up click-cursor'
                                                )
                        ) . "\n";
    $actions .=CHtml::image("images/down.gif",    Yii::t('app', "Down"), 
                                                array(  "onclick" => "downItem( getIdx($(this)) )",
                                                        "title" => Yii::t('app', "Down"),
                                                        "alt" => Yii::t('app', "Down"),
                                                        'class'=>'down click-cursor'
                                                    ) 
                        ). "\n";
    $actions .=CHtml::image("images/x.gif",  Yii::t('app', "Del"), 
                                                array(  "onclick" => "deleteItem( getIdx($(this)) )",
                                                        "title" => Yii::t('app', "Delete"),
                                                        "alt" => Yii::t('app', "Delete"),
                                                        'class'=>'del click-cursor'
                                                    ) 
                        ) . "\n";
}
$actions .=CHtml::closeTag("td") ;

$actions = str_replace("\"", "'", $actions );
$actions = str_replace("\n", "\" + \n\"", $actions );
$actions = str_replace("</", "<\/", $actions );
$actions = "\"$actions\"";

if ($options['save'] )
    $disabledoption = "";
else
    $disabledoption = "disabled='disabled'";
$metaname = Yii::t('app', "Media");
$textauto = Yii::t('app','automatic');
$textdur = Yii::t('app','Duration');
$playlist_name = "playlist_".$this->id;
$days = Yii::t('app','SMTWTFS');
$dur_error=Yii::t('app',"Input format is not valid. Valid format is 'hh:mm:ss'");

$script =<<<EOP
function playlistItem(id, name, link, preview, dur, validityStart, validityEnd, timeStart, timeEnd, validDates, metaname)
{
    this.id=id;
    this.type=id.substr(0, id.indexOf(':'));
    this.name=name;
    this.metaname=metaname||"";
    this.link=link;
    this.preview=preview;
    this.dur=dur;
    this.validityStart=validityStart;
    this.validityEnd=validityEnd;
    this.timeStart=timeStart;
    this.timeEnd=timeEnd;
    this.validDates=validDates;
};

function addDates( dates, idx ) {
    var str = "";
    for (var i=0; i<7; i++ ) {
        if ( dates.substr(i,1)=="1" ){
            cl = "dname checkbox checked";
            value = "1";
        } else {
            cl = "dname checkbox";
            value = "0";
        }
		str += "<span class='" + cl + "' onclick='$(this).toggleClass(\"checked\"); $(\"input\", this).each(function() { if ( $(this).val() == 0 ) $(this).val(1); else $(this).val(0); }); '>";
		str += "<input $disabledoption type='hidden' name='PlaylistItem["+idx+"][validDate"+i+"]' value='" +value+ "'/>";
        str += "$days".substr(i,1);
        str += "<\/span>";
		if (i!=6)
			str += "<span class='days'> <\/span>";
    }
    return str;
}
function getIdx( node ) {
    var i=5;
    while ( node!=null && node.length && i-->0) {
        var id = node.attr('id');
        if ( id!=undefined && id.substr(0,8)=='row_idx_' )
            return parseInt(id.substr(8));
        node = node.parent();
    }
    return -1;
}

function fixItemIdx( node, idx, new_idx ) {
    if (!node.length)
        return;
    var meta=$('input.metaname', node);
    var v=meta.val();
    
    
    var r = new RegExp("PlaylistItem\\\["+idx+"\\\]");
    $('input', node).each(function() {
            $(this).attr('name', $(this).attr('name').replace(r, "PlaylistItem["+new_idx+"]") );
        });
    node.attr('id', node.attr('id').replace("idx_"+idx, "idx_"+new_idx));
	
    meta=$('input.metaname', node);
	if ( v.match(/$metaname [0-9]+/) ) {
		meta.val("$metaname "+ (new_idx+1));
    } else {
        meta.val(v);
    }
	
    var id = node.attr('id');
    if ( id!=undefined && id.substr(0,8)=='row_idx_' )
        node.attr('id', 'row_idx_'+new_idx);
        
    $('.datepicker', node).removeClass('hasDatepicker').datepicker({'showButtonPanel':true,'numberOfMonths':2, dateFormat: 'yy mm dd'});
}

function fixTable( node ) {
    $(".playlist_item",node).each( function(index) {
        
        idx = getIdx( $(this) );
        if ( idx!=index )
            fixItemIdx( $(this), idx, index );
    });
}

function downItem( idx ) {
    if ( idx< $playlist_name.length-1 ) {
        // update the data
        var row = $playlist_name.splice(idx, 1);
        $playlist_name.splice(idx, 0, row[0])
        
        // move the rows
        var src = $("#row_idx_"+idx);
        var dst = $("#row_idx_"+(idx+1));
        
        dst.after(src);
        
        // fix the idx
        fixItemIdx( src, idx, idx+1);
        fixItemIdx( dst, idx+1, idx);
        
    }
    hasChange=true;
}

function deleteItem( idx ) {
    // update the data
    var row = $playlist_name.splice(idx, 1);
        
    //  the rows
    var src = $("#row_idx_"+idx);
    src.remove();
    // fix the idx
    for (var i=idx+1; i< $playlist_name.length+1; i++ )
        fixItemIdx( $("#row_idx_"+i), i, i-1);
    
	if ( $playlist_name.length==0 ) {
		showMedia();
		$('.no_item').show();
		$('.need_item').hide();
	}
    fixHeights();
    hasChange=true;
}

function upItem( idx ) {
   if ( idx>0 ) {
        // update the data
        var row = $playlist_name.splice(idx, 1);
        
        $playlist_name.splice(idx-1, 0, row[0])
        
        // move the rows
        var src = $("#row_idx_"+idx);
        var dst = $("#row_idx_"+(idx-1));
        
        dst.before(src);
        
        // fix the idx
        fixItemIdx( src, idx, idx-1);
        fixItemIdx( dst, idx-1, idx);
        
        hasChange=true;
    } 
}


function addRow( item, idx, dst ) {
    
	$('.no_item').hide();
	$('.need_item').show();
	
    var row = $(document.createElement("tr"));
    
    if ( idx==0 ) {
        var where = $('#row_idx_0');
        if ( where.length )
            where.before(row);
        else
            dst.append(row);
    } else {
        var where = $('#row_idx_'+(idx-1));
        if ( where.length )
            where.after(row);
        else
            dst.append(row);
    }
    
    row.addClass("playlist_item");
    row.attr("id", "row_idx_"+idx);
    
    var fileName = item.name;
    fileName = fileName.replace(/^\d+_/, "");
    if ( fileName.length>20 )
        fileName = fileName.substr(0,20)+"...";
    
    
    if ( item.type=='playlist')
        row.append("<td class='pl_item preview'><div class='playlist preview_normal'><img class='playlist preview_normal' alt='' src='"+item.preview+"'><\/div><\/td>");
    else
        row.append("<td class='pl_item preview'><div class='preview_normal'><img class='preview_normal' alt='' src='"+item.preview+"'><\/div><\/td>");
        
    var metaname = item.metaname;
    if (metaname=="")
        metaname = "$metaname " + (idx+1);
    var classes = 'duration';
    if ( item.type=='image' )
        classes += " static";
    else
        classes += " dynamic";
    if ( item.dur[0]=='E' ){
        item.dur = item.dur.substr(1);
        classes += ' error';
    }
    row.append( "<td class='pl_item desc'>"+
                "<span class='metaname'><input $disabledoption type='text' value='"+metaname+"' name='PlaylistItem["+idx+"][metaname]' class='metaname' /><\/span>"+
                "<span class='duration'><input $disabledoption type='text' value='"+item.dur+"' name='PlaylistItem["+idx+"][dur]' class='"+classes+"' title='$textdur'/><\/span>"+                
                "<span class='filename'>" + 
                    "<input $disabledoption type='hidden' value='"+item.id+"' name='PlaylistItem["+idx+"][id]' />"+
                    //"<input $disabledoption type='hidden' value='"+item.type+"' name='PlaylistItem["+idx+"][type]' />" +
                    fileName+
                "<\/span>"+
                "<\/td>");
    
    //"<a href='"+item.link+"' >img height='45' alt='' src='"+item.preview+"'><\/a>"

    var class_names;
    if ( $(".edit_section").hasClass("media_view") )
        class_names = 'advanced_tabs';
    else
        class_names = 'advanced_tabs';
        
EOP;
if ( $options['validity'] ) {
$script .=<<<EOP
    c1="";
    c2="";
    if ( item.validityStart[0]=='E' ){
        item.validityStart = item.validityStart.substr(1);
        c1 = ' error';
    }
    if ( item.validityEnd[0]=='E' ){
        item.validityEnd = item.validityEnd.substr(1);
        c2 = ' error';
    }
    row.append( "<td class='pl_item validity "+class_names+"' >" + 
                "<div>" +
                "<input $disabledoption type='text' value='"+item.validityStart+"' name='PlaylistItem["+idx+"][validityStart]' class='datepicker"+c1+"'>" +
                "<span class='date'>-<\/span>" +
                "<input $disabledoption type='text' value='"+item.validityEnd+"' name='PlaylistItem["+idx+"][validityEnd]' class='datepicker"+c2+"'>" +
                "<\/div>" +
                "<\/td>" );
    $('.datepicker', row).datepicker({'showButtonPanel':true,'numberOfMonths':2, dateFormat: 'yy mm dd'}); 
EOP;
}
if ( $options['visible'] ) {
$script .=<<<EOP
    c1="";
    c2="";
    if ( item.timeStart[0]=='E' ){
        item.timeStart = item.timeStart.substr(1);
        c1 = ' error';
    }
    if ( item.timeEnd[0]=='E' ){
        item.timeEnd = item.timeEnd.substr(1);
        c2 = ' error';
    }
    row.append( "<td class='pl_item visible "+class_names+"' >" + 
                "<div>" +
                "<input $disabledoption type='text' value='"+item.timeStart+"' name='PlaylistItem["+idx+"][timeStart]' class='duration starttime"+c1+"'>" +
                "<span class='time'>-<\/span>" +
                "<input $disabledoption type='text' value='"+item.timeEnd+"' name='PlaylistItem["+idx+"][timeEnd]' class='duration endtime"+c2+"'>" +
                "<\/div>" +
                "<\/td>" );
EOP;
}

if ( $options['dates'] ) {
$script .=<<<EOP
    row.append( "<td class='pl_item dates "+class_names+"' >" + 
                "<div>" +
                addDates( item.validDates, idx ) +
                "<\/div>" +
                "<\/td>" );
EOP;

}

$script .=<<<EOP
    
    row. append( $actions  );
    $(".advanced_tabs", row).hide();
    
    return row;
};

function fixDefaultDuration( base ) {
    $("input.static", base).watermark( $("#default_duration_id").val(), {className: 'watermark'});
    $("input.dynamic", base).watermark( '$textauto', {className: 'watermark'});
    $("input.starttime", base).watermark( '00:00:00', {className: 'watermark'});
    $("input.endtime", base).watermark( '24:00:00', {className: 'watermark'});
    $(".duration").blur( function( ) {
        var val = $(this).val();
        // we accept "", "hh:mm:ss" or "ss" as time, "hh:mm" is converted to "hh:mm:ss", other values are removed
        if (val=="" || $(this).hasClass("watermark") ){ 
            if ( $(this).hasClass('error') ){
                nbErrors--;
                if ( nbErrors==0 )
                    $('.save').unbind('click', hasErrors);
            }
            $(this).removeClass('error');
            $(this).attr('title', "");
            return;
        }
        var sec=null;
        if ( val.match(/^\d+:\d+:\d+/) ){
            var m = val.split(":");
            sec = parseInt(m[0],10)*3600;
            sec += parseInt(m[1],10)*60;
            sec += parseInt(m[2],10);
        } else if ( val.match(/^\d+:\d+/) ){
            var m = val.split(":");
            sec = parseInt(m[0],10)*3600;
            sec += parseInt(m[1],10)*60;
        } else if ( val.match(/^\d+s?/) ) { 
            sec = parseInt(val,10);
        }
        if ( $(this).hasClass('default') && sec==0 )
                sec=null;
        if ( sec!=null ) {
			if (sec>24*3600) 
				sec=24*3600;
            var h = Math.floor(sec/3600);
            sec -= h*3600;
            if (h<10) h = '0'+h;
            var m = Math.floor(sec/60);
            if (m<10) m = '0'+m;
            sec -= m*60;
            if (sec<10) sec = '0'+sec;
            $(this).val( h+":"+m+":"+sec);                
            if ( $(this).hasClass('error') ){
                nbErrors--;
                if ( nbErrors==0 )
                    $('.save').unbind('click', hasErrors);
            }
            
            $(this).removeClass('error');
            $(this).attr('title', "");
        } else {
            // error
            if ( !$(this).hasClass('error') ) {
                if (nbErrors==0)
                    $('.save').bind('click', hasErrors);
                nbErrors++;
            }
            $(this).addClass('error');
            $(this).attr('title', "$dur_error" );
        }
    });
}

function addNewItem( fileName, fileId, previewPath, linkpath ) {
    var item = new playlistItem( fileId, fileName, linkpath, previewPath, "", "", "", "", "", "1111111", "" );
    {$playlist_name}[{$playlist_name}.length] = item;
    row = addRow( item, {$playlist_name}.length-1, $('#sortable_{$this->id}') );
    
    fixDefaultDuration(row);
	fixHeights();
    hasChange = true;
}

function drawTable( table ) {
    //table.html("");
    
    for ( var i=0; i<$playlist_name.length; i++ )
        addRow( {$playlist_name}[i], i, table );
    // fix to remove the flaoting div from the datepicker
    $('#ui-datepicker-div').css("display", "none");
}

function fixHeights() {

	var minHeight=326;
	var media = $(".inside_tabs", $("#MediaFiles"));
    var edit = $("#EditSection");
    
	media.height("");
	edit.height("");
	var editH = edit.height();
	var mediaH = media.height();
	if ( editH<minHeight && mediaH<minHeight ) {

		media.height(minHeight);
        
        edit.height(minHeight);
       
	} else if ( editH>mediaH) {
        var d = editH-mediaH;

		media.height(editH);
	} else if ( mediaH>editH){
        var d = mediaH-editH;
       
		edit.height(mediaH);
    }
}

EOP;

$script .= "var $playlist_name=new Array();\n";
$idx=0;
foreach($this->playlist->playlist as $i => $playlistItem) {
    $script .= $playlist_name."[$idx]=new playlistItem(";
    $idx++;
    
    $script .= "\"".$playlistItem->id."\",";
    
    $print_name = $playlistItem->name; 
    if ( preg_match("/^\d+_(.*)/", $print_name, $match) )
        $print_name = $match[1];
    $script .= "\"".$print_name."\",";
    
    if ( $playlistItem->type=='slide' ){
        $link = array('/slides/modify', 'id'=>$playlistItem->id, 'option'=>'close' );
    } elseif ( $playlistItem->type=='playlist' ){
        $link = array('/playlist/edit', 'id'=>$playlistItem->id, 'option'=>'close' );
    } elseif ( $playlistItem->type=='project' ){
        $link = $playlistItem->webpath;
    }else
        $link = $playlistItem->webpath;
    $script .= "\"".CHtml::normalizeUrl($link)."\",";
    
    $script .= "\"".$playlistItem->webpathPreview."\",";
    
    if ($options['save'] || $playlistItem->dur!="" )
        $script .= "\"".($playlistItem->getError('dur')?"E":"").$playlistItem->dur."\",";
    else 
        $script .= "\"".$this->playlist->defaultItemDur."\",";
        
    if ( $options['validity'] ){
        $script .= "\"".($playlistItem->getError('validityStart')?"E":"").$playlistItem->validityStart."\",";
        $script .= "\"".($playlistItem->getError('validityEnd')?"E":"").$playlistItem->validityEnd."\",";
    } else {
        $script .= "\""."\",";
        $script .= "\""."\",";
    }
    if ( $options['visible'] ) {
        $script .= "\"".($playlistItem->getError('timeStart')?"E":"").$playlistItem->timeStart."\",";
        $script .= "\"".($playlistItem->getError('timeEnd')?"E":"").$playlistItem->timeEnd."\",";
    } else {
        $script .= "\""."\",";
        $script .= "\""."\",";
    }
    if ( $options['dates'] ) {
        $script .= "\"";
        for ($j=0; $j<7; $j++){
            $s= 'validDate'.$j;
            $script .= $playlistItem->$s;
        }
        $script .= "\"";
    } else {
        $script .= "\""."\"";
    }
    $script .= ",\"".$playlistItem->metaname."\"";
    $script .= ");\n";
}
if ( count($this->playlist->playlist)>0 )
	$script .="$(document).ready(function() { drawTable( $('#sortable_".$this->id."') ) ; });";

        
        $this->render('editPlaylist',array(
                                            'name'=>$this->name,
                                            'playlistInfo' => $this->playlist,
                                            'options' => $this->options,
                                            'sources' => $this->sources,
                                            'script' => $script,
                                            ));
		
	}

}
?>