<?php 

class LayoutHelper {

    static function openBackground( $print=true ) {
        $output = CHtml::openTag('div',  array('class'=>'border-center') );
        if ( $print )
            echo $output;
        return $output;
    }
    static function openTopBorders( $print=true ) {
        
        $output = CHtml::openTag('div',  array('class'=>'border-top') );
        $output .= CHtml::openTag('div',  array('class'=>'border-left') );
        $output .= CHtml::openTag('div',  array('class'=>'border-right') );

        $output .= CHtml::openTag('div',  array('class'=>'border-top-left') );
        $output .= CHtml::openTag('div',  array('class'=>'border-top-right') );
        
        if ( $print )
            echo $output;
        return $output;

    }
    static function openBottomBorders( $hasside=false, $print=true ) {
        
        $output = CHtml::openTag('div',  array('class'=>'border-bottom') );
        if ( !$hasside ) {
            $output .= CHtml::openTag('div',  array('class'=>'border-left') );
            $output .= CHtml::openTag('div',  array('class'=>'border-right') );
        }
        $output .= CHtml::openTag('div',  array('class'=>'border-bottom-left') );
        $output .= CHtml::openTag('div',  array('class'=>'border-bottom-right') );
        
        if ( $print )
            echo $output;
        return $output;

    }
    static function openBorders( $print=true  ) {
        $output = self::openBackground( $print );
        $output .=self::openTopBorders( $print );
        $output .=self::openBottomBorders( true, $print );
        if ( $print )
            echo "\n";
            
        return $output;
    }
    static function closeBackground( $print=true ) {
        $output = CHtml::closeTag("div");
        
        if ( $print )
            echo $output;
        return $output;
    }
    static function closeTopBorders( $print=true ) {
        $output = CHtml::closeTag("div");
        $output .= CHtml::closeTag("div");
        $output .= CHtml::closeTag("div");
        
        $output .= CHtml::closeTag("div");
        $output .= CHtml::closeTag("div");
        
        if ( $print )
            echo $output;
        return $output;
    }
    static function closeBottomBorders( $hasside=false, $print=true ) {
        $output = CHtml::closeTag("div");
        if ( !$hasside ) {
            $output .= CHtml::closeTag("div");
            $output .= CHtml::closeTag("div");
        }
        $output .= CHtml::closeTag("div");
        $output .= CHtml::closeTag("div");
        
        if ( $print )
            echo $output;
        return $output;
    }
    static function closeBorders( $print=true  ) {
        $output = self::closeBottomBorders(true, $print);
        $output .=self::closeTopBorders( $print );
        $output .=self::closeBackground( $print );
        
        if ( $print )
            echo "\n";
        return $output;
    }
    
    static function createFusionFiles() {
        
    }
}