<?php

class MediaSelect extends CWidget
{
    public $data=array();
	
    public $type='add'; // can be "delete", "add", or "script"
	public $title = null;
    public $desc = null;
    
    //***************************************************************************
	// register clientside widget files
	//***************************************************************************
	protected function registerClientScript(){
        
        //parent::registerClientScripts();
        
        //Yii::app()->getClientScript()->registerCoreScript('jquery');
        Yii::app()->getClientScript()->registerScriptFile(Yii::app()->request->baseUrl."/scripts/thickbox.js");
        Yii::app()->getClientScript()->registerCssFile(Yii::app()->request->baseUrl."/css/thickbox.css");
        
        $titleadd = yii::t('app',"Add");
        $titleview = yii::t('app',"View");
        $titledel = yii::t('app',"Delete");
        
		$link = CHtml::normalizeUrl(array('/files/delete'));
        //$tip = CHtml::tag("div",  array('class'=>'tip-media'), $this->widget('application.components.Tip',array(   'title' => array("{title}","{title2}"), 'desc' => array("{desc}","{desc2}" ), true) );
        //$tip = strtr($tip,array("</"=>"<\/"));
        $script =<<<EOP
function mediaItem(id, name, link, preview, fullview, type)
{
    this.id=id;
    this.name=name;
    this.link=link;
    this.preview=preview;
    this.fullview=fullview;
    this.type=type;
};
function createListAjax( data, max ) {
    var div = $(document.createElement("div"));
	var ul = $(document.createElement("ul"));
    ul.addClass('media-source-list');
    div.append(ul);
	
	for (var i=0; i<max; i++ ){
		var item = data[i];
		addItem( item, i, ul );
	}
	
	return div.html();
}
function createTipAjax( tip ) {
    if ( tip==undefined ) return "";
	return "<div class='tip-media'>" + tip + "<\/div>";
}

function deleteItem( id, src ) {
	var toDelete = $(src).parent().parent().parent();
	
	jQuery.ajax({
		'url':'${link}&id='+ encodeURIComponent(id),
		'cache':false,
		'success':function(data, textStatus){ toDelete.fadeOut("slow") },
		'error':function(data, textStatus){ toDelete.fadeIn("fast") },
		'beforeSend':function(data, textStatus){ toDelete.fadeTo("fast", 0.5) }		
	});
}

function addItem( item, idx, dst ) {

    var it = $(document.createElement("li"));
    dst.append(it);
    
    it.addClass("media-source draggable "+item.type);
    
    it.attr("id", "it_idx_"+idx);
    
    it.append("<div class='meta-data'>"+
                item.id+";"+
                item.name+";"+
                item.link+";"+
                item.preview+";"+
                item.type+"<\/div>");
    var button = 	"<div class='med_item actions "+item.type+"'>";
	
EOP;
if ($this->type=='add')
	$script .=<<<EOP
		button+=	"<img alt='$titleadd' src='images/left.gif' class='add click-cursor' title='$titleadd' " +
						 "onclick=\"addNewItem('"+item.name.replace("\'","\\\'")+"', '"+item.id.replace("\'","\\\'")+"', '"+item.preview+"', '"+item.link+"' )\"/>";
EOP;
else if ( $this->type=='del' || $this->type=='delscript' )
	$script .=<<<EOP
		button+=	"<img alt='$titledel' src='images/x.gif' class='add click-cursor' title='$titledel' " +
						 "onclick=\"deleteItem('"+item.id.replace("\'","\\\'")+"', this);\"/>";
EOP;

$script .=<<<EOP

	if ( item.fullview!=null ){
		if (item.type=='video' || item.type=='audio' )
			button +=	"<a href='"+item.fullview+"'><img alt='$titleview' title='$titleview' src='images/view.gif' class='view click-cursor' /><\/a>";
		else if ( item.type=='slide' || item.link.substr(item.link.length-3)!="svg" )
			button +=	"<img alt='$titleview' title='$titleview' src='images/view.gif' class='view click-cursor' " +
						 "onclick=\"tb_show('"+item.name.replace("\'","\\\'")+"','"+item.fullview+"',false);\"/>";
	}

	button +=		"<\/div>";
    
	var fileName = item.name;
    fileName = fileName.replace(/^\d+_/, "");
	var max=14;
	if ( item.type=='audio' )
		max = 28;
	if ( fileName.length>max )
        fileName = fileName.substr(0,max-3)+"...";
    
    
    var img = 	"<div class='med_item preview "+item.type+"' >"+
				"<div class='preview_normal'><img alt=\""+item.name.replace("\"","&quot;")+"\" title=\""+item.name.replace("\"","&quot;")+"\" src='"+item.preview+"' class='preview_normal file-preview' /><\/div>"+
				"<\/div>";
    it.append( img );
    
    
    it.append( 	"<div class='med_item options "+item.type+"'>"+ 
					button + 
					"<div class='med_item desc "+item.type+"'>"+fileName+"<\/div>"+ 
				"<\/div>" );
    
    
}

function createList( src, dst ) {
    for ( var i=0; i<src.length; i++ ) {
        addItem( src[i], i, dst );
    }
}
EOP;
        
        Yii::app()->getClientScript()->registerScript("MediaSelectBaseScripts", $script, CClientScript::POS_BEGIN );
	}
    
	/**
	 * Renders the body part.
	 */
	public function run()
	{
        if ( !Yii::app()->request->isAjaxRequest )
            $this->registerClientScript();
        
        $data = $this->data;
        $file = new PlaylistItem();
		
		if ( $this->type!='script' && $this->type!='delscript' )
			$this->render("MediaSelectView", array( "data"=>$data,                                             
													"id"=>$this->id,
                                                    "title"=>$this->title,
                                                    "desc"=>$this->desc,)
                                                     );
	}
}
