<?php
/**
 * Tip is a widget displaying tips at the bottom.
 *
 */
class Tip extends CWidget
{
	public $title=false;
    public $desc=false;
    public $class="";
    
	public function run()
	{
    
        $tipscript =<<<EOL
function switchTip( node ){
    var n=0; 
    $(".tip", node).each(function(){ 
        if ( !$(this).hasClass("hidden")) {
            $(this).addClass("hidden");
            n=1;
        } else if (n){
            $(this).removeClass("hidden");
            n=0;
        }
    });
    if (n){
        $(".tip", node).first().removeClass("hidden");
    }
}
EOL;
        if ( $this->title===false ){
            Yii::app()->getClientScript()->registerScript("tipscript", $tipscript, CClientScript::POS_BEGIN);
            return;
        }
            
        $baseclass="tip ";
        if ( !is_array($this->title) ) {
            $this->title = array($this->title);
            $this->desc = array($this->desc);
            //echo CHtml::openTag("div", array( 'class'=>'tip-group' ) );
        }
        $nb = count($this->title);
        if ( $nb>1 ) {
            Yii::app()->getClientScript()->registerScript("tipscript", $tipscript, CClientScript::POS_BEGIN);
            echo CHtml::openTag("div", array( 'onclick'=>'switchTip($(this));', 'title'=>Yii::t('app', "Click for more Tips"), 'class'=>'tip-group click-cursor' ) );
        } else
            echo CHtml::openTag("div", array( 'class'=>'tip-group' ) );
    
        $r = rand(0, $nb-1);
        for ($i=0; $i<$nb; $i++ ) {
            if ( $r==$i )
                echo CHtml::openTag("div", array('class'=>$baseclass.$this->class) );
            else
                echo CHtml::openTag("div", array('class'=>'tip hidden '.$this->class) );
        
            echo Chtml::tag("div", array('class'=>'tip-image'), CHtml::image("images/tip.gif", Yii::t('app','Tip')) );
            
            echo CHtml::openTag("div", array('class'=>'tip-desc') );
            $names = explode(" ", $this->title[$i], 2);
            if ( count($names)==1 ){
                echo Chtml::tag("div", array('class'=>'tip-header'), Chtml::tag("span", array('class'=>''), str_replace("_"," ",$names[0])) 
                            );
            
            } else {
                echo Chtml::tag("div", array('class'=>'tip-header'), Chtml::tag("span", array('class'=>''), str_replace("_"," ",$names[0])) . " " .
                                                                 Chtml::tag("span", array('class'=>'blue'), $names[1] )
                            );
            
            }
            
            echo Chtml::tag("div", array('class'=>'tip-content'),   $this->desc[$i] );
            
            echo CHtml::closeTag("div" ); //tip-desc
            
            echo CHtml::tag("div", array('class'=>'tip-stop'), " " );
            echo CHtml::closeTag("div" ); //tip
        }
        echo CHtml::closeTag("div" );
        
        
	}

	
}