<?php
class UploadMedia extends CWidget{
	
    public $id=0;
    public $dest="files/upload";
    public $desc;
    public $title;
    public $reload=false;
	public $scriptOnly=false;
	public $noScript=false;
	public $class='top-button';
    
    public function init(){
        $this->desc=Yii::t('app',"Upload file:". " ");
        $this->title=Yii::t('app', "New");
    
    }
    //***************************************************************************
	// register clientside widget files
	//***************************************************************************
	protected function registerClientScript(){
        Yii::app()->getClientScript()->registerCoreScript('jquery');
        Yii::app()->getClientScript()->registerScriptFile(Yii::app()->request->baseUrl."/scripts/fileuploader.js");
		if($this->reload) 
			$reload = $this->reload;
		else
			$reload = "";
		$action = CHtml::normalizeUrl(array($this->dest));
		$name = CHtml::activeName(new FileItem, "[$this->id]file");
		$uploading = Yii::t('app',"Uploading");
        $buttontitle = Yii::t('app',"Add");
		
		$class = $this->class;
	
$script =<<<EOL
//$(function() {

    function addButton( id, url, name ) {
        var parent=$('#'+id);
		if ( $('#'+id).length==0 ) return;
        
        var action_url = url || '$action';
        var dstname = name || '$name';
        var fileId = "#"+id+"_UploadFile";
		var nameId = "#"+id+"_UploadName";
		var spanId = "#"+id+"_UploadSpan";
        
        var uploader = new qq.FileUploader({
            element: document.getElementById(id),
            action: action_url,
            params: { ajax: '1'
                  },
             template: '<div class="qq-uploader">' + 
                '<div class="qq-upload-drop-area"><span><\/span><\/div>' +
                '<div class="$class button qq-upload-button" id=\''+id+'_UploadButton\' >$buttontitle<\/div>' +
                '<ul class="qq-upload-list hidden"><\/ul>' + 
                "<div id='"+id+"_UploadFile' style='display:none'>" +
                "<span><img class='loading' src='css/images/loadingAnimation.gif' alt='' /><\/span>" +
                "<span id='"+id+"_UploadName'>Uploading<\/span>" +
                "<\/div>" +
                "<span id='"+id+"_UploadSpan'> <\/span>" +
             '<\/div>',
            onSubmit: function(id, file) {
                //$(buttonId).hide(); 
                $(nameId).html("$uploading "+file);
                $(fileId).show();
            },
            onProgress: function(id, fileName, loaded, total){},
            onCancel: function(id, fileName){},
            onComplete: function(id, file, response) {    
                //$(buttonId).show(); 
                $(fileId).hide();
				var ok=true;
                if ( response!=null ) {
                    var dest = $(spanId).empty();
                    var txt = "";
					var time = 2000;
                    if ( !response.success ) {
                        txt += "<div class='errorSummary fileError'>";
                        txt += response.errors.replace(/\\n/g,'<br/>');
                        txt +="<div/>";
						ok=false; 
						time = 10000;
                    }
                    if ( response.nbFiles>0 ) {
                        txt +="<div class='upload_preview' >";
                        for (i=0; i<response.nbFiles && i<11; i++) {
                            txt += "<img src='"+response[i].preview+"' />";
                        }
                        txt +="<\/div>";                    
                    }
                    dest.html(txt);
                    
                    if ( response.nbFiles>5 ) time = 5000;
                    var remove=$(spanId).children();
                    var t=setTimeout(function() {remove.fadeOut('slow');}, time );
                    dest.children().click(function () { dest.children().fadeOut("slow"); });
                }
				if ( ok ) {
					$reload
				}
            }
        });
    }
    
/*
	function addButton( id, url, name ) {
		var parent=$('#'+id);
		if ( $('#'+id).length==0 ) return;
		parent.html(	"<input id='"+id+"_UploadButton' class='$class button' name='yt0' type='button' value='$buttontitle' alt='$buttontitle' />" +
						"<div id='"+id+"_UploadFile' style='display:none'>" +
						"<span><img class='loading' src='css/images/loadingAnimation.gif' alt='' /><\/span>" +
                        "<span id='"+id+"_UploadName'>Uploading<\/span>" +
						"<\/div>" +
						"<span id='"+id+"_UploadSpan'> <\/span>"
					); 
		activateButton( id, url, name );
	}
	
	function activateButton( id, url, name ) {
		var buttonId = "#"+id+"_UploadButton";
		var fileId = "#"+id+"_UploadFile";
		var nameId = "#"+id+"_UploadName";
		var spanId = "#"+id+"_UploadSpan";
		
        var action_url = url || '$action';
        var dstname = name || '$name';
		if ( $(buttonId).length==0 ) return;
        
            
        
		new AjaxUpload(buttonId, {
            action: action,
            name: dstname,
            data: { ajax: '1'
                  },
            autoSubmit: true,
            onChange: function(file, extension){},
            onSubmit: function(file, extension) {
                //$(buttonId).hide(); 
                $(nameId).html("$uploading "+file);
                $(fileId).show();
            },
            onComplete: function(file, response) {    
                //$(buttonId).show(); 
                $(fileId).hide();
				var ok=true;
                if ( response.length>0 ) {
                    
                    var myObject =jQuery.parseJSON(response); //
                    var dest = $(spanId).empty();
                    var txt = "";
					var time = 2000;
                    if ( !myObject.success ) {
                        txt += "<div class='errorSummary fileError'>";
                        txt += myObject.errors;
                        txt +="<div/>";
						ok=false; 
						time = 10000;
                    }
                    if ( myObject.nbFiles>0 ) {
                        txt +="<div class='upload_preview' >";
                        for (i=0; i<myObject.nbFiles && i<11; i++) {
                            txt += "<img src='"+myObject[i].preview+"' />";
                        }
                        txt +="<\/div>";                    
                    }
                    dest.html(txt);
                    
                    if ( myObject.nbFiles>5 ) time = 5000;
                    var remove=$(spanId).children();
                    var t=setTimeout(function() {remove.fadeOut('slow');}, time );
                    dest.children().click(function () { dest.children().fadeOut("slow"); });
                }
				if ( ok ) {
					$reload
				}
            }
		});
    
	}
    */
//});
EOL;
			Yii::app()->getClientScript()->registerScript("UploadMediaBaseScripts", $script, CClientScript::POS_BEGIN );
		}
	//***************************************************************************
	// Run the widget
	//***************************************************************************
	public function run(){
        
        $apple = array('iPhone', 'iPod', 'iPad');
        foreach ($apple as $name ) {
            if ( strpos($_SERVER['HTTP_USER_AGENT'],$name)!==false ){
                //get version
                $matches = array();
                if ( preg_match("/Version\/(\d+)(\.\d+)* Mobile/", $_SERVER['HTTP_USER_AGENT'], $matches) ) {
                    $version = intval($matches[1],10);
                    if ( $version<6 )
                        return;
                }
            }
        }
		if ( !Yii::app()->request->isAjaxRequest ) {
			$this->registerClientScript();
			if ( $this->scriptOnly ) return;
		}
		
		echo CHtml::openTag("div", array("class"=>"upload_info", 'id'=>"ButtonArea", 'title'=>Yii::t('app',"Add")))."\n";
		
		
		echo CHtml::closeTag("div")."\n";
		
		if ( !Yii::app()->request->isAjaxRequest )
			echo CHtml::script("$(function() { addButton('ButtonArea'); });");
	}
}