<?php
class WebUser extends CWebUser {
	
	public $roles = array();
    public $settings;
    public $activated = false;
	protected $autentication_path = "";
	
	public function init() {
		parent::init();
        $roles = $this->getState('roles');
        if ( $roles != null ) {
            $this->roles = explode(',',trim($roles));
        }
        $language = $this->getState('language');
        
        if ( !$this->isGuest && ($roles==null || $roles="") ) {
            // need to get them for the users settings
            $record = User::find($this->id);
            if ( $record  ) {
                
                $this->setRoles($record->getRoles());
                $this->setLanguage($record->language);
            }
        }
        
        $this->settings = new InterfaceSettings();
        $this->settings->loadSettings();
		
        if ($language=='auto' || $language=="")
			Yii::app()->setLanguage( Yii::app()->getRequest()->getPreferredLanguage() );
		else
			Yii::app()->setLanguage( $language );
        if ( file_exists( "/etc/apache/conf.d/95-raperca-ro.conf" ) )
            $this->activated = true;
        
        $this->autentication_path = ini_get( 'session.save_path' );
	}
    public function setLanguage( $language ) {
		$this->setState('language', $language);
        
		if ($language=='auto')
			Yii::app()->setLanguage( Yii::app()->getRequest()->getPreferredLanguage() );
		else
			Yii::app()->setLanguage( $language );
	}
    public function setShownews( $shownews ){
        $this->setState('shownews', $shownews);
    }
	public function getShownews(  ){
        return $this->getState('shownews');
    }
    public function setRoles( $roles ) {
        $this->roles = $roles;
        if ( count($roles)>0 ) {
            $roles_state = trim( implode(",", $roles) );
            $this->setState('roles', $roles_state);
        }
    }
    
    public static function deleteLastAction ( $name="" ) {
        if ( $name=="" ) {
            if ( $handle = opendir( Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR ) ) {
                while ( false !== ( $file = readdir($handle) ) ) {
                    if ( substr( $file,0,8) == "actions_" ) {
                        unlink( Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.$file );   
                    }                
                }
            }
        } else {
            $fn = Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR."actions_".$name.".txt";
            if ( file_exists( $fn ) )
                unlink( $fn );
        }
    }
    public function setLastAction( $action ) {
        $fn = Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR."actions_".$this->name.".txt";
        file_put_contents( $fn, serialize($action) );
    }
    public function getLastAction( ) {
        $fn = Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR."actions_".$this->name.".txt";
        if ( file_exists( $fn ) )
            return unserialize( file_get_contents( $fn ) );
        else 
            return array();
    }
    public function setLastSlides( $action ) {
        $this->setState('slides', serialize($action));
    }
    public function getLastSlides( ) {
        return unserialize($this->getState('slides'));
    }
    
    public function getRoles( ) {
        return $this->roles;
    }
	
    public function checkAccess($operation, $params=array ( ), $allowCaching=true) {
        if ( !$this->activated )
            return false;
        
        // custom operation
        if ( $operation=="createSlide" && in_array( "slide", $this->roles) ){
            if ( $this->settings->playlistAllowedSlide && in_array( "playlist", $this->roles) ) return true;
            if ( $this->settings->slideshowAllowedSlide && in_array( "program", $this->roles) ) return true;
            //if ( $this->settings->slideAllowedSlide ) return true;
        }
        if ( $operation=="createPlaylist" && in_array( "playlist", $this->roles) ){
            if ( $this->settings->playlistAllowedPlaylist && in_array( "playlist", $this->roles) ) return true;
            if ( $this->settings->slideshowAllowedPlaylist && in_array( "program", $this->roles) ) return true;
            if ( in_array( "slide", $this->roles) ) return true;
        }
        
        if ( in_array($operation, $this->roles) )
            return true;
        if ( $operation=="slide" && in_array( "edit", $this->roles) )
            return true;
        
        return parent::checkAccess( $operation, $params, $allowCaching );
    }
    
    public function addAllUsers() {
        if ( !$this->activated )
            return array( 'dummy_user_that_do_not_exist' );
        return array('@');
    }
    public function addUserByRoles ( $operation ) {
        if ( !$this->activated )
            return array( 'dummy_user_that_do_not_exist' );
            
        if ( $this->checkAccess( $operation ) )
            return array( $this->name );
        else 
            return array( 'admin' );
    }
    public function login( $identity, $duration=0 ){
        parent::login( $identity, $duration );
        $id = yii::app()->getSession()->getSessionID();
        
        touch( $this->autentication_path ."/auth_".$id );
        
    }
    public function logout( $destroySession=true ){
        $id = yii::app()->getSession()->getSessionID();
        unlink( $this->autentication_path ."/auth_".$id );
        
        parent::logout( $destroySession );
    }
}
