<?php

if ( Yii::app()->request->isAjaxRequest ) {
    $reply = array();
    $nbmedia = 0;
    foreach( $data as $n => $file ){ 
		if ($file->type=="playlist") 
            $view = CHtml::normalizeUrl(array("playlist/view", "partial"=>true, "id"=>$file->id, 'height'=>'auto', 'width'=>476));
        elseif ($file->type=="slide") 
            $view = CHtml::normalizeUrl(array("slides/preview", "id"=>$file->id, 'height'=>'auto', 'width'=>480));
        elseif ($file->type=="image" || $file->type=="audio" || $file->type=="video") 
            $view = $file->webpath;
        else 
            $view = null;
        
        $reply[]=array(	"name"=>$file->name, 
						"id"=>$file->id, 
						"preview"=>$file->webpathPreview, 
						"type"=>$file->type, 
						'fullview' => $view,
						'link' => $file->linkpathTemplate
					);
        $nbmedia++;
    }
    $reply['nbMedia'] = $nbmedia;
    if ( $title!==null && $desc!==null ){
        $reply['tip'] = $this->widget('application.components.Tip',array(   'title' => $title, 'desc' => $desc ), true);
    }
    echo json_encode($reply);
} else {

    // create the media table in JS:
    $script = "var media_$id = new Array();\n";
    foreach( $data as $n => $file ){ 
        $script .= "media_{$id}[$n] = new mediaItem(";
        $script .= "\"".$file->id."\",";
        $script .= "\"".$file->name."\",";
        $script .= "\"".$file->linkpathTemplate."\",";
        $script .= "\"".$file->webpathPreview."\",";
        
        if ($file->type=="playlist") 
            $script .= "\"".CHtml::normalizeUrl(array("playlist/view", "partial"=>true, "id"=>$file->id, 'height'=>'auto', 'width'=>476))."\",";
        elseif ($file->type=="slide") 
            $script .= "\"".CHtml::normalizeUrl(array("slides/preview", "id"=>$file->id, 'height'=>'auto', 'width'=>480))."\",";
        elseif ($file->type=="image") 
            $script .= "\"".CHtml::normalizeUrl($file->webpath)."\",";
        else 
            $script .= "null,";
        
        $script .= "\"".$file->type."\"";
        $script .= ");\n";
    }

    //$script .= "jQuery( function() { createList( media_$id, $('#file-list-$id') );  } );\n";
    $script .= "createList( media_$id, $('#file-list-$id') );\n";
    echo CHtml::tag("div",  array('class'=>'media_list'), 
                            CHtml::tag("ul", array('class'=>'file-list', 'id'=>"file-list-$id"), ""  ).
                            CHtml::tag("div", array('class'=>'file_end'), " ")
                )."\n";
     if ( $title!==null && $desc!==null ){
        echo CHtml::tag("div",  array('class'=>'tip-media'), 
                                $this->widget('application.components.Tip',array(   'title' => $title, 'desc' =>   $desc ), true )
                        );
    }
    echo CHtml::script("$(function () { ".$script." });")."\n";
}
