<?php

// uncomment the following to define a path alias
// Yii::setPathOfAlias('local','path/to/local-folder');

// This is the main Web application configuration. Any writable
// CWebApplication properties can be configured here.
return array(
	'basePath'=>dirname(__FILE__).DIRECTORY_SEPARATOR.'..',
	'name'=>'SpinetiX Fusion',
    'defaultController'=>'users',
    
    'sourceLanguage'=>'en',
    
    'runtimePath'=>'/var/lib/fusion/data/',
    
	// preloading 'log' component
	//'preload'=>array('log'),

	// autoloading model and component classes
	'import'=>array(
		'application.models.*',
		'application.components.*',
	),

	// application components
	'components'=>array(
		'session'=>array(
		 	'sessionName'=>'fusionsess'
		),
		'messages'=>array(
			'class'=>'CGettextMessageSource',
			'useMoFile'=>true,
		),
		'user'=>array(
			// enable cookie-based authentication
			'allowAutoLogin'=>true,
            'class'=>'application.components.WebUser', // using custom WebUser class for the autentification
            'loginUrl'=>array('users/login'),

		),
	),

	// application-level parameters that can be accessed
	// using Yii::app()->params['paramName']
	'params'=>array(
		// this is used in contact page
		'adminEmail'=>'support@spinetix.com',
	),
);