<?php

class LayoutController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='list';
    
    public function filters()
    {
        return array(
            'accessControl',
        );
    }
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array('list'),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('allow',
                'actions'=>array('create', 'configure', 'modify'),
                'users'=> Yii::app()->user->addUserByRoles('layout'),
            ),
            array('deny'),
        );
    }
    
    public function actionConfigure()
    {
        $crit = new CDbCriteria;
        $crit->condition = "type=:type";
        
        $crit->params = array( ":type"=>"project" );
        $projects = FileItem::findAll($crit);
        $playlists = Playlist::findAll( );
        $crit->params = array( ":type"=>"image" );
        $images = FileItem::findAll($crit);
        $crit->params = array( ":type"=>"video" );
        $videos = FileItem::findAll($crit);
        $crit->params = array( ":type"=>"audio" );
        $sounds = FileItem::findAll($crit);
        
        $feeds = Feeds::findAll();
        
		$file = new LayoutItem( );
        
        $this->render('configure', array(  
		                                'file' => $file, 
                                        'project' => $projects, 
                                        'playlist' => $playlists,
                                        'image' => $images,
                                        'video' => $videos,
                                        'audio' => $sounds,
                                        'datafeeds' => $feeds,
                                        ) );
    }
	public function actionList()
    {
        $status = FileItem::getMeta();
        
        $index = new LayoutItem();
        $layouts = $index->getLayoutList();
        
        if ( count($layouts)>0 ){
            $status['layout'] = count($layouts);
            $s = $index->source;
            if ( $s!="" )
                $status['selected'] = $s;
            FileItem::putMeta( $status );
        }
        
		if (Yii::app()->request->isAjaxRequest ){
            Yii::app()->user->returnUrl = array('settings/settings', 'page'=>'skin');
			$this->renderPartial('list', array(  
											'index'=>$index,
											'layouts'=>$layouts,
									)
					);
		}else{
			$this->render('list', array(  
												'index'=>$index,
												'layouts'=>$layouts,
										)
						);
        }
	}
	
	public function actionModify()
	{
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
        if (isset($_POST['action']) && $_POST['action']=='Cancel') {
            unset ($_GET['id']);
        }
        
        if ( isset( $_POST['TemplateEntry'] ) && (!isset($_POST['action']) || $_POST['action']!='Cancel') ) {
            
            $fields = array();
            foreach ( $_POST['TemplateEntry'] as $item ) {
                $entry = new TemplateEntry( "modify" );
                $entry->attributes = $item;
                $fields[] = $entry;
            }
            
            $file = new LayoutItem( );
            if ( isset($_GET['id']) && $_GET['id']!="index" && $_GET['id']!=$file->source ) {
				$pid = $file->getProgramId();
                $file1 = new LayoutItem( $_GET );
                $file->delete();// remove the old one
                if ( !$file1->create( true ) )
                    throw new CHttpException(500,Yii::t('app', 'Cannot create skin.'));
				$file->changeProgramId( $pid );
            }
                
            $file->setFields( $fields );
            
            if ( $file->save() ) {
                if ( Yii::app()->request->isAjaxRequest )                       
                    return;
				else
					return $this->redirect( Yii::app()->user->returnUrl );
            }
        }
		if (isset($_POST['action']) && $_POST['action']=='Cancel')
			return $this->redirect( Yii::app()->user->returnUrl );
        
        return $this->actionConfigure();
		
	}

    public function actionCreate()
	{
        if ( isset($_GET['id']) ) {
            $file = new LayoutItem( );
			$pid = $file->getProgramId();
            $file->delete();// remove the old one
            
			$file = new LayoutItem( $_GET );
            $redirect = $file->isBuiltIn( $file->id );
            
			if ( !$file->create( true ) )
                throw new CHttpException(500,Yii::t('app', 'Cannot create layout.'));
			$file->changeProgramId( $pid );
            
            if ( $redirect  )
                return $this->redirect( Yii::app()->user->returnUrl );
        } 
        return $this->actionConfigure();
	}
}