<?php

class SlidesController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='list';
    
    public function filters()
    {
        return array(
            'accessControl',
        );
    }
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array('list', 'preview'),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('allow',
                'actions'=>array('create', 'modify', 'delete', 'preview', 'showPreview'),
                'users'=> Yii::app()->user->addUserByRoles('slide'),
            ),
            array('deny'),

        );
    }
    
  
	public function actionList()
	{
        $status = FileItem::getMeta();
        
        $slides = SlideItem::findAll( );
        if ( count($slides)>0 ){
            $status['slide'] = count($slides);
            FileItem::putMeta( $status );
        }
		$meta=array();
		foreach ($slides as $slide ) {
			$m = $slide->loadMeta();
			if ( isset($m['previews']) )
				$meta[$slide->id] = $m['previews'];
		}
        
        if ( Yii::app()->request->isAjaxRequest )
            $this->renderPartial('list', array( 'files' => $slides, 'previews' => $meta ));
        else {
            $crit = new CDbCriteria;
            $crit->condition = "type=:type";
            $crit->params = array( ":type"=>"template" );
            $templates = FileItem::findAll($crit);
            $folders = SlideItem::mapToFolder( $templates );
            $this->render('list', array( 'files' => $slides, 
										 'templates' => $templates,
                                         'folders' => $folders,                                         
										 'previews' => $meta, 
										 'options'=> array( 'hideEmpty'=>true )
										)
						);
            
            Yii::app()->user->returnUrl = array('slides/list');
        }
	}

    protected function editSlide( $file, $delcancel=false, $save=true, $partial=false ) 
    {
        if ( 0 && ( $partial || $save==false) ) { // we need it for the preview, this might be a bit overkilled
			$projects = array();
			$playlists = array();
			$images = array();
			$videos = array();
			$sounds = array();
			$feeds = array();
		} else {
			$crit = new CDbCriteria;
			$crit->condition = "type=:type";
			
			$crit->params = array( ":type"=>"project" );
			$projects = FileItem::findAll($crit);
			$playlists = Playlist::findAll( );
			$crit->params = array( ":type"=>"image" );
			$images = FileItem::findAll($crit);
			$crit->params = array( ":type"=>"video" );
			$videos = FileItem::findAll($crit);
			$crit->params = array( ":type"=>"audio" );
			$sounds = FileItem::findAll($crit);
			
			$feeds = Feeds::findAll();
		}
        if ( $delcancel )
		    $title = Yii::t('app', "New Slide");
        else if ($file->type=="slide")
		    $title = Yii::t('app', "Slide");
		else {
			$title = Yii::t('app', "Template");           
            SlideItem::removeFolderName( $file->name );
        }
		$nosave = false;
        if ( $partial ) {
            $this->layout = 'partial';
            $nosave = true;
        } 
        if ( !$save ) 
            $nosave = true;
        
        $this->render('modify', array(  'file' => $file, 
                                        'project' => $projects, 
                                        'playlist' => $playlists,
                                        'image' => $images,
                                        'video' => $videos,
                                        'audio' => $sounds,
                                        'datafeeds' => $feeds,
                                        'title' => $title,
                                        'nosave'=>$nosave,
                                        'saveas'=> Yii::app()->user->checkAccess("createSlide"),
                                        'delcancel'=>$delcancel,
                                        ) );
    }
    
    public function actionCreate()
	{
        if ( isset($_GET['id']) ) {
            $file = new SlideItem( $_GET );
            
            $file->scenario = 'create';
            $file->type = "template";
            if ( $file->create( false ) ) {
                $this->editSlide( $file, true );
                return;
            }
        }
        // problem
        throw new CHttpException(500,Yii::t('app', 'Cannot create slide.'));
        return $this->actionList();
	}
    public function actionPreview()
    {
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
        if ( isset($_GET['id']) )
            $id = $_GET['id'];
        else
            throw new CHttpException(500,Yii::t('app', 'Need an ID'));
        $file = new SlideItem( array('id'=>$id)  );
        $this->editSlide( $file, false, false, true );
        
    }
    public function actionModify()
	{

        if ( isset($_POST['action']) && $_POST['action']=='Cancel' ) {
            if ( isset($_POST['delcancel'] ) ){
                if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
                $file = new SlideItem( $_GET );
                $file->delete();
            }
            $this->redirect( Yii::app()->user->returnUrl );
            return;
        }
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
        if ( isset($_GET['id']) )
            $id = $_GET['id'];
        else 
            $id = "";
        
		$error=false;
		
        //print_r($_POST['TemplateEntry']);
        if ( isset($_POST['action']) && $_POST['action']=='SaveAs' && $_POST['SlideItem']['name']!="") {
            $file = new SlideItem( $_GET );
			$file->enablepreview = false;
			$oldname=$file->name;
            $file->name = $_POST['SlideItem']['name'];
			if ( $file->validate() ) {
				$file->copy();
				$id = $file->id;
				// fix the datafeeds entry
				foreach ( $_POST['TemplateEntry'] as &$item ) {
					if ( $item['type']=="datafeeds" ) {
						$file2 = new Feeds( array('id'=>$item['value']) );
						$file2->name = uniqid( $file->name."_" );
						$file2->copy();
						$item['value'] = $file2->id;
						
					}
				}
			} else {
				$file->name = $oldname;
				$error="copy";
			}
        } else if ( isset($_POST['rename']) && $_POST['rename']!="") {
            $file = new SlideItem( $_GET );
			$oldname=$file->name;
            $file->name = $_POST['rename'];
			if ( $file->validate() ) {
				$file->save();
				$id = $file->id;
			} else {
				$file->name = $oldname;
				$error="rename";
			}
        }
        
        if ( $error===false && isset( $_POST['TemplateEntry'] ) ) {
            $fields = array();
            $datafeeds = array();
            foreach ( $_POST['TemplateEntry'] as &$item ) {
                $entry = new TemplateEntry( "modify" );
                $entry->attributes = $item;
                $fields[] = $entry;
                if ( $entry->type=="datafeeds" && isset($_POST['data']) ) {
                    $file2 = new Feeds( array('id'=>$entry->value) );
                    $file2->setData( $_POST['data'] );
                    
                    if ( $file2->validate() ) {
            	        $file2->save();
                    }
                    
                }
            }
            
            if ( !isset($file) )
                $file = new SlideItem( array('id'=>$id) );
            
            $file->setFields( $fields );
            
			if ( isset($_POST['preview']) )
				$file->setPreviews( $_POST['preview'] );
            
            // make sure we pass on the paramters to the next version of the slide in case of problems.
            if ( isset($_POST['SlideItem']['itemPerPage']) )
                $file->itemPerPage = $_POST['SlideItem']['itemPerPage'];
            if ( isset($_POST['SlideItem']['viewBox']) )
                $file->viewBox = $_POST['SlideItem']['viewBox'];
                
            if ( $file->save() ) {
                $slides = Yii::app()->user->getLastSlides();
                if ( count($slides)==0 || $slides[0]['id']!=$file->id ){
                    if ( is_array($slides) )
                        array_unshift($slides,array( 'id'=>$file->id, 'name'=>$file->name)); 
                    else{
                        $slides = array();
                        $slides[] = array( 'id'=>$file->id, 'name'=>$file->name);
                    }
                    if ( count($slides)>3 )
                        array_splice($slides, 3);
                    Yii::app()->user->setLastSlides($slides);
                }
                $actions['action']='slides';
                $actions['id']=$file->id;
                $actions['name']=$file->name;
                Yii::app()->user->setLastAction( $actions );
                if ( Yii::app()->request->isAjaxRequest )
                    return;
                if ( !isset($_POST['apply']) && (!isset($_POST['action']) || $_POST['action']!='SaveAs')){
                    $this->redirect( Yii::app()->user->returnUrl );
                    return;
                }
            }
        }
        
        if ( $id !="" ) {
            if ( !isset($file) )
                $file = new SlideItem( array('id'=>$id)  );
            
			if ( $error=="rename" )
				$this->editSlide( $file, true );
			else 
				$this->editSlide( $file );
        } 
	}
    public function actionShowPreview()
	{
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
        if ( isset($_GET['id']) )
            $id = $_GET['id'];
        else 
            $id = "";
        // create temp folder for the preview
        $file = new SlideItem( $_GET );
        $file->name = ".preview";
        $file->copy();
        $id = $file->id;
        // fix the datafeeds entry
        foreach ( $_POST['TemplateEntry'] as &$item ) {
            if ( $item['type']=="datafeeds" ) {
                $file2 = new Feeds( array('id'=>$item['value']) );
                $file2->name = uniqid( $file->name."_" );
                $file2->copy();
                $item['value'] = $file2->id;
                
            }
        }
        
        if ( isset( $_POST['TemplateEntry'] ) ) {
            $fields = array();
            $datafeeds = array();
            foreach ( $_POST['TemplateEntry'] as &$item ) {
                $entry = new TemplateEntry( "modify" );
                $entry->attributes = $item;
                $fields[] = $entry;
                if ( $entry->type=="datafeeds" && isset($_POST['data']) ) {
                    $file2 = new Feeds( array('id'=>$entry->value) );
                    $file2->setData( $_POST['data'] );
                    
                    if ( $file2->validate() ) {
            	        $file2->save();
                    }
                    
                }
            }
            
            $file->setFields( $fields );
                
            $file->save();
        }
        
        echo $file->getWebpathPreview();
        // render the preview
        //$this->layout = 'partial';
        //$this->render( 'preview', array(  'file' => $file, ) );
        // cleaup after use
        //$file->delete();
	
	
	}
    
    public function actionDelete()
	{
        if ( isset($_POST['id']) ) $_GET['id']=$_POST['id'];
		if ( isset($_GET['id']) ) {
            $file = new SlideItem( $_GET );
            if ( !$file->delete() )
                throw new CHttpException(500,Yii::t('app', 'The requested file does not exist or cannot be deleted.'));
            if ( Yii::app()->request->isAjaxRequest ) $this->actionList();
            else $this->redirect( Yii::app()->user->returnUrl );
        } 
        
	}
    
}