<?php

class UsersController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='login';
    protected $fusionBackup = "fusion-default.7z";
    protected $fusionPublish = "publish/fusion-default.7z";
    protected $fusionDefault = "/usr/share/resources/default/content/fusion-default.7z";
    
    protected $systemFileVersion = 4;
    
    public function filters()
    {
        return array(
            'accessControl',
        );
    }
    public function accessRules()
    {
        return array(
            array('allow',
                'actions'=>array('logout', 'update'),
                'users'=>Yii::app()->user->addAllUsers(),
            ),
            array('allow',
                'actions'=>array('create', 'list', 'update', 'updateadmin', 'delete'),
                'users'=> Yii::app()->user->addUserByRoles('admin'),
            ),
            array('allow',
                'actions'=>array('login'),
            ),
            array('deny'),
        );
    }

	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
        $meta = FileItem::getMeta();
		
		
        if ( Yii::app()->user->activated ) {
            
            // fusion activated
            
            if ( !isset( $meta['version'] ) || $this->systemFileVersion > intval($meta['version']) ){
                // I have nothing in my sytem, or I need to update
				$meta = array();
                $meta['version'] = $this->systemFileVersion;
                
				$meta['media'] = false;
				$meta['image'] = false;
				$meta['video'] = false;
				$meta['project'] = false;
				$meta['audio'] = false;
				
				$meta['program'] = false;
				$meta['activate'] = false;
				$meta['slide'] = false;
				$meta['template'] = false;
				
				$meta['playlist'] = false;
				
				$meta['layout'] = false;
                $meta['selected'] = false;
				
				$meta['lastaction']['name']=false;
                if ( !file_exists( FileItem::$contentpath."/.tmp" ) )
                    mkdir( FileItem::$contentpath."/.tmp" );
                if ( !file_exists( FileItem::$contentpath."/.fusion_enabled") )
                    mkdir( FileItem::$contentpath."/.fusion_enabled" );
                if ( !file_exists( FileItem::$contentpath."/publish/" ) )
                    mkdir( FileItem::$contentpath."/publish/" );
				if ( !file_exists( FileItem::$contentpath."/fonts/" ) )
                    mkdir( FileItem::$contentpath."/fonts/" );
                // cleanup last actions
                WebUser::deleteLastAction();
                
                if ( SystemBackup::createFolders() ) { // make sure the structure exist
                    
                    if ( file_exists( FileItem::$contentpath.$this->fusionBackup ) ) {
                        $backup = new SystemBackup( array( "filepath"=>FileItem::$contentpath.$this->fusionBackup ) );
                        $backup->restoreBackup();
                        unlink( FileItem::$contentpath.$this->fusionBackup );
                    } else if ( file_exists( FileItem::$contentpath.$this->fusionPublish ) ) {
                        $backup = new SystemBackup( array( "filepath"=>FileItem::$contentpath.$this->fusionPublish ) );
                        $backup->restoreBackup();
                    } else  if ( file_exists( $this->fusionDefault ) ) {
                        $backup = new SystemBackup( array( "filepath"=>$this->fusionDefault ) );
                        $backup->restoreBackup();
                    }
                }
                LayoutItem::createBasefiles();
                FileItem::createSystemFile();
				FileItem::putMeta( $meta );
                
                // make sure that the user must log in, in case we created the structure.
                Yii::app()->user->logout();
                
                // Make sure we use the default language
                Yii::app()->setLanguage( Yii::app()->getRequest()->getPreferredLanguage() );
            }
            
        }
        if ( !User::hasUsers() ){
            $meta['user'] = false;
        } else {
            $meta['user'] = User::count();
        }
		$user=new User;
		// collect user input data
		if(isset($_POST['User'])) {
            $user->setScenario('login');
			$user->attributes=$_POST['User'];
			// validate user input and redirect to previous page if valid
			$user->validate();
		}
		if ( isset($_GET['refresh']) )
            $refresh=true;
        else
            $refresh=false;
        $this->render('welcome',array('user'=>$user, 'status'=>$meta, 'refresh'=>$refresh ));
		
        Yii::app()->user->returnUrl = array('users/login', 'refresh'=>true );
        
		FileItem::putMeta( $meta );
    }

	/**
	 * Logout the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}
    
    public function actionCreate() {
		$newuser = new User;
		
		if (isset($_POST['User'])) {
			$newuser->setScenario('register');
			$newuser->setAttributes($_POST['User']);
			if ($newuser->validate()) {
				$newuser->save();
				$newuser = new User;
			}
		}
		$users = User::findAll( );
        $user = User::find( Yii::app()->user->id );
        
		if (Yii::app()->request->isAjaxRequest)
			$this->renderPartial('list', array('users'=>$users, 'newuser'=>$newuser, 'update'=>'new', 'currentUser'=>$user ));
		else
			$this->render('list', array('users'=>$users, 'newuser'=>$newuser, 'currentUser'=>$user ));
		
	}
    public function actionUpdateadmin() {
		$update="new";
		
		if ( isset($_POST['User']['username']) ){
			$username = $_POST['User']['username'];
			
			$user = User::find( $username );
			
            $user->setScenario( "updateAdmin" );
			
			if ( $user==NULL )
				throw new CHttpException(500,Yii::t('app', 'The requested user does not exist.'));
				
			$user->setAttributes($_POST['User']);
			
			if ($user->validate()) {
				$user->save();
				$newuser = new User;
				$update="new";
			} else {
				$newuser = $user;
				$update="changed";
			}
		}
		
		
		$users = User::findAll( );
		if (Yii::app()->request->isAjaxRequest)
			$this->renderPartial('list', array('users'=>$users, 'newuser'=>$newuser, 'update'=>$update ));
		else
			$this->render('list', array('users'=>$users, 'newuser'=>$newuser ));
    
	}
    public function actionUpdate() {
    
        //safe check
        if ( Yii::app()->user->isGuest )
            $this->redirect(Yii::app()->homeUrl);
        
        
		$username = Yii::app()->user->id;
		
        
        $user = User::find( $username );
		if ( $user==NULL )
            throw new CHttpException(500,Yii::t('app', 'The requested user does not exist.'));
		
		if ( isset($_POST['User']) ) {
			if ( $_POST['User']['old_password']=="" && $_POST['User']['new_password']==""  && $_POST['User']['repeat_password']=="" )
				$user->setScenario( 'settings' );
			else
				$user->setScenario( "update" );
			$user->setAttributes($_POST['User']);

			if ($user->validate()) {
				if ( $user->save() )
					$user = User::find( $username );
			}
		}
        if (Yii::app()->request->isAjaxRequest) {
			echo json_encode( array( "sucsess"=>true ) );
		} else
			$this->render("update", array('user'=>$user));
        
	}
    
    public function actionList() {

        

		if ( isset($_POST['User']) ) {
			$newuser = new User;
			$newuser->lock();
			$users = User::findAll( );
			
            foreach ($users as $i => &$user ) {
                if ( isset($_POST['User'][$i]) ) {
                    $user->setScenario( "updateRights" );
                    $user->setAttributes( $_POST['User'][$i] );
                    $valid=$valid && $user->validate();
                }
            }
            if ( $valid )
                User::saveUsers( $users );
			$newuser->unlock();
			
		} else {
			$users = User::findAll( );
			$newuser = new User;
		}
        $user = User::find( Yii::app()->user->id );
        
		if (Yii::app()->request->isAjaxRequest)
			$this->renderPartial('list', array('users'=>$users, 'newuser'=>$newuser, 'currentUser'=>$user ));
		else
			$this->render('list', array('users'=>$users, 'newuser'=>$newuser, 'currentUser'=>$user ));
    
    }
    public function actionDelete() {

        if ( isset($_GET['id']) ) {
            $username = $_GET['id'];
            if ( !User::find( $username )->delete() )
                throw new CHttpException(500,Yii::t('app', 'The requested user does not exist or cannot be deleted.'));
        }
    }
}