<?php

class InterfaceSettings extends CFormModel
{
    public static $settingsfile = "/var/lib/fusion/data/settings.txt";

    public $viewType="Simple"; // Simple, Advanced
    
    public $uploadAllowedImage=true;
    public $uploadAllowedVideo=true;
    public $uploadAllowedAudio=false;
    public $uploadAllowedHypermedia=true;
    
    public $playlistAllowedImage=true;
    public $playlistAllowedVideo=true;
    public $playlistAllowedAudio=false;
    public $playlistAllowedHypermedia=false;
    public $playlistAllowedPlaylist=false;
    public $playlistAllowedSlide=false;
    
    public $slideshowAllowedImage=true;
    public $slideshowAllowedVideo=true;
    public $slideshowAllowedAudio=false;
    public $slideshowAllowedHypermedia=true;
    public $slideshowAllowedPlaylist=true;
    public $slideshowAllowedSlide=true;
    
    public $playlistUseDuration=true;
    public $playlistUseSettings=true;
    public $playlistUseValidity=false;
    public $playlistUseVisible=false;
    public $playlistUseDates=false;
    
    public $slideshowUseDuration=true;
    public $slideshowUseSettings=false;
    public $slideshowUseValidity=true;
    public $slideshowUseVisible=true;
    public $slideshowUseDates=true;
    
    
    static $upload = array("Image", "Video", "Audio", "Hypermedia");
    static $playlist = array("Image", "Video", "Audio", "Hypermedia", "Slide", "Playlist");
    static $use = array("Duration", "Settings", "Validity", "Visible", "Dates");

    private function listAttribs() {
        $list = "viewType";
        foreach (self::$upload  as $txt)
            $list .= ",uploadAllowed".$txt ;
        foreach (self::$playlist as $txt )
            $list .= ",playlistAllowed".$txt ;
        foreach (self::$playlist as $txt )
            $list .= ",slideshowAllowed".$txt ;
        foreach (self::$use as $txt )
            $list .= ",playlistUse".$txt ;
        foreach (self::$use as $txt )
            $list .= ",slideshowUse".$txt ;
        return $list;
    }
    /**
	 * @return array validation rules for model attributes.
	 */
    public function rules() {
        
            
		return array(
            array( $this->listAttribs(), 'safe', 'on'=>'save' ),
    	);
	}

    /**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
            "Image" => Yii::t('app',"Images"),
            "Video" => Yii::t('app',"Video"),
            "Audio" => Yii::t('app',"Audio"),
            "Hypermedia" => Yii::t('app',"Hypermedia"),
            "Slide" => Yii::t('app',"Slides"),
            "Playlist" => Yii::t('app',"Playlists"),
            
            "Duration" => Yii::t('app',"Duration"),
            "Settings" => Yii::t('app',"Settings"),
            "Validity" => Yii::t('app',"Validity"),
            "Playlist" => Yii::t('app',"Playlists"),
            "Visible" => Yii::t('app',"Visible"),
            
            "viewType" => "Interface type",
		);
	}
    
    
    
    public function loadSettings() {

        // open the index file and read the uri
        if ( !file_exists( self::$settingsfile ) )
            return false;
        $index = file_get_contents( self::$settingsfile );
        if ( $index===false || $index=="" ) return false;
        
        $pfile = fopen(self::$settingsfile,"r");
        rewind($pfile);
        $settings = array();
        
        while (!feof($pfile)) {
            $line = fgets($pfile);
            if ($line[0]!='#') {
                $tmp = explode('=', $line);
                $name=trim($tmp[0]);
                if (isset($this->$name))
                    $this->$name = trim($tmp[1]);
            }            
        }
        fclose($pfile);
        return false;
        
    }
    
    public function save() {
        
        $pfile = fopen(self::$settingsfile,"w");
        if (!$pfile) return false;
        
        $safe = $this->rules();
        $allowed = explode( ",", $this->listAttribs() );
        
        foreach ($allowed as $name) {
            fwrite($pfile, "$name=". $this->$name ."\n");
        }
        fclose($pfile);
        
        return true;
    }

}
    