<?php

class PlayerSettings extends CFormModel
{
    public $width=1280;
    public $height=720;
    static public $indexpath = "index.svg";
    
    /**
	 * @return array validation rules for model attributes.
	 */

    public function rules() {
		return array(
            array( 'width, height', 'safe', 'on'=>'save' ),
    	);
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
		);
	}
    
    
    
    public function init() {

        // open the index file and read the uri
        $index = file_get_contents( self::$indexpath );
        if ( $index===false || $index=="" ) return false;
        $dom = new DOMDocument;
        if ( !$dom->loadXML( $index ) ) return false;
        
        $svg = $dom->getElementById("svg");
        if ( $svg==null ) return false;
        $viewBox = $svg->getAttribute( "viewBox" );
        list( $x, $y, $this->width, $this->height ) = explode(' ', $viewBox );
        
        return true;
        
    }
    
    public function save() {
        
        // open the index file and read the uri
        $index = file_get_contents( self::$indexpath );
        if ( $index===false || $index=="" ) return false;
        
        $dom = new DOMDocument;
        if ( !$dom->loadXML( $index ) ) return false;
        
        $svg = $dom->getElementById("svg");
        if ( $svg==null ) return false;
                
        $svg->setAttribute("viewBox", "0 0 {$this->width} {$this->height}");
        
        $anim = $dom->getElementById("anim");
        
        $anim->setAttribute("width", $this->width);
        $anim->setAttribute("height", $this->height);
        
        
        file_put_contents( self::$indexpath, $dom->saveXML() );
        return true;
    }

}
    