<?php

class PlaylistItem extends FileItem
{
    public $_dur=false;
    
    public $metaname="";
    
    public $validityStart="";
    public $validityEnd="";
    public $timeStart="";
    public $timeEnd="";
    
    public $validDate0=1;
    public $validDate1=1;
    public $validDate2=1;
    public $validDate3=1;
    public $validDate4=1;
    public $validDate5=1;
    public $validDate6=1;
    
    
    /**
	 * @return array validation rules for model attributes.
	 */

    public function rules() {
		return array(
            array('validityStart', 'match', 'pattern' =>"/\d{4} \d{2} \d{2}/" ),
            array('validityEnd', 'match', 'pattern' =>"/\d{4} \d{2} \d{2}/" ),
            array('dur, timeStart, timeEnd', 'match', 'pattern' =>"/^\d+:[012345]\d:[012345]\d$/" ),
            array('validDays', 'match', 'pattern' =>"/^\d*$/" ),
            array( 'id, svgdur, metaname, validDate0, validDate1, validDate2, validDate3, validDate4, validDate5, validDate6', 'safe' ),
    	);
	}

	/**
	 * Declares attribute labels.
	 */
	public function attributeLabels()
	{
		return array(
            "webpathPreview" =>Yii::t('app', "Preview"),
            "filename" => Yii::t('app',"Media"),
            "dur" => Yii::t('app',"Duration"),
            "validity" => Yii::t('app',"Dates"),
            "validityStart" => Yii::t('app',"Dates valid from"),
            "validityEnd" => Yii::t('app',"Dates valid to"),
            "time" => Yii::t('app',"Times"),
            "timeStart" => Yii::t('app',"Start time"),
            "timeEnd" => Yii::t('app',"End time"),
            "validDates" => Yii::t('app',"Days"),
            "action" => Yii::t('app',"Action"),
		);
	}
    
    public function setValidDays( $dates ) {
        if ( $dates=="" ) $dates="0123456";
        for ($i=0; $i<7; $i++ ) {
            $name="validDate$i";
            $this->$name=(strpos($dates , "$i")===false)?"0":"1";
        }
    }
    public function getValidDays() {
        $dates = "";
        for ($i=0; $i<7; $i++ ) {
            $name="validDate$i";
            if ( $this->$name==1 ) $dates.="$i";
        }
        if ( $dates=="0123456" ) $dates="";
        return $dates;
    }
    
    public function getDur() {
        return $this->_dur;
    }
    
    public function getSvgdur() {
        
        if ( $this->_dur=="" ) {
            if ( $this->type=="image" )
                return "indefinite";
            else
                return "media";
        } else {
            $val = explode(":", $this->_dur);
        
            if (count($val)==1)
                return $val[0];
            elseif (count($val)==2)
                return $val[0]*3600+$val[1]*60;
            elseif (count($val)==3)
                return $val[0]*3600+$val[1]*60+$val[2];
            else 
                return "indefinite";
        }
    }
    public function setSvgdur( $dur="" ) {
        
        if ( $dur=="" || $dur=="indefinite" || $dur=="media"){
            $this->_dur = "";
            return;
        }
        
        $s = intval($dur);
        $h = floor($s/3600);
        $s -= $h*3600;
        if ($h<10)
            $h = "0".$h;
        $m = floor($s/60);
        $s -= $m*60;
        if ($m<10)
            $m = "0".$m;
        if ($s<10)
            $s = "0".$s;
        
        $this->_dur = $h.":".$m.":".$s;
    }
    
    public function setDur( $dur="" ) {
    
        $this->_dur = $dur;
        
    }
}
    