<?php

class SystemBackup extends FileItem
{
  
    public $backupall=false;
    public $addfiles=false;
    public $clearall=false;
    public $clearbackup=false;
    
    function __construct($attributes=array ( ), $scenario='init') {
        $attributes["type"] = "backup";
        parent::__construct( $attributes, $scenario );
        
    }

 	public function rules() {
		return array(
            array( "name, type, id, addfiles", 'safe', 'on'=>'init' ),
            array( "name, backupall", 'safe', 'on'=>'create' ),
            array( "clearall, clearbackup", 'safe', 'on'=>'clear' ),
		);
	}

	public function attributeLabels()
	{
		return array(
            "backupall" => Yii::t('app',"Backup administration settings"), 
            "clearall" => Yii::t('app',"Clear administration settings"), 
            "clearbackup" => Yii::t('app',"Clear backups"),
            "file" => Yii::t('app',"File"),
            "name" => Yii::t('app',"Name"),
            "modificationDate" => Yii::t('app',"Modification Date"),
            "size" => Yii::t('app',"Size"),
		);
	}


    protected function addDir( $path, &$zip) {
        if ( !empty($path) )
            $zip->addEmptyDir($path);
        
        foreach (scandir( FileItem::folder().$path ) as $node) {
            if ($node == '.' || $node == '..') 
                continue;
            if ( is_dir( FileItem::folder().$path.$node ) ) {
                $this->addDir( $path.$node."/", $zip );
            } else if ( is_file( FileItem::folder().$path.$node ) )  {
                $zip->addFile( FileItem::folder().$path.$node, $path.$node );
            }
        }
    } 
    
    function createBackup( ) {
   
        if ( $this->name=="" )
            $this->name = Yii::t('app',"Default");
    
        if ( !$this->filepath ) return false;
        
        $paths = array();
        foreach ( FileItem::$paths as $type=>$path ) if ( !is_array($path) && $type!="backup") {
            $paths[] = $path;
        }
        if ( $this->backupall )  {
            $paths[] = Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR.User::$passwordfile;
        }
        if ( file_exists( FileItem::$contentpath ."fonts/" ) ) {
            $paths[] = "../fonts/";
        }
        $zip = new ZipHandler;
        
        $zip->createArchive( $this->filepath, $paths, FileItem::folder(""));
            
    }
    
    function restoreBackup(  ) {
        
        // cleanup
        if ( !$this->addfiles )
            $this->clearAll( );
        
        
        $zip = new ZipHandler;
        if ( $this->file ) {
            if ( !$zip->open( $this->file->tempName, "7z", false ) ) {
                $this->addError('file', $zip->error );
                return false;
            }
        } else {
            if ( !$zip->open( $this->filepath, "7z", false ) ){
                $this->addError('file', $zip->error );
                return false;
            }
        }
        if ( $zip->extractFolderTo( FileItem::folder(""), "*/", "fonts" )===false ){
            $this->addError('file', $zip->error );
            return false;
        }
        if ( $zip->extractFolderTo( FileItem::$contentpath, "fonts/", "", true )===false ){
            $this->addError('file', $zip->error );
            return false;
        }
        if ( $zip->extractFfileTo( Yii::app()->getRuntimePath().DIRECTORY_SEPARATOR, array( User::$passwordfile ) )===false){
            $this->addError('file', $zip->error );
            return false;
        }
        
        touch( self::$contentpath."index.svg" );
        
        return true;
    }
    
    function clearAll( ) {
        foreach ( FileItem::$paths as $type=>$path ) if ( !is_array($path) && ( $this->clearbackup  || $type!="backup" ) ) {
            $folder = FileItem::folder().$path;
            $this->delTree( $folder );
            if ( !file_exists( $folder ) )
                mkdir( $folder );
        }
        if ( $this->clearall ) {
            unlink( User::$passwordfile );
        }        
    }
    
    static function createFolders() {
        $createdFolder = false;
        if ( !file_exists( FileItem::folder() ) ) {
            mkdir( FileItem::folder() );
            $createdFolder = true;
        }
        foreach ( FileItem::$paths as $path ) if ( !is_array($path) ) {
            if ( !file_exists( FileItem::folder().$path ) )
                mkdir( FileItem::folder().$path );
        }
        return $createdFolder ;
    }
}