<?php 

if ( !isset($update) || !$update) {
    echo CHtml::tag("div", array('class'=>"bottom-button", 'id'=>'BackupButtonArea'), " " );
	echo CHtml::openTag("div", array( 'id'=>'Backup' ) );
}



echo CHtml::openTag("div", array('class'=>"backup-list") );

echo CHtml::openTag("div", array('class'=>"backup-item title") );
  
echo CHtml::tag("span", array('class'=>"backup-name"), CHtml::encode($file->getAttributeLabel('name')) );
echo CHtml::tag("span", array('class'=>"backup-date"), CHtml::encode($file->getAttributeLabel('modificationDate')) );
echo CHtml::tag("span", array('class'=>"backup-size"), CHtml::encode($file->getAttributeLabel('size')) );

echo CHtml::closeTag("div") ."\n"; //backup-item

foreach( $backups as $n => $item){

    echo CHtml::openTag("div", array('class'=>"backup-item") );
    
    echo CHtml::tag("span", array('class'=>"backup-name"), CHtml::encode($item->name) );
    echo CHtml::tag("span", array('class'=>"backup-date"), CHtml::encode($item->modificationDate) );
    echo CHtml::tag("span", array('class'=>"backup-size"), CHtml::encode($item->size) );
    
    echo CHtml::openTag("span", array('class'=>"backup-actions") );
    echo CHtml::openTag("div",  array() ); // needed because of the delete script
                            
    
    
    echo CHtml::link( CHtml::image( 'images/edit.gif', Yii::t( 'app','Download' ), array( 'class'=>'right', 'title'=>Yii::t( 'app','Download' ) ) ), $item->webpath );
    
    echo CHtml::link(   CHtml::image( 'images/restore.gif', Yii::t('app','Restore'), array( 'class'=>'right', 'title'=>Yii::t( 'app','Restore' )) ),
                        array('restore','id' => $item->id ), array( 'onclick'=>'tb_create_loader();')
                    );
                    
    echo CHtml::image( 'images/x.gif', Yii::t('app','Delete'), array(	'class'=>'del', 
																		'onclick'=>'ajaxSubmitDelete($(this));',
                                                                        'title'=>Yii::t( 'app','Delete' ),
																		'href'=>CHtml::normalizeUrl( array("backup/delete", "id"=>$item->id) )
																	) 
                    );
	echo CHtml::closeTag("div") ."\n"; 
    
    
    echo CHtml::closeTag("span") ."\n"; 
    
    echo CHtml::closeTag("div") ."\n"; //backup-item
}
echo CHtml::closeTag("div") ."\n"; //backup-list


echo CHtml::openTag("div", array('class'=>"new-backup", 'id'=>'NewBackup') );

echo CHtml::tag("h2", array( 'id'=>'TitleNewBackup'), Yii::t('app',"New Backup"));

echo CHtml::form(array("backup/create"));



echo CHtml::errorSummary($file); 
echo CHtml::openTag("div", array('class'=>'user_password backups', 'id'=>'NewBackup' ) );
echo CHtml::activeTextField($file,'name', array('title'=>$file->getAttributeLabel('name')) );

echo CHtml::activeCheckBox($file, "backupall");
echo CHtml::activeLabel($file,'backupall');

echo CHtml::closeTag("div") ."\n"; //user_password



echo CHtml::openTag("div", array('class'=>"bottom-button") );
echo CHtml::button(Yii::t('app', 'Create'), array(	"id"=>"CreateBackup",
												"onclick"=>"$('#NewBackup').fadeTo('slow', 0.2); $('.backup_loading').show(); ajaxSubmitReplace($(this),$('#Backup'))", 
												"class"=>"right-button button",
                                            )
                                    );
echo CHtml::closeTag("div") ."\n"; //button_line

echo CHtml::closeTag("form");

echo CHtml::closeTag("div") ."\n"; 

$title = $desc = array();
$title[] = Yii::t('app', "Tip Create Backup");
$desc[] =   Yii::t('app', "To backup the content of the current unit, enter the Backup name and press the Create button."). "<br/>".
            Yii::t('app', "Note that creating a Backup may take some time."); 

$title[] = Yii::t('app', "Tip Upload Backup");
$desc[] =   Yii::t('app', "You can upload a Fusion Backup to the unit using the Add button."). "<br/>".
            Yii::t('app', "Once the Backup has been uploaded, it can be restored to the unit using the Restore icon.");

if ( count($backups)>0 ){
    $title[] = Yii::t('app', "Tip Restore Backup");
    $desc[] =  Yii::t('app', "Restoring a backup will remove all the existing files from the device and replace them with the content of the backup.");
    
    
    $title[] =Yii::t('app', "Icon Description");
    $d =  "";  
    $d .= " ". CHtml::image('images/x.gif', Yii::t('app','Delete'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Delete'). " ";
    $d .=  CHtml::image('images/activate.gif', Yii::t('app','Restore'), array('class'=>'icon-desc')). " " .Yii::t('app','Restore'). " ";
    $d .=  CHtml::image('images/edit.gif', Yii::t('app','Download'), array('class'=>'icon-desc')) ." ". Yii::t('app','Download'). " ";  

    $desc[] = $d;
}



$this->widget('application.components.Tip',array(   'title' =>  $title, 'desc' => $desc ));


if ( !isset($update) || !$update) {
    echo CHtml::closeTag("div") ."\n"; 
}
