<?php

if( Yii::app()->user->checkAccess("model") ){
	echo CHtml::tag("div", array('class'=>"bottom-button", 'id'=>'SkinButtonArea'), " " );
}
	
$action = array();
$script =<<<EOL
var toDelete = $(this).parent().parent().parent();
var link = $(this).attr('href');
jQuery.ajax({
	'url':link,
	'cache':false,
	'success':function(data, textStatus){ toDelete.fadeOut("slow") },
	'error':function(data, textStatus){ toDelete.fadeIn("fast") },
	'beforeSend':function(data, textStatus){ toDelete.fadeTo("fast", 0.5) }		
});
EOL;


if (Yii::app()->user->checkAccess("layout")){
    $actions[Yii::t('app','Activate')]=array( 	'image'=>'images/activate.gif', 
										'link'=> 'layout/create', 
										'options'=>array( "title"=>Yii::t('app',"Activate"),
														  "class"=>"up") 
									    );
}
if (Yii::app()->user->checkAccess("model")){
   $actions[Yii::t('app','Delete')]=array( 'image'=>'images/x.gif', 
											'link'=> 'files/delete', 
											'click'=>$script,
											'options'=>array(	"class"=>"del", 
																"title"=>Yii::t('app',"Delete"),
															)  
										);
}
$gotactive = false;
if ( isset($index) ) {
    
    $medias = array();    
    //Yii::trace( $index->source );
    foreach( $layouts as $media ) {
        //Yii::trace( print_r($media, true) );
        $temp = array();
        $temp['media']=$media;
        if ( $media->id==$index->source ) {
            if ( Yii::app()->user->checkAccess("layout") && !$index->isBuiltIn($media->id) )
                $temp['action']= array( Yii::t('app','Edit')=>array( 	'image'=>'images/edit.gif', 
                                                    'link'=> 'layout/configure', 
                                                    'options'=>array( "title"=>Yii::t('app',"Edit"),
													"class"=>"right" ) 
                                                ) 
                                        );
            /*else 
                $temp['action']= array( Yii::t('app','View')=>array( 	'image'=>'images/view.gif', 
                                                    'link'=> 'layout/view', 
                                                    'options'=>array( "title"=>Yii::t('app',"View"),
													"class"=>"right" ) 
                                                ) 
                            );
            */
            else
                $temp['action']= array( ); // no actions
            $temp['name'] = Yii::t('app','Active Skin');
            $temp['preview'] = $index->webpathPreview;
            $gotactive = true;
            array_unshift($medias, $temp);
        } else if ( $index->isBuiltIn($media->id) && Yii::app()->user->checkAccess("layout") ) {
             $temp['action']= array( Yii::t('app','Activate')=>array( 	'image'=>'images/activate.gif', 
                                                                        'link'=> 'layout/create', 
                                                                        'options'=>array( "title"=>Yii::t('app',"Activate"),
                                                                                          "class"=>"up") 
                                                                        )
                                        );
            $medias[] = $temp;
        } else
            $medias[] = $temp;
    }
} else {
    $medias = $layouts;
}
$options['type']='slide';
$options['first']=true;

$this->widget('application.components.ListItems',array(
        'options' => $options,
        'media' => $medias,
        'actions' => $actions,
        )
    );

$title = $desc = array();
    
if ( count($medias)==0 ) {
    if ( !Yii::app()->user->checkAccess("model") ){
        $title[] = Yii::t('app', "Tip No Skins");
        $desc[] = Yii::t('app', "There are currently no Skins available.") . 
                "<br/>" .
                Yii::t('app', "Login as a user with 'Administrator' rights to upload Skins into the system.");
    } else {
        $title[] = Yii::t('app', "Tip Upload Skins");
        $desc[] = Yii::t('app', "Skins let you customize global parameters for your display, such as background, position of the Active Program, color of the text, etc.") . "<br/>" .
                Yii::t('app', "To upload Skins, click on the Add button. Then select the 7-Zip file containing the Skins.");
    }
} else {
    $title[] =  Yii::t('app', "Tip Activate Skin");
    if ( !$gotactive ) {
        $desc[] =   Yii::t('app', "One Skin should be activated to control the layout of the display.") .
                    "<br/>" .Yii::t('app', "To select and edit a Skin, click the Activate icon.") ;
    } else {
        $desc[] =   Yii::t('app', "The Active Skin controls the layout of the display.") .
                    "<br/>" .Yii::t('app', "To select and edit a Skin, click the Activate icon.") . " ". Yii::t('app', "To edit the current Skin, click the Edit icon.") ;
    }
    $title[] =Yii::t('app', "Icon Description");
    $d =  "";  
    if ( count($medias)>1 || !$gotactive ) {
        $d .= " ". CHtml::image('images/x.gif', Yii::t('app','Delete'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Delete'). " ";
        $d .=  CHtml::image('images/activate.gif', Yii::t('app','Activate'), array('class'=>'icon-desc')). " " .Yii::t('app','Activate'). " ";
    }
    if ( $gotactive )
        $d .=  CHtml::image('images/edit.gif', Yii::t('app','Edit'), array('class'=>'icon-desc')) ." ". Yii::t('app','Edit'). " ";  
    
    $desc[] = $d;
}
$title[] =  Yii::t('app', "Tip Extend Fusion");
$desc[] =   Yii::t('app', "More Skins are available on {link}", array( "{link}"=>"<a href='http://spinetix.com/go/fusion/skins' target='_blank'>spinetix.com/go/fusion/skins</a>" ) );
    
$this->widget('application.components.Tip',array(   'title' =>  $title, 'desc' => $desc ));