<?php 
$isnewuser=true;
if ( !isset($update) ) {
	echo CHtml::openTag("div", array('class'=>'new_user', 'id'=>'NewUser' ) );
} else {
	if ($update=="changed")
		$isnewuser=false;
}

echo CHtml::tag("h2", array( 'id'=>'TitleNewUser', 'class'=>$isnewuser?"":'hidden'), Yii::t('app',"New User"));
echo CHtml::tag("h2", array( 'id'=>'TitleChangeUser', 'class'=>$isnewuser?"hidden":''), Yii::t('app',"Change User"));

if ($isnewuser)
	echo CHtml::form(array("users/create"), "POST", array('id'=>'FormUser'));
else
	echo CHtml::form(array("users/updateadmin"), "POST", array('id'=>'FormUser'));

echo CHtml::errorSummary($newuser); 

echo CHtml::openTag("div", array('class'=>'user_password user_rights', 'id'=>'NewUser2' ) );
	echo CHtml::activeHiddenField($newuser,'username', array( 'id'=>'UsernameHidden') ); 
	$html = array( 'title'=>$newuser->getAttributeLabel('username'),
					'id'=>'UsernameShown',
				);
    
	if ($isnewuser) {
        echo CHtml::activeTextField( $newuser,'username', $html );
        echo CHtml::tag("div", array( 'id'=>'PasswordNewUser' ), 
                                CHtml::activePasswordField($newuser,'new_password', array('title'=>$newuser->getAttributeLabel('password')) ) .
                                CHtml::activePasswordField($newuser,'repeat_password', array(	'title'=>$newuser->getAttributeLabel('repeat_password')) ) 
                        );
    } else {
    
		$html['disabled']='disabled';
	    echo CHtml::activeTextField( $newuser,'username', $html );
    }
echo CHtml::closeTag("div") ."\n"; // user_password



echo CHtml::openTag("div", array('class'=>"new_user_rights user_settings_right", 'id'=>'UserRoles') );
foreach (User::$meta_roles as $name=>$roles) {
	echo CHtml::tag("div", array('class'=>"check"), 
								 CHtml::activeRadioButton($newuser, 'userRoles', array('value'=>$name, 'uncheckValue'=>null) ).
								 CHtml::tag("span", array('class'=>'user_rights_desc'), User::$meta_roles_name[$name])
					);
}

echo CHtml::closeTag("div") ."\n"; //UserRoles

echo CHtml::openTag("div", array('class'=>"bottom-button") );
echo CHtml::button(Yii::t('app', 'Add'), array(	"id"=>"AddUsers",
												"onclick"=>"ajaxSubmitReplace($(this), $('#NewUser'))", 
												"class"=>$isnewuser?"right-button button":"right-button button hidden",
                                            )
                                    );
echo CHtml::button(Yii::t('app', 'Save'), array("id"=>"UpdateUsers",
												"onclick"=>"ajaxSubmitReplace($(this),$('#NewUser'))", 
												"class"=>$isnewuser?"right-button button hidden":"right-button button",
                                            )
                                    );
echo CHtml::closeTag("div") ."\n"; //button_line


echo CHtml::closeTag("form");

echo CHtml::openTag("div", array('class'=>"manage_user") );

echo CHtml::openTag("div", array('class'=>"user_line") );

echo CHtml::openTag("div", array('class'=>"user_rights") );
echo CHtml::tag("h2", array(), Yii::t('app', 'All users' ) );
echo CHtml::closeTag("div") ."\n";

echo CHtml::openTag("div", array('class'=>"user_settings_right") );
foreach (User::$meta_roles as $name=>$roles) {
	echo CHtml::tag("div", array(	'class'=>"check"), 
									CHtml::tag("span", array('class'=>'user_rights_desc'), User::$meta_roles_name[$name])
						);
	}
echo CHtml::closeTag("div") ."\n";
echo CHtml::closeTag("div") ."\n";

echo CHtml::openTag("div", array('class'=>"all_users") );

foreach($users as $n => $user){
	
	echo CHtml::openTag("div", array('class'=>"user_line") );

	echo CHtml::tag("div", array('class'=>"user_rights"), CHtml::encode($user->username) );
	
	echo CHtml::openTag("div", array('class'=>"user_settings_right") );
	
	echo CHtml::openTag("div", array('class'=>"list_action") );
	
	if ($user->username!=="admin" && $user->username !== $currentUser->username ) {
		echo CHtml::image( 'images/edit.gif', Yii::t('app','Edit'), array(	'class'=>'right',
                                                                            'title'=>Yii::t('app','Edit'),
																			'onclick'=>"changeUser('{$user->username}', $(this))",
																			'href'=>CHtml::normalizeUrl( array("users/updateadmin")),
																		) 
							);
        echo CHtml::image( 'images/x.gif', Yii::t('app','Delete'), array(	'class'=>'del', 
                                                                            'title'=>Yii::t('app','Delete'),
																			'onclick'=>'ajaxSubmitDelete($(this));',
																			'href'=>CHtml::normalizeUrl( array("users/delete", "id"=>$user->username) )
																		) 
							);
		
	}
	echo CHtml::closeTag("div") ."\n";
	
	
	foreach (User::$meta_roles as $name=>$roles) {
		echo CHtml::tag("div", array('class'=>"check"), 
									 CHtml::activeRadioButton($user, "[$n]userRoles", array('value'=>$name, 'uncheckValue'=>null, "disabled"=>"disabled"))
						);
	}
	
	
	echo CHtml::closeTag("div") ."\n";


	echo CHtml::closeTag("div") ."\n";
}

echo CHtml::closeTag("div") ."\n";

$title = $desc = array();
$title[] = Yii::t('app', "Tip Create Users");
$desc[] =   Yii::t('app', "To create a new User, enter the username and password, select rights and then press the Add button."). "<br/>".
            Yii::t('app', "The user password can be changed once logged into the system."); 
    
$title[] = Yii::t('app', "Tip Scheduler Rights");
$desc[] =   Yii::t('app', "Users with Scheduler rights can only activate existing Programs.");
    
$title[] = Yii::t('app', "Tip Editor Rights");
$desc[] =   Yii::t('app', "Users with Editor rights can activate existing Programs and modify existing Slides.");

$title[] = Yii::t('app', "Tip Creator Rights");
$desc[] =   Yii::t('app', "Users with Creator rights can create, delete and modify the Programs, Slides and Playlists. They can also upload new media, and change the active Skin.");

$title[] = Yii::t('app', "Tip Administrator Rights");
$desc[] =   Yii::t('app', "Users with Administrator rights can perform all Creator tasks. In addition they can upload new Skins and Template packs.") ."<br/>".
            Yii::t('app', "They can also create and delete users using this page.");

$title[] = Yii::t('app', "Tip User Admin");
$desc[] =   Yii::t('app', "The 'admin' user is a built-in user, and it cannot be modified or deleted.");

if ( count($users)>1 ){

    $title[] =Yii::t('app', "Icon Description");
    $d =  "";  
    $d .= " ". CHtml::image('images/x.gif', Yii::t('app','Delete'), array('class'=>'icon-desc') ) . " " .Yii::t('app','Delete'). " ";
    $d .=  CHtml::image('images/edit.gif', Yii::t('app','Edit'), array('class'=>'icon-desc')) ." ". Yii::t('app','Edit'). " ";  
    $desc[] = $d;
}

$this->widget('application.components.Tip',array(   'title' =>  $title, 'desc' => $desc ));

echo CHtml::closeTag("div") ."\n"; // new_user

if ( !isset($update) )
	echo CHtml::closeTag("div") ."\n";

