#!/bin/sh
#
# License: Copyright 2008 SpinetiX S.A. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
# Copyright 1999-2003 MontaVista Software, Inc.
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start: udev
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: S
# Default-Stop: 0 1 2 3 4 5 6
# Short-Description: Add extra device nodes not created by udev
# Description: Add extra device nodes not created by udev
### END INIT INFO
# chkconfig: S 05 0

# Init script information
INIT_NAME=spxdevs
DESC="Extra devices"

case "$1" in
    start)
	echo -n "$DESC: "
	echo -n "audio-dev"
	if ! test -c /dev/dsp; then
	    rm -f /dev/dsp && \
		mknod -m 0660 /dev/dsp c 14 3 && \
		chgrp audio /dev/dsp
	    RET=$?
	else
	    RET=0
	fi
	if [ $RET -ne 0 ]; then
	    echo -n " failed ($RET), ";
	else
	    echo -n ", "
	fi

	echo -n "x-display perms"
	if [ -d /sys/class/x-display/disp0/device ]; then
	    chgrp video /sys/class/x-display/disp0/device/dpm_state && \
		chmod g+w /sys/class/x-display/disp0/device/dpm_state
	    RET=$?
	else
	    RET=0
	fi
	if [ $RET -ne 0 ]; then
	    echo -n " failed ($RET), ";
	else
	    echo -n ", "
	fi

	echo -n "graphics perms"
	if [ -d /sys/class/graphics/fb0/device ]; then
	    chgrp video /sys/class/graphics/fb0/device/win_ctl && \
		chmod g+w /sys/class/graphics/fb0/device/win_ctl
	    RET=$?
	else
	    RET=0
	fi
	if [ $RET -ne 0 ]; then
	    echo -n " failed ($RET), ";
	else
	    echo -n ", "
	fi

	# Workaround for hotplug's USB coldplugging not synthetizing
	# events for USB devices plugged before boot; this should go
	# away once we have a proper hotplug replacement

	echo -n "usb-storage"
	if grep -q '^I:.* Cls=08' /proc/bus/usb/devices; then
	    modprobe usb_storage
	fi
	echo -n ", "

	# Some devices claiming to have an HID interface with a protocol other
	# than mouse (2) are not real HID devices and are handled by usbtouchscreen
	echo -n "usbtouchscreen"
	if grep -q  'I:.* Cls=03.* Prot= *\([013-9a-fA-F]\|0[013-9a-fA-F]\|[1-9a-fA-F][0-9a-fA-F]\) ' /proc/bus/usb/devices; then
	    modprobe usbtouchscreen
	elif grep -q '^I:.* Cls=ff' /proc/bus/usb/devices; then
	    # If we have a vendor class device it may be a touchscreen, which
	    # is probably handled by the usbtouchscreen driver, load it to be sure
	    modprobe usbtouchscreen
	fi
	echo -n ", "

	echo -n "usb-hid"
	if grep -q '^I:.* Cls=03' /proc/bus/usb/devices; then
	    modprobe usbhid
	fi
	echo "."

	;;
    stop)
	;;
esac
