#!/bin/sh

# This scripts returns the name of the device name to use
# for the modem, and prior to that it initializes the modem
# if it is the main port.
#
# The device name is 'modem' for the normal (main) port and
# 'modemctl' for the monitoring and control port.
#

# This is currently very crude. It assumes the Huawei type of devices
# where the first serial interface is for data and control, second is
# unused and third is for control. This may be refined and expanded by
# having udev pass more information such as device IDs, number of
# interfaces, interface number, temporary device node, etc.

devnum="$1"
devnode="$2"

# HACK - start
# This script may be executed by udev before the udev start script
# creates some of the special links under /dev/
[ -e /dev/fd ] || ln -s /proc/self/fd /dev/fd
[ -e /dev/stdin ] || ln -s /proc/self/fd/0 /dev/stdin
[ -e /dev/stdout ] || ln -s /proc/self/fd/1 /dev/stdout
[ -e /dev/stderr ] || ln -s /proc/self/fd/2 /dev/stderr
# HACK - end

# We do not need to lock the device in modem-control since we are
# running from udev with a temporary device node, which should not
# be accessible from elsewhere

if [ "$devnum" = 0 ]; then
    # This is the main port, we fully initialize the modem
    devname="modem"
    /usr/libexec/spxdevs/modem-control -u -i -d "$devname" "$devnode"
elif [ "$devnum" = 2 ]; then
    # This is a control port, we only initialize the stty settings
    devname="modemctl"
    /usr/libexec/spxdevs/modem-control -u -s -d "$devname" "$devnode"
else
    # We do not handle this device
    exit 1
fi

echo "$devname"

exit 0
