#!/bin/sh
#
# License: Copyright 2009 SpinetiX S.A. This file is licensed
#          under the terms of the GNU General Public License version 2.
#          This program is licensed "as is" without any warranty of any
#          kind, whether express or implied.
#
# Copyright 1999-2003 MontaVista Software, Inc.
# Copyright 2002, 2003, 2004 Sony Corporation
# Copyright 2002, 2003, 2004 Matsushita Electric Industrial Co., Ltd.
#
### BEGIN INIT INFO
# Required-Start: udev
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start: 2 3 5
# Default-Stop:
# Short-Description: Updates fontconfig caches
# Description: Updates fontconfig caches
### END INIT INFO
# chkconfig: 235 60 20

# Init script information
INIT_NAME=fc-cache
DESC="fc-cache"

BOOTCOUNTFILE=/proc/bootcount

case "$1" in
    start)
	echo -n "$DESC: "

	# If we have rebooted a couple of times cleanup the font cache
	# just in case the reboots are due to a corrupt font cache
	if [ -f $BOOTCOUNTFILE ]; then
	    BOOTCOUNT=$(cat $BOOTCOUNTFILE)
	else
	    BOOTCOUNT=0
	fi

	if [ $BOOTCOUNT -ge 3 ]; then
	    rm -f /var/cache/fontconfig/*
	else
	    # this version of fontconfig uses cache-3 files, remove all others
	    rm -f /var/cache/fontconfig/*.cache-[^3]
	fi

	fc-cache -s
	RET=$?
	if [ $RET -ne 0 ]; then
	    echo " failed ($RET).";
	else
	    echo "."
	fi
	;;
    stop)
	;;
esac
