<?php

class checkIP extends CValidator  {

    public function validateAttribute( $object, $attribute ){
        $value = $object->$attribute;
        
        if ( trim( $value ) =="" ) return true;
        $vals=explode( ".",trim( $value) );
        if (count($vals)!=4) {
            $object->addError($attribute,'Format non valid. '.'Valid format xxx.xxx.xxx.xxx');
        }
        foreach ($vals as $val) {
            if (!is_numeric($val) || $val<0 || $val>255) {
                $object->addError($attribute,'Format non valid. '.'Valid format xxx.xxx.xxx.xxx, where xxx is between 0-255');
            }
        }
        if ($vals[0]==0) {
            $object->addError($attribute,'Format non valid. '.'First value cannot be 0');
        }
        if ($vals[0]==255 && $vals[1]==255 && $vals[2]==255 && $vals[3]==255) {
            $object->addError($attribute,'Format non valid. '.'255.255.255.255 is not a valid address.');
        }
    }
}