<?php

class AdvancedController extends CController
{
	/**
	 * @var string specifies the default action to be 'list'.
	 */
	public $defaultAction='toggle';


    public function actionToggle() {
        Yii::app()->user->activateAdvancedMode( !Yii::app()->user->advancedMode() );
        $this->redirect( array('/info') );
    }
    public function actionEnable() {
        Yii::app()->user->activateAdvancedMode( true );
        $this->redirect( array('/info') );
    }
    public function actionDisable() {
        Yii::app()->user->activateAdvancedMode( false );
        $this->redirect( array('/info') );
    }
	public function actionPlayer()
	{
        $config = new PlayerConfig;
        
        if( isset($_POST['player']) ) {
            $config->setScenario( 'player'  );
            $config->setAttributes( $_POST['PlayerConfig'] );
            
            if ( $config->validate()  ) {
                $config->saveConfig();
            }
        } else 
            $config->loadAdvValues();
        
		$this->render('player',array( 'config'=>$config) );
	}
    public function actionLogs()
	{
        
        if ( isset($_POST['logs']) ) {
			$logs = new LogConfig;
            $ok = true;
            $logs->setAttributes( $_POST['LogConfig'] );
            if ( !$logs->validate() )
                $ok = false;
            foreach ( $_POST['AppenderConfig'] as $appData) {
                if ( !is_array($appData) ) continue;
                $app =  new AppenderConfig;
                $app->setAttributes( $appData );
                if ( !$app->validate() )
                    $ok = false;
                $logs->appenders[]=$app;
                    
            }
            foreach ( $_POST['LoggerConfig'] as $logData ) {
                $log = new LoggerConfig;
                if (!isset($logData['name']) || $logData['name']=="" ) continue;
                $log->name = $logData['name'];
                $log->priority = $logData['priority'];
                $refs = array();
                foreach ( $logData as $name=>$val ) {
                    if ($name=='name' || $name=='priority' ) continue;
                    $refs[$name]=$val;
                }
                $log->refs=$refs;
                $logs->loggers[$log->name]=$log;
            }
            if ( $ok )
                $logs->save();
        } 
		
		$logs = new LogConfig;
        $logs->load();
    
        if ( isset($_POST['add']) ) {
            $app =  new AppenderConfig;
            
            $app->setAttributes( $_POST['AppenderConfig'] );
            if ( $app->validate() ) {
                $logs->appenders[$app->name] = $app;
                $logs->save();
            }
        }
        
        
        
        $this->render('logs',array( 'logs' => $logs ) );
    }
    public function actionCache()
	{
        $config = new PlayerConfig;
        
        if( isset($_POST['cache']) ) {
            $config->setScenario( 'cache'  );
            $config->setAttributes( $_POST['PlayerConfig'] );
            
            if ( $config->validate()  ) {
                $config->saveConfig();
            }
        } else 
            $config->loadCacheValues();
            
        $this->render('cache',array(  'config'=>$config)  );        
    }
}