<?php

class InfoController extends CController
{
	
	function  __construct ( $id, $module ) {
		parent::__construct( $id, $module );
		$wiz = new Wizard();
		if ( $wiz->active )
			$this->defaultAction='wizard';
		else
			$this->defaultAction='status';
	}
    public function filters()
    {
        return array(
            'wizard - wizard',            
        );
    }
    public function filterWizard( $filterChain ) {
        $wiz = new Wizard();
        if ( !isset($_POST['Wizard']) && $wiz->getWelcome() && !Yii::app()->user->status->installationmode ){
            $this->redirect( array( "/info/wizard" ) );
        } else {
            $filterChain->run();
        }
    }
	public function actionSafemode()
	{
		$this->render('safemode', array('product'=>Yii::app()->user->branding->product) );
	}
    public function actionCorrupted()
	{
		$this->render('corrupted', array('product'=>Yii::app()->user->branding->product) );
	}
    
     
    public function actionWizard()
	{
		$wiz = new Wizard();
        $info = new BasicInfo;
		$config = new PlayerConfig;
        $screen = new ScreenSettings;
		$screeninfo = new ScreenInfo;
        $screeninfo->load();
		
		$fusion = new FusionSetup;
		$time = new TimeSettings;
        $firmware = new FirmwareUpdate;
        
		$security = new SecuritySettings;
        $security->load();
        
		$network = new IPConfig;
        $proxy = new ProxyConfig;
        
		$backup = new ConfigBackup;
		
		$hasErrors = false;
        $redirect = "/";
        
        $configured = false;
        if( isset($_POST['Wizard']) ){
			$wiz->setAttributes( $_POST['Wizard'] );
		} 
		if( isset($_POST['ScreenSettings']) || isset($_POST['PlayerConfig'])) {
            $config->setScenario( 'wizard'  );
			$screen->setScenario( 'simple'  );
			
			if ( isset($_POST['PlayerConfig']) )
				$config->setAttributes( $_POST['PlayerConfig'] );
            if ( isset($_POST['ScreenSettings']) )
				$screen->setAttributes( $_POST['ScreenSettings']);
            if ( $config->validate() && $screen->validate() ) {
                $config->saveConfig();
                $screen->save();
            } else 
                $hasErrors = true;
            $configured = true;
        } else 
            $redirect = false;    
            
        if ( isset($_POST['TimeSettings']) ){
            $time->setScenario('timezone');
            $time->setAttributes( $_POST['TimeSettings'] );
            if ( $time->validate() )
                $time->save();
            else 
                $hasErrors = true;
            $configured = true;
        } 

		if ( isset($_POST['FusionSetup']) ) {
            $fusion->setAttributes( $_POST['FusionSetup'] );
			if ( $fusion->validate() )
				$fusion->save();
            $configured = true;
        }
        if ( isset($_POST['Users']) && $_POST['Users']['new_pass']!="" && $_POST['Users']['old_pass']!="" ){
            // a password has been set
            $security->setScenario( 'admin' );
            if ( isset($_POST['SecuritySettings']) )
				$security->setAttributes( $_POST['SecuritySettings'] );
            $security->setUser( $_POST['Users'] );
            if ( $security->validate() )
                $security->save();
			else 
                $hasErrors = true;
            $configured = true;
        }
		if ( isset($_POST['IPConfig']) ) {
			if ( $_POST['IPConfig']['dhcp'] )
                $network->setScenario( 'dhcp'  );
            else
                $network->setScenario( 'fixip'  );
            $network->setAttributes( $_POST['IPConfig'] );
            if ( $network->validate() && $network->checkConfig(  ) )
                $network->save();
			else
				$hasErrors = true;
            $configured = true;
        } else {
            $network->load();
        }
		if ( isset($_POST['ProxyConfig']) ) {
            $proxy->setAttributes( $_POST['ProxyConfig'] );
            if ( $proxy->validate() )
                $proxy->save();
            else
				$hasErrors = true;
            $configured = true;
        } else {
            $proxy->load();
        }
        
		if ( isset($_POST['ConfigBackup']) ){
            $backup->setScenario( 'upload' );
            $backup->setAttributes( $_POST['ConfigBackup'] );
            $file = CUploadedFile::getInstance($backup,'uploadedfile');
            if ( $backup->validate() && $file ) {
                $backup->applyBackupFile( $file->getTempName() );
            }            
            $configured = true;
		}
		
        $screen->load();
        $time->load();
        
        if ( $redirect )
            Yii::app()->user->tools->redirect = $redirect;

        $this->layout = 'wizard';
        
        if ( !$hasErrors && Yii::app()->user->tools->doShutdown() )
			Yii::app()->user->tools->shutdown();
            
        if ( Yii::app()->user->tools->reboot ) {
            $this->render('/layouts/shutdown', array(   'reason'=>Yii::app()->user->tools->shutdownReason, 
                                                        'messages'=>Yii::app()->user->tools->messages, 
                                                        'redirect' => Yii::app()->user->tools->redirect,
														'wizard' => true,
                                                        'fusion' => $fusion->active
                                                    ) );
        } else if ( $configured ) {
            // we changed something, but no need to reboot
            $fusion->scenario = "backup";
            if ( $fusion->getStart() )
                $redirect = "/fusion/";
            else
                $redirect = array("/");
            
            $this->render('reload',array(  'redirect'=> $redirect,
                                           'fusion' => $fusion->active,
                                           'backup' => $backup,
                                           'config' => $config
									) );                                    
        } else {
        
            $this->render('wizard',array(  'config'=> $config,
                                            'screen'=> $screen, 
                                            'wiz' => $wiz,
                                            'fusion' => $fusion,
                                            'time' => $time,
                                            'firmware' => $firmware,
                                            'security' => $security,
                                            'network' => $network,
                                            'proxy' => $proxy,
                                            'backup' => $backup,
											'screeninfo' => $screeninfo,
                                            'firmware' => $info->getFirmware() 
                                        ) );
        }
        if ( $fusion->needreload )
            $fusion->reloadConfig();
        else if ( $security->needreload )
            $security->reloadConfig();
        else
            $backup->reloadConfig();
	}
	
	public function actionStatus()
	{

        $wiz = new Wizard();
		if( isset($_POST['Wizard']) ){
            // enable instalation mode
            $job = new Maintenance;
            $job->instalationMode( ); 

            if ( $wiz->getWelcome() && !Yii::app()->user->tools->doShutdown() ) {
                // insure that one reboot will be done
                Yii::app()->user->tools->addReason("initial configuration");
            }
        	$wiz->setAttributes( $_POST['Wizard'] );
		}
        
        
        $info = new BasicInfo;
        $config = new PlayerConfig;
        $modem = new Modem3G;
        $usb = new USBInfo;
        
        $config->loadConfig();
        
		$this->render('status',array(   'info'=>$info, 
                                        'serial'=>Yii::app()->user->info->serialstring,
                                        'hardware' => Yii::app()->user->info->hardware,
                                        'name' => $config->deviceName,
                                        'screen' => $config->screenId,
                                        'modem' => $modem,
                                        'usb' => $usb,
                                        'config' => $config,
										'wiz' => $wiz,
                                        ) );
	}
    public function actionSnapshot()
	{
        $this->render('snapshot',array( ) );
    }
	public function actionDisplay()
	{
        $info = new ScreenInfo;
        $info->load();

        $this->render('display',array( 'info'=>$info) );
    }
    public function actionStorage()
	{
        $disk = new DiskInfo;
        $disk->load();
        $this->render('storage',array( 'disk'=>$disk ) );
    }
    public function actionLogs()
	{
        $logs = new LogsInfo;
        $logs->load();
        $this->render('logs',array( 'logs'=>$logs) );
    }
    public function actionAbout()
	{
        $this->render('about',array( ) );
    }
}