<?php
require_once dirname(__FILE__).'/../utils/MainInfo.php';

class BasicInfo extends CModel {
	
	protected $_ip=false;
    protected $_ipprefix=false;
    protected $_iptype=false;
    
    protected $_hostname=false;
    
    protected $_mac=false;
    protected $_firmware=false;
    protected $_build=false;
	
	protected $_temp=false;
	protected $_temp_max=null;
	protected $_temp_crit=null;
    
	public function attributeNames() {
        return array("hardware", "ip", "ipprefix", "iptype", "mac", "firmware", "hardware", "temp");
    }
    public function safeAttributes() {
        return array();
    }
    
    public function getMac () {
        if ( $this->_mac===false ) {
            $this->_mac = getInfoMac();
        }
        return $this->_mac;
    }
    
    public function getIp() {
        if ( $this->_ip===false )
			getInfoIp($this->_ip,  $this->_ipprefix, $this->_iptype);
        return $this->_ip;
    }
    
    public function isZeroConf() {
        $ip = $this->getIp();
        return substr($ip, 0, 7)=="169.254";
    }
    
    public function getIptype() {
        if ( $this->_iptype===false )
			getInfoIp($this->_ip,  $this->_ipprefix, $this->_iptype);
        return $this->_iptype;
    }     
    public function getIpprefix() {
        if ( $this->_ipprefix===false ) 
			getInfoIp($this->_ip,  $this->_ipprefix, $this->_iptype);
        return $this->_ipprefix;
    }     

    public function getHostname() {
        if ( $this->_hostname===false ) {
            $this->_hostname = getInfoHostname();
        }
        return $this->_hostname;
    }  
    
    public function getFirmware() {
        if ( $this->_firmware===false )
			getInfoFirmware( $this->_firmware, $this->_build );
        return $this->_firmware;
    }
    
    public function getBuild() {
        if ( $this->_build===false ) 
			getInfoFirmware( $this->_firmware, $this->_build );
        return $this->_build;
    }   
    
    public function isBeta() {
        if ( $this->_build===false ) 
			getInfoFirmware( $this->_firmware, $this->_build );
        return $this->_build[0]=='0';
    } 
	
	public function getTemp() {
        if ( $this->_temp===false ) {
			$temps = getInfoTemperature( );
			$this->_temp = $temps['temp']; 
			$this->_temp_max = $temps['max'];
			$this->_temp_crit = $temps['crit'];
		}
        return $this->_temp;
    }
    public function getTempF() {
        if ( $this->_temp===false ) 
            $this->getTemp();
        return (9/5)*$this->_temp+32;
    }
	
	public function getTemp_max() {
        if ( $this->_temp===false ) {
			$this->getTemp();
		}
        return $this->_temp_max;
    }
	public function getTemp_crit() {
        if ( $this->_temp===false ) {
			$this->getTemp();
		}
        return $this->_temp_crit;
    }
    public function getUptime() {
        $uptime = getInfoUpTime();
        $d = floor($uptime / 24 / 3600 );
        $uptime -= $d*24*3600;
        $h = floor($uptime / 3600 );
        $uptime -= $h*3600;
        $m = floor($uptime / 60 );
        $uptime -= $m*60;
        
        return array( $d, $h, $m, $uptime);
    }
    public function getUptimeStr() {
        $uptime = $this->getUptime();
        $time = "";
        if ( $uptime[0] > 1 )
            $time .= $uptime[0] . " Days ";
        else if ( $uptime[0] == 1 )
            $time .= $uptime[0] . " Day ";

        if ( $uptime[1] > 1 )
            $time .= $uptime[1] . " Hours ";
        else if ( $uptime[1] == 1 )
            $time .= $uptime[1] . " Hour ";

        if ( $uptime[2] > 1 )
            $time .= $uptime[2] . " Minutes ";
        else if ( $uptime[2] == 1 )
            $time .= $uptime[2] . " Minute ";

        if ( $uptime[0] == 0)
            $time .= floor($uptime[3]) . " Seconds ";
          
        return $time;
    }
}