<?php

require_once 'protected/utils/SecurityJobs.php';

class ConfigBackup extends CModel {

    protected $version="1.1";
    var $backupPassword = true;
	
	var $uploadedfile;
	var $needreload=0;
	static $wizard_map =       array('wizard'=>array('active', true),
                                    );
    static $display_map = array(    'display-custom-video-mode'=>'custom',
                                    'resolution'=>'resolution',
									'vertical-freq'=>'vfreq',
									'force-std-mode'=>array('forcestdmode', true),
									'restrict-type'=>'type',
									'screen-aspect-ratio'=>'screeenar',
									'underscan-supported'=>array('underscansupp',true),
                                    'vga-dc-offset'=>array('dcoffsetsupp',true),
                                    'hdmi-link-type'=>'hdmilink'
									);
    static $display_map2 = array(   'overscan-percentage'=>'overscan',
									'display-orientation'=>'orientation',
                                    'enable-audio'=>array('audio',true),
                                    'audio-power-save'=>array('audioPowerSave',true),
                                    'vga-power-mode'=>'power'
                                    );
    static $splash_map = array(     'boot'=>'boot',
									'shutdown'=>'shutdown',
                                    'fimrware'=>'fimrware'
                                    );
   	static $power_map = array(      'display-power-save'=>array('enablePowerSave',true),
									'on-time'=>'onTime',
                                    'off-time'=>'offTime'
									);
    static $interactivity_map=array('accepts-events'=>array('events',true),
									'maximum-latency'=>'latency',
                                    'reduce-interactive-latency'=>array('interlatency',true),
                                    'extended-USB'=>array('extendedUSB',true),
                                    'enable-USB-IO-API'=>array('usbIOAPI',true),
									);
    static $network_map =    array( 'network-interface'=>'netiface',
									'dhcp'=>array('dhcp',true),
                                    'address'=>'address',
                                    'netmask'=>'netmask',
                                    'gateway'=>'gateway',
                                    'dns'=>'nameserver1',
                                    'dns2'=>'nameserver2',
                                    'dns3'=>'nameserver3',
                                    'domain'=>'domain',
                                    );
    static $id_map =       array(   'screen-id'=>'screenId',
                                    'device-name'=>'deviceName',
                                    );
    static $netapi_map =   array(   'network-api-enabled'=>array('NetAPIEnabled',true),
                                    'network-api-port'=>'sharedVarPort',
                                    );
    static $https_map =     array(  'https-validate-certificates'=>array('HTTPSUseDefaultCA',true),
                                    );
    static $watchdog_map =   array( 'max-time-no-addr'=>'maxTimeNoAddr',
                                    'min-time-keep-addr'=>'minTimeKeepAddr',
                                    );
    static $credit_map =     array( 'server'=>'href',
                                    'password'=>'password',
                                    'username'=>'username',
                                    'realm'=>'realm',
                                    );
    static $proxy_map =      array( 'server'=>'server',
                                    'port'=>'port',
                                    'bypass-proxy-local'=>'bypassLocalNetwork',
                                    'username'=>'username',
                                    'password'=>'password',
                                    );
    static $snmp_map =       array( 'snmp-rocommunity'=>'rocommunity',
                                    'address-range'=>'snmpaddress',
                                    );
    static $source_map =     array( 'primary-source'=>'primarySrc',
                                    'secondary-source'=>'secondarySrc',
                                    'allow-usb-sources'=>array('useUSB',true),
                                    );
	static $time_map = 		array ( 'timezone'=>'shortlink',
									);
	static $ntp_map = 		array ( 'manual'=>true,
                                    'ntp'=>true,
                                    'use-ntp'=>array('active', true),
									'time'=>'time',
									'date'=>'date',
									'boot-delay'=>'bootdelay',
									);
	static $ntpserver_map = array ( 'ntp'=>true,
                                    'server-1'=>'ntpserver1',
									'server-2'=>'ntpserver2',
									'server-3'=>'ntpserver3',
									'server-4'=>'ntpserver4',
									'server-5'=>'ntpserver5',
									'monitor-only-1'=>'ntpnosel1',
									'monitor-only-2'=>'ntpnosel2',
									'monitor-only-3'=>'ntpnosel3',
									'monitor-only-4'=>'ntpnosel4',
									'monitor-only-5'=>'ntpnosel5'
									);
	static $temperature_map =array ( 'shutdown-temperature'=>'max_temp',
									);
	static $io_map =         array ( 'protocol-name'=>'backupName', // backward compatibility only
                                     'protocol-file'=>'backupName',
                                     'protocol-system'=>'backupName',
                                     'enabled'=>array('enableSerial',true),
                                     'baud-rate'=>'baudRate', 
                                     'byte-size'=>'byteSize', 
                                     'parity'=>'parity', 
                                     'stop-bits'=>'stopBits'
									);
    static $pullmode_map    =array ( 'project'=>true,
                                     'logs'=>true,
									 'rpc'=>true,
                                     'mode'=>'selectMode',
									 'pull-project'=>array('enable_project',true),
									 'project-source'=>'project_source',
									 'project-time'=>'timeProj',
									 'push-logs'=>array('enable_log', true),
									 'log-source'=>'log_source',
									 'log-time'=>'timeLog',
									 'log-type'=>'log_type',
                                     'schedule-uri'=>'uri',
                                     'ics-file'=>'icsfile',
									 'check-frequency'=>'checktime',
									 'rpc-concentrator'=>array('enable_rpc',true),
									 'uri'=>'concentrator',
									 'polling'=>'polling',
                                     'pooling'=>'polling', // backward compatibility
									 'notification-only'=>array('notification_only',true)
									);
    static $firmware_map =array (   'firmware-update-uri'=>'updateuri',
                                    'firmware-update-auto'=>'updateAutoString',
									);
    static $fusion_map =  array (   'enable-fusion'=>array('active', true),
                                    'fusion-startup'=>array('start', true),
                                    );
    protected $dom;
    public function attributeNames() {
		return array(
            'uploadedfile', 
            'backupPassword'
		);
     
    }
	public function attributeLabels() {
		return array(
            'uploadedfile'=>'Backup',
            'backupPassword'=>'Backup users and passwords',
		);
     
    }
    public function rules() {
		$res = array(
            array( 'uploadedfile', 'file', 'types'=>'spx, xml, 7z, zip, cfg', 'on'=>'upload' ),
			array( 'backupPassword', 'safe' ),
    	);
        return $res;
	}
	function dump() {
		
        $folder = "/var/tmp/" . md5( time().rand() ). "/";
        $fn = $folder  . 'config.xml';
        $zip = $folder . "config.7z";
        
        mkdir( $folder );
                
		file_put_contents($fn, $this->create() );
        
        // create the zip file from this
        if(PHP_OS == "WINNT"){
            $exe = '"C:\Program Files\7-Zip\7z.exe"';
        } else
            $exe = "7za";
        
        $files = "";

        // splash screens
        $splash = new SplashScreen;
        $splash->load();
        foreach ( $splash->filepath as $name=>$path ){
            if ( $path!==null )
                $files .= " " . $path;
        }
        // fsm files
        $serial = new SerialConfig;
        $list =  $serial->getFileList( false, true );
        foreach ( $list as $name=>$path ){
            if ( $path!==null )
                $files .= " " . $path;
        }
        
        $cmd =  "$exe a $zip -t7z -mx1 -mhc=off $fn $files";
        $option = array();
        $ret = -1;
        exec( $cmd, $options, $ret );
        if ( $ret==0 ){
            $fp = fopen( $zip, 'rb');
            header("Content-type: application/x-spx-config");
            header('Content-Disposition: attachment; filename="config-'.Yii::app()->user->info->serial.'.cfg"');
        
            fpassthru($fp);
            fclose($fp);
        } else {
            $this->addError('uploadedfile',"Cannot create backup file, please contact support");            
        }
        if ( file_exists( $fn ) )
            unlink( $fn );
        if ( file_exists( $zip ) )
            unlink( $zip );
        rmdir( $folder );
        return $ret==0;
    }
    function isXmlBackup( $filename ){
        //@$a = simplexml_load_string( $somestring );
        $f = fopen($filename, 'r');
        $start = fread($f, 5);
        if ( $start=="<?xml" || $start=="<conf" )
            return true;
        else
            return false;
    }
    function applyBackupFile( $filename ){
        if(PHP_OS == "WINNT")
            $exe = '"C:\Program Files\7-Zip\7za"';
        else
            $exe = "ulimit -v 8192 && 7za";
            
        if ( $this->isXmlBackup( $filename ) ) {
            $data = file_get_contents( $filename );
            $this->apply( $data );
        } else {
            // zip file
            $folder = "/var/tmp/" . md5( time().rand() ) ."/";
            
            $dest = SerialConfig::$confpathusr;
            $cmd =  "$exe e $filename -o$dest -aoa *.fsm";
            exec( $cmd, $output, $ret );
            if ( $ret==2 || $ret==8 ) {
                $this->addError('uploadedfile',"The compression factor may be too high. Try re-generating the archive with the compression level set to Store or Fast.");
                return;
            } else if ( $ret!=0 ) {
                $this->addError('uploadedfile',"File extraction of fsm failed. ($ret)");
                return;
            }
            
            $cmd =  "$exe e $filename -o$folder -aoa *.jpg *.png *.JPG *.PNG *.7z";
            exec( $cmd, $output, $ret );
            if ( $ret==2 || $ret==8 ) {
                $this->addError('uploadedfile',"The compression factor may be too high. Try re-generating the archive with the compression level set to Store or Fast.");
                return;
            } else if ( $ret!=0 ) {
                $this->addError('uploadedfile',"File extraction of images failed. ($ret)");
                return;
            }
            
            $cmd =  "$exe e $filename -o$folder -aoa config.xml";
            exec( $cmd, $output, $ret );
            if ( $ret!=0 ) {
                $this->addError('uploadedfile',"File extraction of config failed. ($ret)");
                return;
            }
            
            if ( $ret==0 ){
                $data = file_get_contents( $folder."config.xml" );
                $this->apply( $data, $folder );
                unlink( $folder."config.xml" );
            }
            foreach ( array('jpg', 'png', 'JPG', 'PNG', '7z') as $ext )
                array_map( "unlink", glob( $folder."*.".$ext ) );
            
            rmdir( $folder );
        }
    }
    
    function setAll( &$main, $name, $obj, $table) {
		if ( $name===false )
			$node = $main;
		else
			$node = $main->appendChild($this->dom->createElement($name));
		foreach ( $table as $dst=>$src ){
            if ( is_array($src) )
                $src = $src[0];
            if ( $src===true ) 
                continue;
            $this->set($node, $obj, $src, $table);
        }
		
    }
    
	function set( &$node, $obj, $elems, $table=null ) {
        if ( !is_array($elems) )
            $elems = array( $elems );
        foreach( $elems as $elem ) {
            if ( $table===null) {
                $member = $elem;
                $name = $elem;
            } else {
                foreach ( $table as $name=>$member ) {
                    if ( is_array( $member ) && $member[0]===$elem )
                        break;
                    if ( !is_array( $member ) && $member===$elem )    
                        break;
                }
            } 
            $bool = false;
            if ( is_array( $member ) ){
                $bool = $member[1];
                $member = $member[0];
            }
            if ( is_array($obj) )
                $val = $obj[ $member ];
            elseif ( is_object($obj) )
                $val = $obj->$member;
            else
                $val = $obj;
            
            if ( $bool )
                $node->appendChild($this->dom->createElement($name, $val?"yes":"no" ));
            else
                $node->appendChild($this->dom->createElement($name, htmlspecialchars($val) ));
            
        }
	}
    function convertErrors( $errors, $table ){
        $myerr=array();
        foreach ( $errors as $elem=>$value ) {
            foreach ( $table as $name=>$member ) {
                if ( is_array( $member ) && $member[0]===$elem )
                    break;
                if ( !is_array( $member ) && $member===$elem )    
                    break;
            }
            $myerr[$name] = $value;
        }
        return $myerr;
    }
    
    function getAll( &$obj, $scenario , $node, $table){
        $attr = $this->get( $node, $table );
        if ( $scenario )
            $obj->setScenario( $scenario );
        $obj->setAttributes( $attr );
        if ( !$obj->validate() ){
            $this->addErrors( $this->convertErrors($obj->getErrors(),$table)  );
            $obj->clearErrors();
        }
            
        return $attr;
    }
    function setAttr( $node, $name, $table, &$attr ) {
        $member = $table[$name];
        $bool = false;
        if ( is_array( $member ) ){
            $bool = $member[1];
            $member = $member[0];
        }
        if ( $member===true ) {
            $a = $this->get( $node, $table );
            $attr = array_merge($a, $attr);
            $attr[$name]=true;
        } else {
            $val = trim($node->textContent);
            if ( $bool )
                 $attr[$member] = ($val=="yes")?1:0;
            else
                $attr[$member] = htmlspecialchars_decode($val);
        }
    }
    
	function get( $node, $table){
        $attr = array();
        
        $name = $node->localName;
        //echo $name;
        //print_r( $table );
        
        if ( isset($table[$name]) && $table[$name]!==true ){
            $this->setAttr( $node, $name, $table, $attr );
        }
		if ( $node->firstChild==null )
			return $attr;
			
        for ( $conf = $node->firstChild; $conf!=NULL; $conf = $conf->nextSibling ) {
        
            if ( $conf->nodeType!=XML_ELEMENT_NODE ) continue;
            
            $name = $conf->localName;
            if ( isset($table[$name]) )     
                $this->setAttr( $conf, $name, $table, $attr );
            
        }
        //print_r( $attr );
        return $attr;
	}
	function create( ) {
		$backup = new DOMDocument;
        $backup->preserveWhiteSpace = false;
        $backup->formatOutput = true;
        
		$this->dom = $backup;
        
		$main = $backup->appendChild($backup->createElement('configuration') );
        $main->setAttribute("version", $this->version );
		// need to open the different components to get all the needed info
		
        // wizard
        $wiz = new Wizard();
        $this->setAll( $main, false, $wiz, self::$wizard_map );
        
        // player config
		$config = new PlayerConfig;
		$config->backupMode=true;
        
        //fusion
        $fusion = new FusionSetup;
        $fusion->scenario = "backup";
        
        if ( Yii::app()->user->branding->fusion ) {
            $this->setAll( $main, false, $fusion, self::$fusion_map);
        }
        
		// display
        $screen = new ScreenSettings;
		$screen->load();
		$display = $main;
        
		if ( $screen->modeSelect==2 || ( $screen->modeSelect==1 && $screen->advancedtype=="screen" ) ){
            $this->set( $display, $screen, 'custom', self::$display_map);
		} else {
            $settings = $display->appendChild($backup->createElement('display-video-mode'));
            $this->set( $settings, $screen, array('resolution', 'vfreq', 'forcestdmode', 'type'), self::$display_map);
		}
        
        $this->set( $display, $screen, 'screeenar', self::$display_map);
        $this->set( $display, $screen, 'underscansupp', self::$display_map);
        $this->set( $display, $screen, 'dcoffsetsupp', self::$display_map);
        $this->set( $display, $screen, 'hdmilink', self::$display_map);
        
        $this->set( $display, $screen, 'power', self::$display_map2);
        
        
        $this->set( $display, $config, 'overscan', self::$display_map2);
        $this->set( $display, $config, 'orientation', self::$display_map2);
        $this->set( $display, $config, 'audio', self::$display_map2);
        $this->set( $display, $config, 'audioPowerSave', self::$display_map2);
        
        
		
		//interactivity
		$interactivity = $main;//->appendChild($backup->createElement('interactivity'));
        $this->set( $main, $config, array('events', 'latency', 'interlatency', 'usbIOAPI'), self::$interactivity_map);
        $usb = new USBInfo;
        $usb->load();
        $this->set( $interactivity, $usb, 'extendedUSB', self::$interactivity_map);
        
        // splash screens
        $splash = new SplashScreen;
        $splash->load();
        foreach ( $splash->filepath as $name=>$path ){
            $spl = $main->appendChild( $backup->createElement("splash") );
            $this->set( $spl, $name, 'name' );
            if ( $path!==null )
                $this->set( $spl, basename($path), 'file' );
        }
        
        // network
        $network = new IPConfig;
        $network->load();
        $networkxml = $main;
        if ( $network->netiface==IPConfig::NET_ETHERNET ) {
            $ethernet = $networkxml;//->appendChild($backup->createElement('network-ethernet'));            
            if ( !$network->dhcp ) {
                $fix = $ethernet->appendChild($backup->createElement('ethernet-static'));
                $this->set( $fix, $network, array('address', 'netmask', 'gateway', 'nameserver1', 'nameserver2', 'nameserver3', 'domain'), self::$network_map);
            } else
                $fix = $ethernet->appendChild($backup->createElement('ethernet-dhcp'));            
        } else {
            // 3G Modem
            $modem3g = $networkxml;//->appendChild($backup->createElement('network-modem-3g'));
            $modem = new Modem3G;
            $modem->load();
            if ( $modem->simple )
                $node = $modem3g->appendChild($backup->createElement('modem-3g-simple'));
            else
                $node = $modem3g->appendChild($backup->createElement('modem-3g-advanced'));
            
            foreach ($modem->getFormNames() as $fname) {
                if ( ! $modem->isFieldActive($fname) )
                    continue;
                if ( (!$modem->simple && $modem->isSimpleOnly($fname) ) || ($modem->simple && $modem->isAdvancedOnly($fname)) )
                    continue;
                $name = strtolower( str_replace(array(" ","#"), array("-",""), $modem->getFieldDesc($fname) ) );
                
                $node->appendChild($this->dom->createElement($name, htmlspecialchars($modem->getField($fname)) ));
            }
        }
        
        //identification
        $this->setAll( $main, false, $config, self::$id_map );
        
        //net-api
        $this->setAll( $main, false, $config, self::$netapi_map);
        
        //https
        $this->setAll( $main, false, $config, self::$https_map);
		
		$main->appendChild( $backup->createElement('certificates-reset') );
		$ssl = new SSLConfig;
		foreach ($ssl->getFileList( false ) as $file) {
			$cert_xml = $main->appendChild( $backup->createElement('certificate') );
            $cert_xml->appendChild( $backup->createCDATASection( $ssl->backupCertificate( $file['filename'] ) ) ) ;
		}
        
        //net-watchdog
        $watchdog = new NetworkWatchdog;
        $watchdog->load();
        $this->setAll( $main, 'network-watchdog', $watchdog, self::$watchdog_map);
        
        //credential
		if ( $this->backupPassword ) {
			$credit = new CredentialsConfig;
			$credit->load();
			$main->appendChild($backup->createElement('credential-reset'));
			foreach ($credit->credits as $server){
				$this->setAll( $main, 'credential', $server, self::$credit_map );
			}
		}
        //proxy
        $proxy = new ProxyConfig;
        $proxy->load();
        if ( $proxy->server!="" )
            $this->setAll( $main, 'proxy', $proxy, self::$proxy_map);
        else
            $this->setAll( $main, 'proxy', $proxy, array( 'server'=>'server') );
        
        //snmp
        $snmp = new SNMPConfig;
        $snmp->load();
		$snmpxml = $main->appendChild($backup->createElement('snmp-' . $snmp->access));
		if ( $snmp->access=='limited' ){
			$this->set( $snmpxml, $snmp, 'snmpaddress', self::$snmp_map);
		}
        $this->set( $main, $snmp, 'rocommunity', self::$snmp_map);
        
        //sources
        if ( !$fusion->active ) {
            $sources = new SourceConfig;
            $sources->playerConf = $config;
            $sources->load();
            $this->setAll( $main, false, $sources, self::$source_map);
        }        
        // users
		if ( $this->backupPassword ) {
			$security = new SecurityJobs;
			$users = $security->getUsers();
			$sec = $main;//->appendChild($backup->createElement('security'));

			foreach ( $security->spxpass_realm as $user=>$digests ) {
				$entry = $sec->appendChild($backup->createElement("user"));
				$entry->appendChild($backup->createElement( "username", $user ) );    
				if ( $security->isProtected( $user ) ) {
					foreach ( $digests as $digest ) {
						$usr = $security->getUser($users, $user, $digest, $idx );
						if ( $usr!==false ) {
							$entry->appendChild($backup->createElement( 'digest', htmlspecialchars($usr['pass']) ) )->setAttribute("realm", $digest) ;
						}
					}
				}
			}
		}
		// timezone
		$time = new TimeSettings;
		$time->load();
        $this->setAll( $main, false, $time, self::$time_map);
		
		//time
		$ntp = new NTPSettings;
		$ntp->load();
		$ntptime = $main;//->appendChild($backup->createElement('time'));
		if ( !$ntp->active ) {
            $manual = $ntptime->appendChild($backup->createElement('time-manual'));
			//$this->set( $manual, $ntp, array('time', 'date'), self::$ntp_map);
		} else {
            $n = $ntptime->appendChild($backup->createElement('time-ntp'));
			$this->set( $n, $ntp, 'bootdelay', self::$ntp_map);
			$this->setAll( $n, false, $ntp, self::$ntpserver_map);
		}
		
		// temperature
		if ( Yii::app()->user->info->model=='Sakura' ) {
			$hwd = new HardwareSetup;
			$hwd->load();
			$this->setAll( $main, false, $hwd, self::$temperature_map );
		}
		
		// power
		$power = new SerialConfig;
        $power->playerConf = $config;
		$power->load();
		$this->set( $main, $power, 'enablePowerSave', self::$power_map);
		
		if ( $power->backupType!="disabled" || $power->enablePowerSave ) {
			if ( $power->fixedMonPower ){
				$set = $main->appendChild($backup->createElement('display-power-schedule'));
				$this->set( $set, $power, array( 'onTime', 'offTime' ), self::$power_map);
			} else 
                $set = $main->appendChild($backup->createElement('display-power-schedule'));
        }
		
		
		// serial-io
        if ( count( $power->getFileList( false ) )===0 ) {
            $main->appendChild($backup->createElement('protocol-file-reset'));
        }
        // resusing $power
        if ($power->backupType!="disabled") {
            if ( $power->backupType=="inline") {
                $this->set( $main, $power->backupName,'protocol-file');
            } else {
                $this->set( $main, $power->backupName,'protocol-system');
			}
        } else {
                $main->appendChild($backup->createElement('protocol-disabled'));
        }

        $set = $main->appendChild($backup->createElement('com-port-settings'));
        if ( $power->enableSerial ) {
            $this->set( $set, $power, array( 'baudRate', 'byteSize', 'parity', 'stopBits', 'enableSerial' ), self::$io_map);
        } else {
            $this->set( $set, $power, array( 'enableSerial' ), self::$io_map);
        }
        
		
		// pull mode
        $pull = new PullModeConfig;
        $pull->load();
        $pullxml = $main;//->appendChild($backup->createElement('pull-mode'));
        
        $node = $pullxml->appendChild($backup->createElement( "pull-mode-".$pull->selectMode ));
        if ( $pull->selectMode==PullModeConfig::PULL_STATIC ) {
            $this->set( $node, $pull, array('enable_log','enable_project','enable_rpc'), self::$pullmode_map);
            if ( $pull->enable_project ){
                $pr = $node->appendChild($backup->createElement('project'));
                $this->set( $pr, $pull, array('project_source','timeProj'), self::$pullmode_map);
            }
            if ( $pull->enable_log ){
                $lg = $node->appendChild($backup->createElement('logs'));
                $this->set( $lg, $pull, array('log_source','timeLog','log_type'), self::$pullmode_map);
            }
			if ( $pull->enable_rpc ){
                $rpc = $node->appendChild($backup->createElement('rpc'));
                $this->set( $rpc, $pull, array('concentrator','polling','notification_only'), self::$pullmode_map);
            }
        } else if ( $pull->selectMode==PullModeConfig::PULL_FILE ) {
            $n = $node->appendChild( $backup->createElement('ics-file') );
            $n->appendChild( $backup->createCDATASection( $pull->getSchedule() ) );
        } else if ( $pull->selectMode==PullModeConfig::PULL_REMOTE ) {
            $this->set( $node, $pull, array('uri','checktime'), self::$pullmode_map);
        }
        //firmware
        $firmware = new FirmwareUpdate;
        $firmware->scenario = "backup";
        $firmware->load();
        $this->setAll( $main, false, $firmware, self::$firmware_map);
        
        
        if ( !Yii::app()->user->status->installationmode ) {
            $main->appendChild($backup->createElement( "reboot" ) );
        }
        
        return $backup->saveXML();
	}
	
	function apply( $backupstr, $tmpfolder="" ) {
	
		$backup = new DOMDocument;
        try {
		    $ok = $backup->loadXML( $backupstr );
		} catch (Exception $e) {
            $this->addError('', 'Cannot parse backup file: '.$e->getMessage() );
        }  
        if ( !$ok ) {
            $this->addError('', 'Cannot parse backup file' );
            return;
        }
		$main = $backup->documentElement;
		
        $version = $main->getAttribute("version");
        $f1a = explode(".", $version);
        $f2a = explode(".", $this->version );
        if ( $f1a[0]!=$f2a[0] ){
            // not the same major version, we do not try to parse this
            $this->addError('', 'Backup version is not corect ('.$f1a[0]."!=".$f2a[0].')' );
            return;
        }
        
        
		$config_file = new PlayerConfig;
		
		$serial = Yii::app()->user->info->serial;
		
        $allOK = true;
        
        $wiz = new Wizard;
        $welcome = $wiz->getWelcome();
        
        $screen = null;
        $splash = null;
        $power = null;
        $usb = null;
        $network = null;
		$modem = null;
        $watchdog = null;
        $credit = null;
        $proxy = null;
        $snmp = null;
        $sources = null;
        $security = null;
		$time = null;
		$ntp = null;
		$hwd = null;
        $pull = null;
        $firmware = null;
        $fusion = new FusionSetup;
        $ssl = new SSLConfig;
		
        $reboot = false;
        
        $check_screen_config = false;
        
		for ( $conf = $main->firstChild; $conf!=NULL; $conf = $conf->nextSibling ) {
        	if ( $conf->nodeType!=XML_ELEMENT_NODE )
				continue;
        	switch ($conf->localName){
                case "wizard":
                    $this->getAll($wiz, false, $conf, self::$wizard_map );
                    break;
				case "screeen-aspect-ratio": // typo in version 1.0
                    if ( !$screen ) $screen = new ScreenSettings;
                    $this->getAll($screen, 'backup', $conf, array( 'screeen-aspect-ratio'=>'screeenar' ) );
                    break;                    
                case "display-custom-video-mode": 
                case "display-video-mode":
                    $check_screen_config = true;
                case "screen-aspect-ratio":
                case "underscan-supported":
                case "vga-dc-offset":
                case "hdmi-link-type":
                    if ( !$screen ) $screen = new ScreenSettings;
                    $this->getAll($screen, 'backup', $conf, self::$display_map );
                    break;                    
                case "overscan-percentage": 
                case "display-orientation": 
                case "enable-audio":
                case "audio-power-save":
                    $this->getAll($config_file, 'display', $conf, self::$display_map2 );
                    break;
                case "vga-power-mode":
                    if ( !$screen ) $screen = new ScreenSettings;
                    $this->getAll($screen, 'power', $conf, self::$display_map2 );
					break;                
                case "accepts-events": 
                case "maximum-latency": 
				case "reduce-interactive-latency": 
                case "enable-USB-IO-API":
                    $this->getAll($config_file, 'inter', $conf, self::$interactivity_map );
					break;
                case "extended-USB": 
                    $usb = new USBInfo;
                    $this->getAll($usb, false, $conf, self::$interactivity_map );
					break;     
                case "splash":
                    if ( !$splash ) $splash = new SplashScreen;
                    $attr = $this->get( $conf, array("name"=>"name", "file"=>"file" ) );
                    if ( isset( $attr['file'] ) )
                        $splash->addFile( $attr['name'], $tmpfolder.$attr['file'] );
                    else
                        $splash->addFile( $attr['name'] );
                    break;                
                case "ethernet-static":
                case "ethernet-dhcp":
                    if ( ! $network ) {
                        $network = new IPConfig;
                        $network->load();
                    }
                    $network->netiface = IPConfig::NET_ETHERNET;
                    if ( $conf->localName=='ethernet-dhcp' ){
                        $network->setScenario( 'dhcp' ); 
                        $network->dhcp = true;                        
                    } else {
                        $network->setScenario( 'fixip' ); 
                        $network->dhcp = false;
                        
                        $attr = $this->get( $conf, self::$network_map );
                        // make sure that default are set to the right values
                        $defaults = array('gateway', 'nameserver1', 'nameserver2', 'nameserver3', 'domain');
                        foreach ( $defaults as $name ) {
                            if ( !isset($attr[$name]) )
                                $attr[$name] = "";
                        }
                        $network->setAttributes( $attr ); // for the fixed IP strings
                    }
                    
                    if ( !$network->validate() || !$network->checkConfig() ){
                        $this->addErrors( $network->getErrors() );
                        $network->clearErrors();
                    }
                    break;   
                case "modem-3g-simple":
                case "modem-3g-advanced":
                    if ( ! $network ) {
                        $network = new IPConfig;
                        $network->load();
                    }
                    $network->setScenario( 'modem3g'  );
                    $network->netiface = IPConfig::NET_MODEM;
                    if ( !$network->validate() ){
                        $this->addErrors( $network->getErrors() );
                        $network->clearErrors();
                    }
                        
                    $modem = new Modem3G;
                    $modem->load();
                    if ( $conf->localName=="modem-3g-simple" )
                        $modem->simple = true;
                    else
                        $modem->simple = false;
                    
                    foreach ($modem->getFormNames() as $fname) {
                        if ( ! $modem->isFieldActive($fname) )
                            continue;
                        $name = strtolower( str_replace(array(" ","#"), array("-",""), $modem->getFieldDesc($fname) ) );
                        $map[$name]= $fname;
                    }
                    $attr = $this->get( $conf, $map );
                    
                    $modem->setAttributes( $attr );
                    if ( $modem->isPINBlocked() ) {
                        $modem->resetPIN();
                    }
                    if ( !$modem->validate() ){
                        $this->addErrors( $modem->getErrors() );
                        $modem->clearErrors();
                    }
                break;
                case "screen-id":
                case "device-name":
                    $this->getAll($config_file, 'id', $conf, self::$id_map );                    
                break;
                case "network-api-enabled":
				case "network-api-port":
                    $this->getAll($config_file, 'netapi', $conf, self::$netapi_map );
                break;
                case "https-validate-certificates":
                    $this->getAll($config_file, 'https', $conf, self::$https_map );
                break;
				case "certificates-reset":
                    $ssl->clearCertificates();
                break;
				case "certificate":
                    $ssl->restoreCertificate( trim($conf->textContent) );
                    if ( $ssl->hasErrors() ){
                        $this->addErrors( $ssl->getErrors() );
                        $ssl->clearErrors();
                    }
                break;
				case "network-watchdog":
                    $watchdog = new NetworkWatchdog;
                    $this->getAll($watchdog, false, $conf, self::$watchdog_map );
                break;
                case "credential-reset":
                    $credit = new CredentialsConfig;
                break;
                case "credential":
                    if ( $credit===null ) {
                        $credit = new CredentialsConfig;    
                        $credit->load();
                    }
                    $server = new Credentials;
                    $this->getAll($server, false, $conf, self::$credit_map );
                    $credit->addCreditential($server);
                break;
                case "proxy":
                    $proxy = new ProxyConfig;
                    $attr = $this->getAll($proxy, false, $conf, self::$proxy_map );  
                break;
                case "snmp-local":
				case "snmp-limited":
				case "snmp-all":
				case "snmp-rocommunity":
					if ( !$snmp ) {
						$snmp = new SNMPConfig;
						$snmp->load();
					}
					if ( $conf->localName=="snmp-rocommunity" ) {
						$this->getAll( $snmp, 'community', $conf, self::$snmp_map );
					} else {
						$snmp->access = substr( $conf->localName, 5 );
                        if ( $snmp->access=="limited" )
                            $snmp->snmpaddress = ""; // reset the address to make it compulsory
						$this->getAll( $snmp, 'backup-'.$snmp->access, $conf, self::$snmp_map );
					}
                break;
                case "primary-source":
				case "secondary-source":
				case "allow-usb-sources":
                    if ( $fusion->active ) {
				        $this->addError("", "Cannot change media source when Fusion is activated");
                        break;
			        }
					if ( !$sources ) {
						$sources = new SourceConfig;
						$sources->playerConf = $config_file;
						$sources->load();
					}
                    $this->getAll($sources, false, $conf, self::$source_map );  
                break;
                case "user":
                    if ( !$security ) {
                        $security = new SecurityJobs;
                        $users = $security->getUsers();
                    }
                    $username = "";
                    $password = false;
                    $passdigest = false;
                    $realm = false;
                    for ( $entry = $conf->firstChild; $entry!=NULL; $entry = $entry->nextSibling ) 
                        if ( $entry->nodeType==XML_ELEMENT_NODE ) {
                            if ( $entry->localName=='username' )
                                $username = $entry->textContent;
                            else if ( $entry->localName=='password' )
                                $password = $entry->textContent;
                            else if ( $entry->localName=='digest' ){
                                if ($passdigest=== false){
                                    $passdigest = array();
                                    $realm = array();
                                }
                                $passdigest[] = $entry->textContent;
                                if ( $entry->hasAttribute("realm") )
                                    $realm[] = $entry->getAttribute("realm");
                                else
                                    $realm[] = false;
                            }
                        }
                    if ( !isset( $security->spxpass_realm[$username] ) ) {
                        $this->addError("username", "must be one of the following: admin, content or monitoring");
                        break;
                    }
                    $security->clearUser( $users, $username );
                    
                    //echo "$username : $password : $digest\n<br/>";
                    if ( $password===false && $passdigest===false ) {
                        // clearing the user 
                        $security->clearAccess( $username );
                    } else {
                        if ( $password!==false ) {
                            foreach( $security->spxpass_realm[$username] as $realm )
                                $security->addUser($users, $username, $realm, $password);
                        } else {
                            $realms = $security->spxpass_mendatory_realm[$username];
                            if ( count( $realms ) > count($passdigest) ){
                                $this->addError("digest", "incorect number of digest provided");
                                break;
                            } 
                            foreach ($realms as $r)
                                if ( !in_array($r, $realm) && ( count( $realm )!=1 || $realm[0]!==false ) ){
                                    $this->addError("digest", "the required realm for $username is missing");
                                    break 2;
                                }
                            for ($i=0; $i<count($passdigest); $i++) {
                                $security->addUser($users, $username, $realm[$i], $passdigest[$i], true);
                            }
                        }
                        $security->setAccess( $username );
                    }
                break;
				case 'timezone':
					$time = new TimeSettings;
					$this->getAll($time, 'timezone', $conf, self::$time_map );     
				break;
				case 'time-manual':
                case 'time-ntp':
					$ntp = new NTPSettings;
					$attr = $this->get( $conf, self::$ntp_map );
                    
					if ( $conf->localName=='time-manual' ) {
						$ntp->setScenario('manual');
                        $ntp->active = false;                        
                    }else {
                        $ntp->active = true;
                        $ntp->setScenario('ntp');
                    }
                    $ntp->setAttributes( $attr );
					$this->getAll($ntp, false, $conf, self::$ntpserver_map ); 
				break;
				case 'shutdown-temperature':
					if ( Yii::app()->user->info->model=='Sakura' ) {
						$hwd = new HardwareSetup;
						$this->getAll($hwd, false, $conf, self::$temperature_map );  
					}
				break;
                case "display-power-save": 
					if ( $power==null ) {
                        $power = new SerialConfig;
                        $power->playerConf = $config_file;
						$power->load();
                    }
					$attr = $this->getAll($power, 'display', $conf, self::$power_map );  
					break;
				case "display-power-schedule": 
                    if ( $power==null ) {
                        $power = new SerialConfig;
                        $power->playerConf = $config_file;
						$power->load();
                    }
					$attr = $this->getAll($power, 'display', $conf, self::$power_map );  
					if ( count($attr)==0 ){
						$power->setFixedMonPower(false);
						$power->modified = true;
					} else if ( count($attr)==2 ){
						$power->setFixedMonPower(true);
					} else {
                        $this->addError("display-power-schedule", "on-time and off-time must be specified.");
                    }
					break;                    
				case 'com-port-settings':
					if ($power==null) {
                        $power = new SerialConfig;
                        $power->playerConf = $config_file;
						$power->load();
                    }
					$attr = $this->getAll($power, 'backup', $conf, self::$io_map );
					if ( count($attr)==0 ){
						$power->modified = true;
					}
					break;
                case "protocol-file-reset":
                    if ($power==null) {
                        $power = new SerialConfig;
                        $power->playerConf = $config_file;
						$power->load();
                    }
                    $power->deleteAll();
                break;
				case 'protocol-disabled':
				case 'protocol-system':
				case 'protocol-file':
                    if ($power==null) {
                        $power = new SerialConfig;
                        $power->playerConf = $config_file;
						$power->load();
                    }
					$attr = $this->get( $conf, self::$io_map );
					$power->setScenario( 'backup' );
					$power->setAttributes( $attr );
					
					if ( !isset($attr['backupName']) )
						$attr['backupName'] = "";
					if ( $conf->localName=='protocol-disabled' ){
						$power->setBackup('disabled' );
					} else if ( $conf->localName=='protocol-system' ){
						$power->setBackup('system', $attr['backupName'] );
					} else if ( $conf->localName=='protocol-file' ){
						$content = "";
						for ( $node = $conf->firstChild; $node!=NULL; $node = $node->nextSibling ) {
                            if ( $node->nodeType==XML_ELEMENT_NODE && $node->localName=="fsm-file" ) {
                                $newdoc = new DOMDocument;
                                $f = $node->firstChild;
                                while ( $f!=null && $f->nodeType!=XML_ELEMENT_NODE && $f->localName!="protocol" )
                                    $f = $f->nextSibling;
                                $newdoc->appendChild($newdoc->importNode($f, true));
                                $content = $newdoc->saveXML();
                            }
						}
                        $power->setBackup('inline', $attr['backupName'], $content );
					}
					if ( $power->hasErrors() || !$power->validate() ){
						$this->addErrors( $power->getErrors() );		
                        $power->clearErrors();
					}
                break;
                case 'pull-mode-'.PullModeConfig::PULL_STATIC:
                case 'pull-mode-'.PullModeConfig::PULL_FILE:
                case 'pull-mode-'.PullModeConfig::PULL_REMOTE:
                case 'pull-mode-'.PullModeConfig::PULL_DISABLED:
                
                    $pull = new PullModeConfig;
                    $pull->load();
                    $pull->backup = true;
                    $pull->setSelectMode( substr($conf->localName, 10 ) );
                    
                    $attr = $this->get( $conf, self::$pullmode_map );                    
                    $pull->setAttributes( $attr );
                    
                    if ( !$pull->validate() ){
                        $this->addErrors( $pull->getErrors() );
                        $pull->clearErrors();
                    }
                break;
                case 'firmware-update-uri':
					if ( !$firmware ) {
						$firmware = new FirmwareUpdate;
						$firmware->load();
					}
                    
                    $attr = $this->getAll($firmware, 'backup', $conf, self::$firmware_map );  
                    if ( $attr['updateuri']=="" )
                        $firmware->resetUri();
                break;
                case 'firmware-update-auto':
					if ( !$firmware ) {
						$firmware = new FirmwareUpdate;
						$firmware->load();
					}
                    $this->getAll($firmware, 'backup', $conf, self::$firmware_map );  
                break;
                case 'enable-fusion':                
                    if ( Yii::app()->user->branding->fusion ) {
                        
                        $this->getAll($fusion, 'backup', $conf, self::$fusion_map );  
                        
                        if ( $fusion->active ) {
                            $sources = new SourceConfig;
                            $sources->load();
                            $sources->setAttributes( array('primaryType'=>'local') );
                        }                        
                    }
                break;
                case 'fusion-startup':
                if ( Yii::app()->user->branding->fusion ) {
                    $this->getAll($fusion, 'backup', $conf, self::$fusion_map );  
                }
                break;
                case 'reboot':
                    $reboot = true;
                break;
			}
		}
        if ( $screen && !$screen->hasErrors() && $check_screen_config ) {
            if ( !$screen->check() )
                $this->addErrors( $screen->getErrors() );
        }
        if ( !$this->hasErrors() ) {
            if ( $welcome ) {
                // make sure this is now configured
                $wiz->setActive( $wiz->getActive() );
                
                // need to reset the image and replace it by the content
                if ( !$sources ) {
                    $sources = new SourceConfig;
                    $sources->playerConf = $config_file;
                    $sources->load(); 
                    $sources->save(); 
                }
            }
            
            if ( $screen )
                $screen->save();
            if ( $power )
                $power->save();
            if ( $usb )
                $usb->save();
            if ( $splash )
                $splash->save();
            if ( $network )
                $network->save();
            if ( $modem )
                $modem->save();
            if ( $watchdog )
                $watchdog->save();
            if ( $credit ) 
                $credit->save();
            if ( $proxy ) 
                $proxy->save();
            if ( $snmp ) 
                $snmp->save();
            if ( $sources )
                $sources->save();
			if ( $time )
                $time->save();
			if ( $ntp )
                $ntp->save();
			if ( $hwd )
                $hwd->save();
            if ( $pull )
                $pull->save();
            if ( $firmware )
                $firmware->save();
			if ( $fusion ) {
				$fusion->save();
                if ( $fusion->needreload )
                    $this->needreload = 1;
                $fusion->enableBackup( $tmpfolder."fusion-default.7z" );
            }
            $config_file->saveConfig();
            
           
            if ( $security ) {
                $security->saveUsers( $users );
                if ( $security->needreload )
                    $this->needreload = 1;
            }
            
            if ( $welcome && !Yii::app()->user->tools->doShutdown() ) {
                // insure that one reboot will be done
                Yii::app()->user->tools->addReason("initial configuration");
            }
            
            if ( $reboot ) {
                if ( Yii::app()->user->status->installationmode ){
                    $job = new Maintenance;
                    $job->forcedReboot();
                }
            } else {
                if ( Yii::app()->user->tools->doShutdown() ) {
                    $job = new Maintenance;
                    $job->instalationMode( ); 
                }
            }
            
            Yii::app()->user->tools->messages[] = "<h3>Configuration applied successfully</h3>";
        }
         
	}
    function reloadConfig() {
        if ($this->needreload) {
            # Push everything to http server before reloading the server's config
            ob_flush();
            flush();
            # This must be at the very end, otherwise apache graceful restart
            # may still close the connection to the FastCGI server process running
            # this script.
            exec('/etc/init.d/apache reload < /dev/null > /dev/null 2> /dev/null &');
        }
            
    }    
}
