<?php

require_once dirname(__FILE__).'/../utils/MainInfo.php';

class DiskInfo extends CModel {
	
	var $system;
    var $local;
    var $internal;
    
    
    public function attributeNames() {
        return array("system", "local", "internal" );
    }
    public function rules() {
		$res = array(
    	);
        return $res;
	}
    
    public function attributeLabels()
	{
		return array(
            'useUSBAsStorage'=>'Local Storage set to : ',
		);
	}
    public function load() {
        $this->system = getDiskInfo("/");
        
        $path="/srv/raperca/content";
        $isContentNotInternal = $this->isMounted($path);
        $this->local = getDiskInfo($path);
     
        $path="/srv/.shadow-raperca";
        if ( $isContentNotInternal && $this->isMounted($path) )
            $this->internal = getDiskInfo($path);
        else
            $this->internal = false;
                
    }
    
    function fillUsageTable($path) {
        $info=exec('df -B 1048576 -P '.$path);
        
        $spaces=preg_split("@\s+@",$info);
     
        $info = array();
        if ( count($spaces)>=4) {
            $info['available']=$spaces[3];
            $info['used']=$spaces[2];
            $info['tot']=$spaces[1];
        } else if ( file_exists($path) ){
            $info['available']=floor(disk_free_space($path)/1024/1024);
            $info['used']="unknown";
            $info['tot']=floor(disk_total_space($path)/1024/1024);
        } else {
            $info['available']="error";
            $info['used']="error";
            $info['tot']="error";
        }
        return $info;
    }
    
    function isMounted($dir) {
        if ( !file_exists("/proc/mounts") ) return false;
        $mount=file_get_contents("/proc/mounts");
        $mounts=explode("\n",$mount);
        foreach ($mounts as $mount){
            $info=preg_split("/\s/",$mount);
            if ($info[1]==$dir)
                return true;
        }
        return false;
    }
}