<?php

require_once 'protected/utils/Updater.php';

class FirmwareUpdate extends CFormModel {
	
    protected $updaterfile='/etc/updater.conf';
    protected $defaults_updaterfile='/usr/share/resources/default/updater/defaults.conf';
    protected $timefile="/etc/cron.d/updater";
    
    var $statusStr=array('READY'=>"Updater ready for updates",
                         'DELAYING'=>"Waiting for download",
                         'ANALYZING'=>"Analyzing system and repository for updates",
                         'DOWNLOADING'=>"Downloading packages to be updated / installed",
                         'TESTING'=>"Testing package install",
                         'UPDATING'=>"Updating / installing packages",
                         'PKGSDONE'=>"Finished updating / testing the packages",
                         'CORRUPTED'=>"Previous run was interrupted while updating / installing packages; System is most probably corrupted",
                         'REBOOTING'=>"Finished updating, device is rebooting",
                         );
    var $status;
    var $statuslines;
    var $statustime=0;
    
    var $_firmwareVersion=false;
    var $_firmwareBuild=false;
    var $_updaterVersion=false;
    var $_updaterBuild=false;
    var $_spxjslibsVersion=false;
    var $_spxjslibsBuild=false;
    var $updateuri=false;
    var $updateauto=false;
    
    var $justStarted = false;
    
    var $updatesource="server";
    var $updatesourceList = array("server"=>"From server", "usb"=>"From USB Key" );
    
    var $log_id = false;
    var $mode = null;
    var $updater = false;
    
    protected $fastNoUpdateCheck = false;
    public function init() {
        parent::init();
        $this->updater = new Updater;
        $this->updater->product = Yii::app()->user->branding->product;
        $this->updater->email = Yii::app()->user->branding->email;
    }
    public function rules() {
		$res = array(
            array( "updateAutoString", 'checkAutoUpdate', 'on'=>'backup' ),
            array( "updateuri", 'SimpleURLValidator', 'on'=>'uri, backup, all' ),
            array( "updateauto", 'numerical', 'min'=>-1, 'max'=>23, 'on'=>'time, all' ),
            array( "updatesource, mode", 'safe', 'on'=>'check' ),
            array( "log_id, mode, updatesource", 'safe', 'on'=>'update' ),
            
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'updateuri'=>'Server URI',
            'doupdateauto'=>'Enable automatic updates',
            'updateauto'=>'Update time',
            'firmwareVersion'=>'Firmware',
            'firmwareBuild'=>'build',
            'updaterVersion'=>'Updater',
            'updaterBuild'=>'build',
            'spxjslibsVersion'=>'JS Libraries',
            'spxjslibsBuild'=>'build',
            'updatesource'=>'Update source',
    	);
	}
    public function checkAutoUpdate( $attribute ){
        $value = $this->updateauto;
        if ( !is_numeric($value) ){
            $this->addError($attribute, "Update time not recognized");
            return false;
		}
        if ( $value<-1 || $value>23 ) { // accept -1 as it means disabled
            $this->addError($attribute, "Update time must be between 0 and 23");
            return false;
        }
        return true;
    }
    static function updateInProgress() {
        $request = Yii::app()->getRequest();
        if ( $request->isPostRequest ) {
            
            if ( isset($_POST['reboot']) || isset($_POST['rebootrecovery']) || ( isset($_POST['FirmwareUpdate']) && isset($_POST['FirmwareUpdate']['log_id']) ) )
                return ; // this is always fine
                
            // Should check if we are doing an update, and in this case, redirect to 
            if ( Updater::isUpdateInProgress() ) {
                 $request->redirect( $request->baseUrl.'/index.php?r=error/update' );
            }
        }
    }
    
    
    function getUpdateAutoString() {
        if ( $this->updateauto==-1 )
            return "no";
        else
            return $this->updateauto;
    }
    function setUpdateAutoString( $str ) {
        if ( $str=="no" )
            $this->updateauto = -1;
        else if ( is_numeric($str) )
            $this->updateauto = intval($str, 10);
        else
            $this->updateauto = $str;
    }
    function getDoUpdateAuto() {
        return $this->updateauto!=-1;
    }
    function getFirmwareVersion() {
        if ( $this->_firmwareVersion==false) {
            $output=array();
            if ( PHP_OS == "WINNT" )
                $output=array(Yii::app()->user->branding->releasepkg."\t2.2.0\t0.2.10561","updater\t1.0\t2.0.10547","spxjslibs\t1.0\t1.0.10547" );
                //$output=array(Yii::app()->user->branding->releasepkg."\t2.2.0\t0.2.10561","updater\t1.0\t2.0.10547" );
            else
                exec("rpm -q --queryformat '%{NAME}\t%{VERSION}\t%{RELEASE}\n' ".Yii::app()->user->branding->releasepkg." updater spxjslibs",$output);
            foreach ( $output as $out ) {
            
                $data = explode( "\t", $out );
                if ( count($data)!=3 )
                    continue;
                if ( $data[0]==Yii::app()->user->branding->releasepkg ) {
                    $this->_firmwareVersion = $data[1];
                    $this->_firmwareBuild = $data[2];
                } elseif ( $data[0]=="updater" ) {
                    $this->_updaterVersion = $data[1];
                    $this->_updaterBuild = $data[2];
                } elseif ( $data[0]=="spxjslibs" ) {
                    $this->_spxjslibsVersion = $data[1];
                    $this->_spxjslibsBuild = $data[2];
                }
                
            }
            
            if ( $this->_firmwareVersion === false || $this->_updaterVersion === false ) {
                $email = Yii::app()->user->branding->email;
                if ( $this->getError("_firmwareVersion")==null )
                    $this->addError("_firmwareVersion", "Firmware error: please contact <a href='mailto:$email' >$email</a>");
            }
        }
        return $this->_firmwareVersion;
    }
    
    function getFirmwareBuild() {
        if ( $this->_firmwareBuild==false) $this->getFirmwareVersion();
        return $this->_firmwareBuild;
    }
    function getUpdaterVersion() {
        if ( $this->_updaterVersion==false) $this->getFirmwareVersion();
        return $this->_updaterVersion;
    }
    function getUpdaterBuild() {
        if ( $this->_updaterBuild==false) $this->getFirmwareVersion();
        return $this->_updaterBuild;
    }
    function getSpxjslibsVersion() {
        if ( $this->_spxjslibsVersion==false) $this->getFirmwareVersion();
        return $this->_spxjslibsVersion;
    }
    function getSpxjslibsBuild() {
        if ( $this->_spxjslibsBuild==false) $this->getFirmwareVersion();
        return $this->_spxjslibsBuild;
    }
    function load() {
        $default_uri = "";
        $defdoc = new DOMDocument;
        if ( $defdoc->load($this->defaults_updaterfile) ) {
            $xp = new DOMXPath($defdoc);
            $nl = $xp->query("repository[@id='base']/location/@href");
            if ($nl->length) {
                 $default_uri = $nl->item(0)->value;
            }
        }
        if ( empty($default_uri) ) {
            $this->addError("", "Missing server URI in defaults updater file.");   
        }
        
        $conf=file_get_contents($this->updaterfile);
        if ($conf) {

            $domdoc = new DOMDocument;
            $domdoc->preserveWhiteSpace = false;
            $domdoc->formatOutput = true;
            $domdoc->loadXML($conf);
            $xp = new DOMXPath($domdoc);

            // backwards compat with old default repository id
            $nl = $xp->query("repository[@id='hmp100']/location/@href");
            if ($nl->length) { 
                $nlid = $xp->query("repository[@id='hmp100']/@id");
                if ($nlid->length)
                    $nlid->item(0)->value = 'base'; // change old to new
            }

            $nl = $xp->query("repository[@id='base']/location/@href");

            if ($nl->length) {
                $this->updateuri = $nl->item(0)->value;
            }
        }
        if ( !$this->updateuri && $this->scenario!="backup" ) {
            $this->updateuri = $default_uri;
        }
        
        $conf=file_get_contents($this->timefile);
        if (!$conf || $conf=="")
            $this->updateauto=-1;
        elseif (preg_match("@^\s*(\d+)\s+(\d+).*/usr/sbin/updater@m",$conf,$matches))
            $this->updateauto=$matches[2];
        else 
            $this->updateauto=-1;
        
    }
    function save() {
        if ( $this->updateuri ) {
            $conf=file_get_contents($this->updaterfile);
            if (!$conf) {
                $this->addError("updateuri", "Update file not found, cannot save modifications.");
                return false;
            }

            $domdoc = new DOMDocument;
            $domdoc->preserveWhiteSpace = false;
            $domdoc->formatOutput = true;
            $domdoc->loadXML($conf);
            $xp = new DOMXPath($domdoc);

            // backwards compat with old default repository id
            $nl = $xp->query("repository[@id='hmp100']/location/@href");
            if ($nl->length) { 
                $nlid = $xp->query("repository[@id='hmp100']/@id");
                if ($nlid->length)
                    $nlid->item(0)->value = 'base'; // change old to new
            }

            $nl = $xp->query("repository[@id='base']/location/@href");

            if ($nl->length) {
                 $nl->item(0)->value = trim($this->updateuri);
            } else {
                $nl = $xp->query("*[@id='base']");
                if ($nl->length) {
                    $this->addError("updateuri", "Found incomplete base repository definitions, removing.");
                    foreach ( $nl as $n )
                        $n->parentNode->removeChild($n);
                }
                $repo = $domdoc->createElement('repository');
                $repo->setAttribute('id', 'base');
                $loc = $domdoc->createElement('location');
                $loc->setAttribute('href', trim($this->updateuri));
                $name = $domdoc->createElement('name', 'User updates');
                $main = $domdoc->getElementsByTagName('updater');
                if ($main->length) {
                    $main = $main->item(0);
                    $main->appendChild($repo);
                    $repo->appendChild($loc);
                    $repo->appendChild($name);
                } else {
                    $this->addError("updateuri", "Invalid updater configuration file, cannot save modifications.");
                    $this->updateuri = false;
                }
            }
            if ( $this->updateuri )
                Yii::app()->user->tools->save_file($this->updaterfile, $domdoc->saveXML());	
            
        }
        
        if ( $this->updateauto!==false  ) {
            $content="PATH=/usr/bin:/bin:/usr/sbin:/sbin\n";
            if ($this->updateauto==-1){
                $content.="#0 -1 * * * root /usr/sbin/updater\n";
            }else if ($this->updateauto>=0 && $this->updateauto<24){
                $content.="0 ".$this->updateauto." * * * root /usr/sbin/updater\n";
            }else {
                $this->addError("updateauto", "Non supported time '", htmlentities($this->updateauto), "' no set");
            }
            Yii::app()->user->tools->save_file($this->timefile, $content);	
        }
    }
    
    function resetUri() {
        $dummy="";
        $ret=0;
        exec("/etc/spinetix/config.d/updater reset",$dummy,$ret);
	    if ($ret!=0) 
            $this->addError("", "Cannot reset the update configuration.");
    }
    
    function loadStatus( $loadLog=true ) {
    
        $this->status=$this->updater->getStatus();
        
        $this->statuslines = array();
        if ( $loadLog ){
            $this->statuslines = $this->updater->getLastLog();
            $this->statustime = $this->updater->getLastLogTime();
        }
    }
    function getstatusString() {
        return $this->statusStr[$this->status];
    }
    
    function startUpdate( $blocking = false ) {
        if ( $blocking && $this->updater->fastNoUpdateCheck() ){
            $this->fastNoUpdateCheck = true;
            return true;
        }
        $src ="";
        if ( $this->updatesource!="server" )
            $src = $this->updatesource;
        if ( $this->updater->startUpdate( $this->mode=='check', $src, -1, $blocking) ) {
            $this->log_id = $this->updater->update_id;
            $this->justStarted = true;
        } else {
            $this->AddError("updatesource", $this->updater->errorStr);
            return false;
        } 
        return true;
    }
    
    function isUpdateRunning() {
        if ( $this->fastNoUpdateCheck || $this->justStarted )
            return true;
        return $this->updater->isUpdateRunning( $this->updater->update_pid );
    }
    function getUpdatePid() {
        return $this->updater->update_pid;
    }
    
    function getLog() {
        if ( $this->fastNoUpdateCheck )
            return "";
        if ( $this->log_id===false || $this->log_id=="")
            $logs = $this->updater->getLastLog();
        else            
            $logs = $this->updater->getLog( $this->log_id );
        if ( $logs===false ) return array();
        
        $this->updater->parseLog( $logs );
        if ( $this->mode===false )
            $this->mode = $this->updater->updater_mode;
        
        return $logs;
    }
    
    function getNbUpdates() { 
        if ( $this->fastNoUpdateCheck )
            return 0;
        
        if ( $this->updater->isUpdateRunning( $this->updater->update_pid ) ) return false; // in progress, no button
        
        
        return $this->updater->nb_updates;
    }
}
