<?php

include_once 'protected/utils/MaintenanceJobs.php';

class FusionSetup extends CFormModel {

    protected $fusionconfig="/etc/apache/conf.d/95-raperca-ro.conf";
    protected $fusionstartup="/etc/apache/conf.d/30-fusion-redirect.conf";
    protected $fusionpwd="/var/lib/fusion/data/userpwd.txt";
    
    public $needreload;
    
	protected $_active=null;
    protected $_start=null;
	
    public $activate;
    
    static function fusionfile() {
        return <<<EOL
<?xml version="1.0" encoding="UTF-8"?>
<svg xmlns="http://www.w3.org/2000/svg" xmlns:ev="http://www.w3.org/2001/xml-events" xmlns:xlink="http://www.w3.org/1999/xlink" baseProfile="tiny" height="450" id="Layer_1" snapshotTime="4.250934s" version="1.2" viewBox="0 0 800 450" width="800">
 <spx:properties xmlns:spx="http://www.spinetix.com/namespace/1.0/spx" xmlns:xlink="http://www.w3.org/1999/xlink">
  <spx:media name="textArea_1" positionable="yes" xlink:href="#textArea_1"/>
 </spx:properties>
 <rect fill="#ffffff" height="450" width="800"/>
 <g>
  <path d="M344.531,251.422 C343.705,250.975 342.34,250.761 340.358,250.761 L332.14,250.761 L332.14,267.553 L332.363,267.553 L332.363,267.778 L334.68,267.778 L334.68,261.345 L340.356,261.345 C342.375,261.345 343.752,261.121 344.573,260.66 C345.646,260.061 346.191,258.924 346.191,257.269 L346.191,254.765 C346.191,253.145 345.633,252.016 344.531,251.422 Z M343.549,257.27 C343.549,258.096 343.273,258.622 342.702,258.875 C342.29,259.055 341.491,259.145 340.329,259.145 L334.676,259.145 L334.676,252.964 L340.329,252.964 C341.799,252.964 342.437,253.106 342.712,253.225 C343.275,253.469 343.549,253.998 343.549,254.837 L343.549,257.27 Z M312.601,258.218 L306.634,257.782 C305.732,257.713 305.122,257.498 304.828,257.14 C304.583,256.828 304.456,256.242 304.456,255.404 C304.456,254.195 304.792,253.417 305.453,253.088 C305.932,252.858 307.015,252.737 308.668,252.737 C312.355,252.737 313.479,253.045 313.772,253.302 C313.973,253.476 314.208,253.95 314.208,255.242 L314.208,255.88 L316.747,255.88 L316.768,255.68 C316.789,255.488 316.799,255.215 316.799,254.859 C316.799,253.327 316.412,252.265 315.651,251.705 C314.906,251.155 313.912,250.816 312.611,250.66 C312.034,250.594 310.982,250.56 309.398,250.56 L308.723,250.56 C307.368,250.56 306.468,250.581 305.977,250.623 C304.737,250.736 303.873,251 303.332,251.418 C302.347,252.188 301.847,253.522 301.847,255.382 C301.847,256.959 302.21,258.11 302.932,258.803 C303.653,259.485 304.917,259.891 306.691,260.01 L312.542,260.409 C313.439,260.47 314.011,260.722 314.235,261.158 C314.334,261.347 314.448,261.83 314.448,263.068 C314.448,264.443 314.232,264.934 314.051,265.105 C313.545,265.584 312.308,265.827 310.368,265.827 C306.686,265.827 305.476,265.616 305.109,265.439 C304.467,265.125 304.142,264.125 304.142,262.47 L304.142,261.932 L301.799,261.932 L301.799,262.157 L301.579,262.157 L301.579,262.97 C301.579,264.834 302.075,266.159 303.054,266.908 C303.729,267.42 304.647,267.754 305.79,267.898 C306.34,267.967 307.302,268.002 308.723,268.002 L309.665,268.002 C311.3,268.002 312.368,267.967 312.931,267.898 C314.278,267.732 315.285,267.333 315.924,266.713 C316.675,265.979 317.039,264.682 317.039,262.744 C317.039,261.257 316.723,260.162 316.099,259.489 C315.419,258.76 314.274,258.342 312.601,258.218 Z M360.649,267.553 L360.874,267.553 L360.874,267.778 L363.219,267.778 L363.219,250.761 L360.65,250.761 L360.65,267.553 Z M392.335,265.06 L382.46,250.858 L382.395,250.761 L378.815,250.761 L378.815,267.553 L379.04,267.553 L379.04,267.778 L381.358,267.778 L381.358,253.463 L391.236,267.682 L391.301,267.779 L394.881,267.779 L394.881,250.762 L392.335,250.762 L392.335,265.06 Z M408.98,267.553 L409.205,267.553 L409.205,267.775 L422.751,267.775 L422.751,265.589 L411.521,265.589 L411.521,260.073 L422.433,260.073 L422.433,257.932 L411.521,257.932 L411.521,252.963 L422.751,252.963 L422.751,250.76 L408.98,250.76 L408.98,267.553 Z M434.501,252.746 L434.726,252.746 L434.726,252.971 L440.543,252.971 L440.543,267.778 L443.096,267.778 L443.096,252.971 L449.159,252.971 L449.159,250.761 L434.501,250.761 L434.501,252.746 Z M463.751,267.553 L463.977,267.553 L463.977,267.778 L466.318,267.778 L466.318,250.761 L463.752,250.761 L463.752,267.553 Z M491.151,258.83 L497.744,251.131 L497.574,250.761 L495.008,250.761 L494.943,250.844 L489.79,257.133 L484.608,250.842 L484.539,250.761 L482.008,250.761 L481.838,251.131 L488.42,258.855 L481.119,267.409 L481.288,267.554 L481.288,267.781 L483.785,267.781 L483.854,267.7 L489.813,260.519 L495.697,267.7 L495.766,267.781 L498.252,267.781 L498.422,267.411 L491.151,258.83 Z" fill="#808080">
   <animate attributeName="display" begin="0" calcMode="discrete" dur="2.6" fill="freeze" keyTimes="0;1" values="none;inherit"/>
   <animateColor attributeName="fill" begin="2.6" calcMode="spline" dur="3.7" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0 1 1;0 0 1 1;0 0 1 1" keyTimes="0;0.108;0.514;0.595;0.676;1" values="#808080;#808080;#808080;#808080;#808080;#ffffff"/>
   <animate attributeName="fill-opacity" begin="2.6" calcMode="spline" dur="3.7" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0 1 1;0 0 1 1;0 0 1 1" keyTimes="0;0.108;0.514;0.595;0.676;1" values="0;1;1;0.21;1;1"/>
  </path>
  <path d="M422.8,210.548 L422.8,189.885 C422.8,185.51 419.289,181.997 414.912,181.997 L385.163,181.997 C383.318,181.997 381.701,182.719 380.357,183.775 C380.364,183.993 380.375,184.146 380.381,184.373 C380.443,185.965 380.523,187.706 380.747,189.467 C380.965,191.233 381.321,193.019 381.869,194.742 C382.14,195.607 382.473,196.465 382.862,197.278 C383.244,198.091 383.672,198.865 384.192,199.602 C384.714,200.338 385.302,201.034 385.969,201.664 C386.644,202.301 387.401,202.883 388.241,203.39 C390.434,204.702 392.685,205.703 394.955,206.496 C397.224,207.295 399.517,207.865 401.824,208.296 C404.131,208.734 406.434,209.041 408.748,209.266 C411.056,209.493 413.365,209.64 415.642,209.811 C417.917,209.99 420.176,210.19 422.379,210.47 C422.526,210.487 422.658,210.527 422.8,210.548 Z" fill="#1468b3" id="path2636_4_">
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="0.9" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0.5 0.5 1" keyTimes="0;0.556;0.556;1" type="translate" values="401.578,196.272;401.578,196.272;401.578,196.273;401.578,196.272"/>
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="0.9" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0.5 0.5 1" keyTimes="0;0.556;0.556;1" type="scale" values="1,1;1,1;1.716,1.716;1,1"/>
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="0.9" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0.5 0.5 1" keyTimes="0;0.556;0.556;1" type="translate" values="-401.578,-196.272;-401.578,-196.272;-401.578,-196.272;-401.578,-196.272"/>
   <animateColor attributeName="fill" begin="0.5" calcMode="spline" dur="5.8" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0 1 1" keyTimes="0;0.069;0.948;1" values="#1468b3;#1468b3;#1468b3;#ffffff"/>
   <animate attributeName="fill-opacity" begin="0.5" calcMode="spline" dur="5.8" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0 1 1" keyTimes="0;0.069;0.948;1" values="0;1;1;1"/>
   <animate attributeName="display" begin="0" calcMode="discrete" dur="0.5" fill="freeze" keyTimes="0;1" values="none;inherit"/>
  </path>
  <path d="M377.248,219.062 L377.248,223.583 C377.248,227.954 380.786,231.468 385.161,231.468 L414.91,231.468 C419.284,231.468 422.8,227.958 422.8,223.583 L422.8,214.569 C422.62,214.524 422.475,214.46 422.302,214.413 C419.514,213.642 416.606,212.923 413.708,212.325 C410.812,211.731 407.924,211.271 405.169,211.048 C403.79,210.935 402.445,210.876 401.145,210.892 C399.845,210.908 398.596,211.014 397.406,211.179 C394.317,211.609 391.654,212.207 389.313,212.934 C386.971,213.654 384.961,214.49 383.149,215.413 C381.338,216.335 379.739,217.338 378.238,218.362 C377.897,218.591 377.583,218.82 377.248,219.062 Z" fill="#1468b3" id="path2634_4_">
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="1.5" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0.5 0 1 0.5" keyTimes="0;0.733;0.733;1" type="translate" values="400.024,221.172;400.024,221.172;400.024,221.172;400.024,221.172"/>
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="1.5" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0.5 0 1 0.5" keyTimes="0;0.733;0.733;1" type="scale" values="1,1;1,1;1.36,1.36;1,1"/>
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="1.5" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0.5 0 1 0.5" keyTimes="0;0.733;0.733;1" type="translate" values="-400.024,-221.172;-400.024,-221.172;-400.024,-221.172;-400.024,-221.172"/>
   <animate attributeName="display" begin="0" calcMode="discrete" dur="1.1" fill="freeze" keyTimes="0;1" values="none;inherit"/>
   <animateColor attributeName="fill" begin="1.1" calcMode="spline" dur="4.6" fill="freeze" keySplines="0 0.5 0.5 1;0 0 1 1;0 0 1 1" keyTimes="0;0.087;0.935;1" values="#1468b3;#1468b3;#1468b3;#ffffff"/>
   <animate attributeName="fill-opacity" begin="1.1" calcMode="spline" dur="4.6" fill="freeze" keySplines="0 0.5 0.5 1;0 0 1 1;0 0 1 1" keyTimes="0;0.087;0.935;1" values="0;1;1;1"/>
  </path>
  <path d="M377.248,195.215 L377.248,215.719 C377.258,215.71 377.284,215.703 377.3,215.693 C378.157,215.069 378.915,214.438 379.541,213.784 C380.172,213.138 380.687,212.473 381.028,211.799 C381.476,210.931 381.795,210.078 382.021,209.267 C382.249,208.458 382.38,207.677 382.414,206.913 C382.45,206.154 382.405,205.438 382.285,204.719 C382.163,204.003 381.959,203.31 381.712,202.63 C381.219,201.273 380.513,199.963 379.7,198.711 C378.936,197.52 378.083,196.365 377.248,195.215 Z" fill="#1468b3" id="path2632_4_">
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="2.1" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0.5 0 1 0.5" keyTimes="0;0.81;0.81;1" type="translate" values="379.849,205.467;379.849,205.467;379.849,205.47;379.849,205.467"/>
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="2.1" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0.5 0 1 0.5" keyTimes="0;0.81;0.81;1" type="scale" values="1,1;1,1;2.633,2.633;1,1"/>
   <animateTransform additive="sum" attributeName="transform" begin="0" calcMode="spline" dur="2.1" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0.5 0 1 0.5" keyTimes="0;0.81;0.81;1" type="translate" values="-379.849,-205.467;-379.849,-205.467;-379.849,-205.467;-379.849,-205.467"/>
   <animate attributeName="display" begin="0" calcMode="discrete" dur="1.7" fill="freeze" keyTimes="0;1" values="none;inherit"/>
   <animateColor attributeName="fill" begin="1.7" calcMode="spline" dur="4.3" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0 1 1" keyTimes="0;0.093;0.93;1" values="#1468b3;#1468b3;#1468b3;#ffffff"/>
   <animate attributeName="fill-opacity" begin="1.7" calcMode="spline" dur="4.3" fill="freeze" keySplines="0 0 1 1;0 0 1 1;0 0 1 1" keyTimes="0;0.093;0.93;1" values="0;1;1;1"/>
  </path>
  <textArea fill="#000000" font-family="Arial" font-size="25.000000" font-style="normal" font-variant="normal" height="96.0000" text-align="center" transform="translate(16.0000, 336.0000)" width="768.0001" xml:id="textArea_1" xml:space="preserve">Fusion enabled</textArea>
</g>
</svg>
EOL;
    }
    static function index( ) {
        return "<?xml version='1.0'?>
<svg xmlns='http://www.w3.org/2000/svg'>
<animation xmlns:xlink='http://www.w3.org/1999/xlink' xlink:href='/fusion.svg' xml:id='media'/>
 <script>
 function scale() {
    document.getElementById('media').setAttribute('width', document.documentElement.viewport.width);
    document.getElementById('media').setAttribute('height', document.documentElement.viewport.height);
 };
 document.documentElement.addEventListener( 'resize', scale, false );
 scale();
</script>
</svg>";
    }
    public function rules() {
		$res = array(
            array ( "start", 'safe' ),
            array ( "active", 'safe' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
        $labels = array(
            'start'=>'Make Fusion my default start page',
			'active'=>'Enable Fusion',
            );
        return $labels;
	}
    
	function save() {
		if ( $this->_active!==null ) {
			if ( $this->_active ) {
				$this->activate();
			} else {
				$this->disabling();
			}
		}
		if ( $this->_start!==null && $this->getActive() ) {
			if ( $this->_start ){
				if ( !file_exists( $this->fusionstartup ) ){
					Yii::app()->user->tools->save_symlink( basename($this->fusionstartup).".tmpl", $this->fusionstartup );
					$this->needreload = true;
				}
			} elseif ( file_exists( $this->fusionstartup ) ){
				unlink( $this->fusionstartup );
				$this->needreload = true;
			}
		}
    }
	
    function getActive() {
        if ( $this->_active!==null )
            return $this->_active;
        return file_exists( $this->fusionconfig ) ;
    }
    function setActive( $active ) {
        $this->_active = $active;
    }
	function getStart( ) {
        if ( !$this->getActive() && $this->scenario!="backup" ) // make startup page by default
            return true; 
        return file_exists( $this->fusionstartup );
    }
    function setStart( $value ) {
        $this->_start = $value;
    }

    function setAdminPassword( $pass ) {
        
        $str = "admin:".md5($pass).":file,program,activate,layout,playlist,model,slide,edit,admin,locked::0";
        if ( !file_exists( $this->fusionpwd ) ) {
            if ( $pass )
                file_put_contents( $this->fusionpwd, $str ."\n" );
        } else {
            $old = file_get_contents( $this->fusionpwd ) ;
            $usrs = explode("\n", $old );
            for( $i=0; $i<count($usrs); $i++ ) {
                $data = explode( ":", $usrs[$i] );
                if ( $data[0]=="admin" ) {
                    if ( $pass )
                        $usrs[$i] = $str; 
                    else if ( strpos( $usrs[$i], ",locked" )!==false ) {
                        $usrs[$i] = str_replace( ",locked:", ":", $usrs[$i] ); // no longer locked in fusion
                    }                    
                }
            }
            file_put_contents( $this->fusionpwd, implode("\n", $usrs ) );
        }
    }
    protected function delTree($dir, $delroot=true) {
        if (substr($dir,-1,1)=='/') $dir = substr($dir,0,-1);
        $alldel=true;
        if (!file_exists($dir)) 
            return true;
        if ( !is_dir($dir) || is_link($dir) ) {
            if ( $dir=='/srv/raperca/content/index.svg' )
                return true;
            else
                return unlink($dir);
        }
        foreach (scandir($dir) as $item) {
            if ($item == '.' || $item == '..' ) 
                continue;
            if ( $item == '.svn' ) {
                $alldel=false;    
                continue;
            }
            if (!$this->delTree($dir . "/" . $item)) 
                $alldel=false;    
        }
        if ( $delroot && $alldel )
            return rmdir($dir);
        else 
            return $alldel; 
    } 
    
    function clear() {
        $this->delTree("/srv/raperca/content", false);
    }
    
    function activate() {
        if ( file_exists( $this->fusionconfig ) )
            return;
        // stop WebDAV on fusion area
        Yii::app()->user->tools->save_symlink( basename($this->fusionconfig).".tmpl", $this->fusionconfig );
        // remove all the content from the content part
        $this->clear();
		
        $pull = new PullModeConfig;
        $pull->load();
        $pull->save();
        
		$this->needreload = true;
        
        $f = "/srv/raperca/content/fusion.svg";
        file_put_contents( $f ,self::fusionfile() );
        chown( $f , "www" );
        chgrp ( $f , "www" );
        
        $f = "/srv/raperca/content/index.svg";
        file_put_contents( $f.".tmp", self::index() );
        chown( $f.".tmp", "www" );
        chgrp( $f.".tmp", "www" );
        rename( $f.".tmp", $f );
        
        $f = "/srv/raperca/content/publish/";
        mkdir( $f  );
        chown( $f , "www" );
        chgrp( $f , "www" );
        
        $f = "/srv/raperca/content/.fusion_enabled/";
        mkdir( $f  );
        chown( $f , "www" );
        chgrp( $f , "www" );
        
        // when enabling fusion, if an UBS drive with fusion backup exist, then it is copied imediatly
        $this->enableBackup( "/media/usb1/fusion-default.7z" );
        
    }
    
    function enableBackup( $src, $move=true ) {
    
        $f = "/srv/raperca/content/fusion-default.7z";
        if ( $this->getActive() && file_exists( $src ) ) {
            if ( $move ) 
                rename( $src, $f );
            else
                copy( $src, $f );
            
            chown( $f , "www" );
            chgrp( $f , "www" );
        }
        
    }
    
    function disabling() {
    
        if ( !file_exists( $this->fusionconfig ) )
            return;
            
        // remove all fusion content when disabling fusion
        $jobs = new MaintenanceJobs;
        $jobs->resetContent( );

        unlink( $this->fusionconfig );
        if ( file_exists( $this->fusionstartup ) )
            unlink( $this->fusionstartup );

        // remove users
        if ( file_exists($this->fusionpwd) )
            unlink( $this->fusionpwd );

        exec('sync'); // make sure data is commited before returning
        $this->needreload = true;

        $this->setStart( false );

        $pull = new PullModeConfig;
        $pull->setScenario('fusion');
        $pull->load();
        $pull->save();
               
    }
	function reloadConfig() {
        if ($this->needreload) {
            # Push everything to http server before reloading the server's config
            ob_flush();
            flush();
            # This must be at the very end, otherwise apache graceful restart
            # may still close the connection to the FastCGI server process running
            # this script.
            exec('/etc/init.d/apache reload < /dev/null > /dev/null 2> /dev/null &');
        }
            
    }
}
