<?php
class ProxyConfig extends CFormModel {
	
    static $proxyfile="/etc/network/spxproxy.conf";
    
    var $server="";
    var $port="";
    var $username="";
    var $password="";
    var $bypassLocalNetwork="true";
	var $bypassLocalNetworkBool=true;
    
   
    public function rules() {
		$res = array(
            array( "username, password, bypassLocalNetwork", 'safe' ),
            array( "server", 'checkDomain' ),
            array( "port", 'type', 'type'=>'integer' ),
            array( "password", 'hasUser' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'server'=>'Server',
            'port'=>'Port',
            'username'=>'Username',
            'password'=>'Password',
            'bypassLocalNetwork'=>'Bypass proxy server for local addresses',
		);
	}
	public function checkDomain( $attribute ){
        $value = $this->$attribute;
        if ( $value=="" )
            return true;
        $valid = preg_match("/^([a-z\d](-*[a-z\d])*)(\.([a-z\d](-*[a-z\d])*))*\.?$/i", $value) //valid chars check
            && preg_match("/^.{1,253}$/", $value) //overall length check
            && preg_match("/^[^\.]{1,63}(\.[^\.]{1,63})*\.?$/", $value); //length of each label
        
        if ( !$valid ) {
			$this->addError($attribute, "Server name is not valid");
            return false;
		}
        return true;
    }
    
    public function hasUser( $attribute ){
        
        if ( $this->username=="" && $this->password!="" )
            $this->addError('password', "Cannot set a password without username");
        
        return true;
    }
    
    function load() {
        if ( !file_exists( self::$proxyfile ) ) return false;
        
        $conf = file_get_contents( self::$proxyfile );
        $proxydoc = new DOMDocument;
        $proxydoc->loadXML( $conf );
        $proxy=$proxydoc->getElementsByTagName('proxy');
		if ($proxy->length>0){
            $proxy=$proxy->item(0);
            foreach ( $this->getSafeAttributeNames() as $name ) {
                $this->$name=$proxy->getAttribute( $name );
            }
        }
        if ($this->server!="" && $this->port=="")
            $this->port="8080";        
                
    }
    
    function save() {
        $changed = false;
        $proxydoc = new DOMDocument;
        if ( file_exists( self::$proxyfile ) ) {
            $conf = file_get_contents( self::$proxyfile );
            $proxydoc->loadXML( $conf );
        } 
        $proxyconf = $proxydoc->getElementsByTagName("proxyconf");
		if ($proxyconf->length==0){
			$proxyconf = $proxydoc->createElement("proxyconf");
			$proxydoc->appendChild($proxyconf);
		} else $proxyconf=$proxyconf->item(0);
        
        $proxy=$proxydoc->getElementsByTagName('proxy');
		if ($proxy->length>0)
			$proxy=$proxy->item(0);
        else
            unset($proxy);
            
        if ( $this->server!="" ) {
			if (!isset($proxy)){
				$proxy = $proxydoc->createElement("proxy");
				$proxyconf->appendChild($proxy);
			}
            foreach ( $this->getSafeAttributeNames() as $name ) {
                if ( $proxy->getAttribute( $name )!= $this->$name )
                    $changed = true;
                $proxy->setAttribute( $name, $this->$name);
            }
        } else if ( isset($proxy) ) {
			$proxyconf->removeChild($proxy);
            $changed = true;
		}
        if ( $changed ) {
            Yii::app()->user->tools->save_file(self::$proxyfile, $proxydoc->saveXML() );
            Yii::app()->user->tools->addReason( "proxy config change (" . ($this->server=="" ? "No Proxy" : $this->server) . ")" );
        }
        return $changed;
    }
}
