<?php

class SSLConfig extends CFormModel {
	
    static $sslfolder="/etc/ssl/certs/";
   
	var $uploadedfile;
	
	public function rules() {
		$res = array(
            array( 'uploadedfile', 'file', 'types'=>'pem,crt,cer', 'on'=>'upload' ),
            array( 'target', 'match', 'on'=>'delete', 'pattern'=>'/^[^\.]*.pem)$/' ),
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
			'target'=>'Protocols',
		);
	}
	function dec2hex($str)
    {
        $hex = array('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
        // Result value
        $hexval = '';
        // The quotient of each division operation
        $quotient = $str;
        $divisor = $str;
        // The ending condition
        $flag = true;
        while($flag)
        {
            $len = strlen($divisor);
            $pos = 1;
            $quotient = 0;
            // Take the first two digits as temp divisor and advance by 1 each iteration
            $div = substr($divisor, 0, 2);
            $remainder = $div[0];
            while($pos < $len)
            {
                // Calculate the next div
                $div = $remainder == 0 ? $divisor[$pos] : $remainder.$divisor[$pos];
                $remainder = $div % 16;
                $quotient = $quotient.floor($div/16);
                $pos++;
            }
            // Recast the divisor as string to make the $divisor[$pos] work
            $quotient = $this->trim_left_zeros($quotient);
            $divisor = "$quotient";
            $hexval = $hex[$remainder].$hexval;
            // If the divisor is smaller than 15 then end the iteration
            if (strlen($divisor)<=2)
            {
                if ($divisor<15)
                {
                    $flag = false;
                }
            }
        }
        $hexval = $hex[$quotient].$hexval;
        $hexval = $this->trim_left_zeros($hexval);
        
		// Pad zeros
        $hexval = str_repeat('0', 18-strlen($hexval)).$hexval;
        return $hexval;
    }
    // Trim the zeros at the left of a number
    function trim_left_zeros($str)
    {
        $str = ltrim($str, '0');
        if (empty($str))
        {
            $str = '0';
        }
        return $str;
    }  
    function certificateInfo( $file, $allInfo = true ){
        $f = array();
        if ( $allInfo ) {
            $cert = file_get_contents( self::$sslfolder . $file );
            $data = openssl_x509_parse( $cert );

            $f['country'] = $data['subject']['C'];
            $f['organization'] = $data['subject']['O'];
            $f['name'] = $data['subject']['CN'];

            $s = $this->dec2hex( $data['serialNumber'] );
            $f['serial'] = implode( ":", str_split($s,2) );
        }
        $f['filename'] = $file;
        return $f;
    }
	function getFileList( $allInfo=true ) {
		$filelist=array( );
		if ( !file_exists(self::$sslfolder ) )
            return $filelist;
		$filelist1=scandir(self::$sslfolder);
		
		foreach ($filelist1 as $file){
			if ($file=="." || $file==".." || substr($file, -4)!=".pem") continue;			
			$filelist[] = $this->certificateInfo( $file, $allInfo );
		}
		return $filelist;
	}
	function backupCertificate( $target ) {
		return file_get_contents( self::$sslfolder . $target );
	}
	function restoreCertificate( $cert ) {
	
		// Check that this is an X.509 certificate
		if ( !preg_match("/^-----BEGIN (X509 |TRUSTED |)CERTIFICATE-----/", $cert ) ) {
			$this->addError('uploadedfile', 'Only X509 certificates are supported');
			return;
		}
		$name =  uniqid("Cert_") .  ".pem";
		$dest = self::$sslfolder. $name;
		
		file_put_contents( $dest, $cert );
		
		$this->writeCertificate( $name, true );
	}
	function clearCertificates( ) {
		$list = $this->getFileList( false );
		foreach ($list as $file)
			$this->delete( $file['filename'] );
	}
	
	function saveCertificate( $file ) {

		// Check that this is an X.509 certificate
		$cert = file_get_contents( $file->tempName );
		
		// Check that this is an X.509 certificate
		if ( !preg_match("/^-----BEGIN (X509 |TRUSTED |)CERTIFICATE-----/", $cert ) ) {
			$this->addError('uploadedfile', 'Only X509 certificates are supported');
			return null;
		}
		
		// save the file
		$name =  uniqid("Cert_") .  ".pem";
		$dest = self::$sslfolder. $name;
		if ( !$file->saveAs( $dest ) ) {
            $this->addError('uploadedfile', 'Saving certificate failed');
			return null;
		}
		
		if ( !$this->writeCertificate( $name ) )
            return null;
		
        return $this->certificateInfo( $name );
	}
	
	function writeCertificate( $name, $ignoreDuplicates=false ) {
			
		$dest = self::$sslfolder. $name;
		
		// Recover the subject hash and certificate fingerprint 
		exec("openssl x509 -noout -hash -fingerprint -in $dest", $output, $ret);
		if ( $ret!=0 ) {
			// something wrong
			$this->addError('uploadedfile', 'Certificate not valid');
			unlink( $dest );
			return false;
		}
		
		$hash = $output[0];
		$md5 = $output[1];
		$i = 0;
		while ( file_exists( self::$sslfolder.$hash.".".$i ) ){
			exec("openssl x509 -noout -hash -fingerprint -in ".self::$sslfolder.$hash.".".$i, $output2, $ret);
			if ( $output2[1]==$md5 ){
				// this is the same certificate
				if ( !$ignoreDuplicates )
					$this->addError('uploadedfile', 'Certificate already uploaded');
				unlink( $dest );
				return false;
			} 
			$i++;
		}
		Yii::app()->user->tools->save_symlink( $name, self::$sslfolder.$hash.".".$i );
		
		/*
		Yii::app()->user->tools->addReason( "update certificates" );
		*/
		return true;
	}
	function delete( $target ) {
		
		if ( !preg_match('/^[^\.]*.pem$/', $target ) ){
			return false;
		}
		
		$file = self::$sslfolder . $target;
		if ( !file_exists( $file ) ){
			return false;
		}
		exec("openssl x509 -noout -hash -fingerprint -in $file", $output, $ret);
		
		
		$i = 0;
		$rename = false;
		$hash = $output[0];
		while ( file_exists( self::$sslfolder.$hash.".".$i ) ){
            if ( PHP_OS == "WINNT" ) {
  				unlink( self::$sslfolder.$hash.".".$i );
                unlink( self::$sslfolder.$hash.".".$i.".link" );
            } else if ( readlink( self::$sslfolder.$hash.".".$i) == $target ) {
				unlink( self::$sslfolder.$hash.".".$i );                
				$rename = true;
			} else if ( $rename ) {
				rename( self::$sslfolder.$hash.".".$i, self::$sslfolder.$hash.".".($i-1) );
			}
			$i++;
		}
		
		if ( !unlink( $file ) ) {
			return false;
		}
		
		return true;
    }
}
