<?php

require_once dirname(__FILE__).'/../utils/MainInfo.php';

class ScreenSettings extends CFormModel {
	
    protected $fileName="/etc/default/vidmode";
    protected $strings=array(   "RESOLUTION" => 'resolution',
                                "FORCE_VFREQ" => "vfreq",
                                "USE_FIXED_MODEDB" => "fixeddb",
                                "DEFAULT_MON_AR" => "screeenar", 
                                "FIXED_MODE_TYPES" => "type", 
                                "HDMI_UNDERSCAN_IGNORE" => "underscan", 
                                "VGA_DC_OFFSET" => "dcoffset",
                                "POWER_MODE_VGA" => "power",
                                "HDMI_LINK_FORCE_TYPE" => "hdmilink",
                                "CUSTOMMODE" => "custom",
                                "FORCE_AR" => "customforcear",
                                "CONFIGURATOR_VERSION" => "version");
                                
    
    public $presetsBonsai=array( 't0' => 'TV Screen',
                           'ed' => array("hdmi","720x480","60","16:9","480p","60Hz"),
                           'hd50' => array("hdmi","1280x720","50","16:9","720p","50Hz"),
                           'hd60' => array("hdmi","1280x720","60","16:9","720p","60Hz"),
                           't1' => 'Computer Monitor',
                           'vga' => array("vesa","VGA","60","4:3","VGA","640x480"),
                           'svga' => array("vesa","800x600","60","4:3","SVGA","800x600"),
                           'xga' => array("vesa","1024x768","60","4:3","XGA","1024x768"),
                           't2' => 'Wide Computer Monitor',
                           'wvga' => array("vesa,gtf","768x480","60","16:10","WVGA","768x480"),
                           'wsvga' => array("vesa,gtf","1024x640","60","16:10","WSVGA","1024x640")
                     );
    public $presetsSakura=array( 't0' => 'TV Screen',
                           'hd50' => array("hdmi","1280x720","50","16:9","720p","50Hz"),
                           'hd60' => array("hdmi","1280x720","60","16:9","720p","60Hz"),
                           
                           'fhd50' => array("hdmi","1920x1080","50","16:9","1080p","50Hz"),
                           'fhd60' => array("hdmi","1920x1080","60","16:9","1080p","60Hz"),
                           
                           't1' => 'Computer Monitor',
                           'vga' => array("vesa","VGA","60","4:3","VGA","640x480"),
                           'xga' => array("vesa","1024x768","60","4:3","XGA","1024x768"),
                           'sxga' => array("vesa","1400x1050","60","4:3","SXGA+","1400x1050"),
                           
                           't2' => 'Wide Computer Monitor',
                           'wxga' => array("vesa","1280x800","60","16:10","WXGA","1280x800"),
                           'wsxga' => array("vesa","1680x1050","60","16:10","WSXGA+","1680x1050")
                     );
     
	public $presetsBonsaiWizard=array(                            
						   'hd50' => array("hdmi","1280x720","50","16:9","720p 50Hz", 'Recommended settings for European and most Asian countries.'),
                           'hd60' => array("hdmi","1280x720","60","16:9","720p 60Hz", 'Recommended settings for U.S., Canada, Brazil and few other countries.'),
                     );
	public $presetsSakuraWizard=array( 
                           'hd50' => array("hdmi","1280x720","50","16:9","720p 50Hz", 'Settings for European and most Asian countries.'),
                           'hd60' => array("hdmi","1280x720","60","16:9","720p 60Hz", 'Settings for U.S., Canada, Brazil and few other countries.'),
                           'fhd50' => array("hdmi","1920x1080","50","16:9","1080p 50Hz", 'Full HD settings, recommended settings for European and most Asian countries.'),
                           'fhd60' => array("hdmi","1920x1080","60","16:9","1080p 60Hz", 'Full HD settings, recommended settings for U.S., Canada, Brazil and few other countries.'),                        
                     );
	
	public $builtinSettings=array();
	public $screenSettings=array();
	public $builtinSelect=array();
	public $screenSelect=array();
	

    public $default_mon_ar=array("4:3"=>"4:3","16:9"=>"16:9","16:10"=>"16:10");
    public $power_mode_vga=array("auto" => "Automatic","on"=>"Always On","off"=>"Always Off");
    public $hdmilink_type=array("auto" => "Automatic","HDMI"=>"HDMI","DVI"=>"DVI");
    
    // Variable that can be configured
    public $resolution=null;
    public $vfreq=null;
    
    public $fixeddb=null;
    public $screeenar=null;
    public $type=null;
    public $underscan=null;
    public $dcoffset=null;
    public $power=null;
    public $hdmilink = 'auto';
    public $custom=null;
    public $version=2;
    
    public $forcear=false;
    protected $customforcear="";
    
    public $simpledisplay=false;
	public $advancedtype=false;
	
	protected $probing = false;
    protected $error_custom_str = false;
    
    public function getPresets() {
        if ( Yii::app()->user->info->model=='Bonsai' ) 
            return $this->presetsBonsai;
        else
            return $this->presetsSakura;
    }
	public function getWizardPresets() {
        if ( Yii::app()->user->info->model=='Bonsai' ) 
            return $this->presetsBonsaiWizard;
        else
            return $this->presetsSakuraWizard;
    }
    public function rules() {
		return array(
            array('screeenar', 'in', 'on'=>'display,backup,simple', 'range'=>$this->default_mon_ar ),
            array('power', 'in', 'on'=>'power, display', 'range'=>array("","auto","on","off") ),
            array('hdmilink', 'in', 'on'=>'display,backup', 'range'=>array("auto","DVI","HDMI"), 'allowEmpty'=>false ),
            
            array('resolution', 'in', 'on'=>'backup', 'range'=>$this->supportedResolution()),
            array('vfreq', 'in', 'on'=>'backup', 'range'=>array("24","25","30","50","60") ),
            array('type', 'in', 'on'=>'backup', 'range'=>array("hdmi","vesa","gtf","vesa,gtf","hdmi,gtf","hdmi,vesa","") ),
            
            array('forcear, forcestdmode, underscansupp, dcoffsetsupp, advancedtype', 'safe', 'on'=>'display,backup' ),
            array('custom', 'checkCustomConfig', 'on'=>'display,backup' ),
            array('simpledisplay, forcear, dcoffsetsupp', 'safe', 'on'=>'simple' ),
		);
	}

    public function attributeLabels()
	{
		return array(
			'resolution'=>'Resolution',
            'vfreq'=>'Force vertical refresh',
            'forcestdmode'=>'Force standard video modes',
            'screeenar'=>'Force aspect ratio to',
            'type'=>'Restrict video mode to',
            'underscansupp'=>'HDMI display supports underscan',
            'dcoffsetsupp'=>'VGA display supports DC offset',
            'power'=>'VGA output enable',
            'hdmilink'=>'HDMI link type',
            'forcear'=>'Force aspect ratio to',
            'custom'=>'Custom video mode',
			'modeSelect'=>'Configuration type',
            'simpledisplay'=>'Display settings'
		);
	}
    public function supportedResolution() {
        $vidmod=file_get_contents("/etc/vid.modes");
        $vidmodArray=split("\n",$vidmod);
        $resolutionAdv = array();
        foreach ($vidmodArray as $str){
            if (preg_match("/=\s*(.*)/",$str,$match)){
                $values=split(" ",$match[1]);
                if (count($values)>=12){
                    if ($values[10]=='p' 
                        && in_array($values[2], array(24, 25, 30, 50, 60) ) 
                        && !in_array($values[0]."x".$values[1], $resolutionAdv)){
                        $resolutionAdv[ $values[0]."x".$values[1] ]=$values[0]."x".$values[1];	
                    }
                }	
            }
        }
        $resolutionAdv[ "VGA" ]= "VGA";	
        return $resolutionAdv;
    }
    
    public function getForceStdMode() {
        return $this->fixeddb=='yes';
    }
    public function getModeSelect ( ) {
        if ( $this->error_custom_str )
            return 2;
		if ( $this->simpledisplay==false || $this->probing ) {
			if ( $this->advancedtype )
				return 1;
			else
				return 2;
		} else {
			return 0;
		}
	}
    public function setForceStdMode( $forced ) {
        if ( $forced )
            $this->fixeddb='yes';
        else
            $this->fixeddb='';
    }
    
    public function getUnderscanSupp() {
        return $this->underscan=='no';
    }
    
    public function setUnderscanSupp( $forced ) {
        if ( $forced )
            $this->underscan='no';
        else
            $this->underscan='';
    }
    
    public function getDCOffsetSupp() {
        return $this->dcoffset!='no';
    }
    
    public function setDCOffsetSupp( $forced ) {
        if ( $forced )
            $this->dcoffset='yes';
        else
            $this->dcoffset='no';
    }
    
    public function checkCustomConfig( $attribute, $params ) {
         if ( preg_match('/[^-0-9a-zA-Z+ :.]/', $this->$attribute) ) {
            $this->addError($attribute,"String contains non-ASCII chars.");
            $this->error_custom_str = true;
            return;
         }
         if ( $this->$attribute!="" ) {
            $cnt = explode(" ", $this->$attribute);

            if ( count($cnt)<5 || ( count($cnt)<11 && $cnt[4]!='p' ) || ( count($cnt)>=11 && $cnt[10]!='p' ) ){
                $this->addError($attribute,"Only progressive modes supported.");
                $this->error_custom_str = true;
            }
         }
    }
	function dbstr2array( $str ) {
		$res = array();
		if (preg_match("/(\S*)\s*=\s*(.*\s+p)\s+(\S+)/",$str,$match)){
			$desc = $match[1];
			$values=split(" ",$match[2]);
			if ( count($values)>=11 ) {
				// only progresiye settings
				$res['hz'] = intval($values[2]);
				$res['resolution'] = $values[0]."x".$values[1];
				$res['width'] = intval($values[0]);
				$res['height'] = intval($values[1]);
				$res['ar'] = $match[3];
				$res['pcf'] =  $res['hz'] * ( $res['width'] + intval($values[3]) + intval($values[4]) + intval($values[7]) ) * ( $res['height'] + intval($values[5]) + intval($values[6]) + intval($values[7]) ) / 1000000;
				$res['settings'] = $match[2];				
				return $res;
			}
			return false;
		}
		return false;
	}
    function buildList() {
            
        $vidmod=file_get_contents("/etc/vid.modes");
        $builtIn=split("\n",$vidmod);
		
        $vidmod=file_get_contents(ScreenInfoBasics::sysfs_vout_device() . "vid_modedb");
		$screen=split("\n",$vidmod);
		
		
		//new stuff
		$this->builtinSettings=array();
		foreach ($builtIn as $str){
			$res = $this->dbstr2array( $str );
			if ( $res!==false && $res['hz']<=60 ) {
				$this->builtinSettings[ ] = $res;
				$this->builtinSelect[$res['settings']]=$res['resolution'].'@'.$res['hz'].'Hz';
			}
		}
		natsort( $this->builtinSelect );
		$this->screenSettings=array();
		foreach ($screen as $str){
			$res = $this->dbstr2array( $str );
			if ( $res!==false && $res['hz']<=60 ) {
				$this->screenSettings[ ] = $res;
				$v = $res['resolution'].'@'.$res['hz'].'Hz';
				//if ( !array_key_exists ( $res['settings'], $this->builtinSelect ) )
				$this->screenSelect[$res['settings']] = $res['resolution'].'@'.$res['hz'].'Hz';
			}
		}
		natsort( $this->screenSelect );
		
    }
    public function loadSetup( $file ) {
        
        if ( !file_exists( $file ) ) return false;
        $config=file_get_contents( $file );
        foreach ($this->strings as $name=>$var){
            if ($count = preg_match_all("/^\s*$name=(.*)/m",$config,$matches, PREG_SET_ORDER)){
                if ( $name=='CUSTOMMODE' ) 
                    $this->$var=substr($matches[$count-1][1],1,-1);
                else if ( $name=='HDMI_LINK_FORCE_TYPE' && $matches[$count-1][1]=="NONE" )
                    $this->$var= 'auto';
                else
                    $this->$var=$matches[$count-1][1];
                
            } else {
                if ( $name=='HDMI_LINK_FORCE_TYPE' )
                    $this->$var= 'auto';
                else
                    $this->$var="";
            }
            
        }
        if ( $this->customforcear!="" ) {
            if ( $this->custom!="" )
                $this->custom .= " ".$this->customforcear;
            $this->customforcear = "";
        }
        return true;
    }

	public function checkAdvanced( $load ) {
		
		$newtype = false;
		
        if ( $load && $this->custom=="" ) {
		    foreach ($this->builtinSettings as $idx => $val){
                if ( $this->resolution==$val['resolution'] && $this->vfreq==$val['hz'] ) {
                    // we got a buil-in settings 
                    $newtype = "builtin";
				    $this->forcear = ($this->screeenar != $val['ar'] );
                    $this->custom=$val['settings'];
                }
            }
        }
        if ( !$load ) {
            foreach ($this->builtinSettings as $idx => $val){
                if ( $this->custom==$val['settings'] && $this->advancedtype=="builtin" ) {
                    // we got a buil-in settings 
                    $newtype = "builtin";
				    $this->forcear = ($this->screeenar != $val['ar'] );
                    
                    $this->resolution=$val['resolution']; 
					$this->vfreq=$val['hz'];
					$this->fixeddb='yes';
					$this->type="";
                }
            }
		}
		if ( $newtype===false && ( $this->advancedtype===false || $this->advancedtype=="screen") && $this->custom!="") {
			foreach ($this->screenSettings as $idx => $val){
                if ( $this->custom==$val['settings']){
                    // we got a screen based settings 
                    $newtype = "screen";
                    $this->forcear = ($this->screeenar != $val['ar'] );
                }
            }
		}
		
		$this->advancedtype = $newtype;
	}
    public function checkPresets() {
        $this->simpledisplay = false;
		
		
        if ($this->fixeddb=='yes' && $this->custom=="" ){
            foreach ($this->presets as $id => $val){
                if ( $this->type==$val[0] && $this->resolution==$val[1] && $this->vfreq==$val[2]){
                    // we got a preset 
                    $this->simpledisplay = $id;
                    $this->forcear = ($this->screeenar != $val[3] );
                }
            }
        }
		$this->checkAdvanced( true );
		
	}
    public function load() {
        $this->loadSetup( $this->fileName );
		
		$this->buildList();
		
        // do we have a preset ?
        $this->checkPresets();
    }
    
    public function save() {
        $file = $this->createFile();
        if ( $file===false ) return false; // error
        if ( $file===true ) return true; // nothing to do
        
        $reboot = Yii::app()->user->tools->save_file($this->fileName, $file);
        
        if ( $reboot ) {
            Yii::app()->user->tools->addReason("display config change");
        }
        return true;
    }
    
    public function check() {
        if ( PHP_OS == "WINNT" ) {
            if ( strpos( $this->custom, "1280")!==false)
                return true;
        }
		$this->probing = true;
        $file = $this->createFile();
        if ( $file===false ) return false; // error
        if ( $file===true ) return true; // nothing to do
        
        Yii::app()->user->tools->save_file($this->fileName.".tmp", $file);
        $output=array();
        exec("/etc/init.d/vidmode probe ".$this->fileName.".tmp", $output);
        
        unlink($this->fileName.".tmp");
        
        $results = new ScreenInfo;
        if (count($output)>0 && trim($output[0])=="Probing video mode OK"){
            $sets=explode ("=",$output[1]);
            if ( count($sets)==2 )
                $vals=explode (" ",trim($sets[1]));
            else
                $vals=explode (" ",trim($sets[0]));
            if ( !is_numeric( $vals[3] ) )
                $arp = 5;
            else
                $arp = 11;
            if ($vals[$arp]=="0:0") $vals[$arp]="[auto]";
            if ($vals[$arp]=="x:x") $vals[$arp]="[unknown]";
            $results->resolution = htmlspecialchars($vals[0])."x".htmlspecialchars($vals[1]);
            $results->refresh = htmlspecialchars($vals[2]);
            $results->aspect = htmlspecialchars($vals[$arp]);
        } else {
            $this->addError('custom',"The selected settings do not result in a video mode supported by the player.");
            return false;
        }
        return $results;
        
    }
    
    public function createFile(  ) {
        
		$this->buildList();
        
        if ( $this->simpledisplay!==false && isset($this->presets[$this->simpledisplay]) ) {
            $this->fixeddb = 'yes';
            $this->underscan = '';
            
            $val = $this->presets[$this->simpledisplay];
            
            $this->type = $val[0];
            $this->resolution = $val[1];
            $this->vfreq = $val[2];
            $this->underscan = "no";
            if ( !$this->forcear || $this->screeenar===false ) {
                $this->screeenar = $val[3];
                $this->forcear = false;
            }
        } else {
			$this->checkAdvanced( false );
		}
        
        // load the config file
        if ( !file_exists( $this->fileName ) ) {
            $this->addError('file',"Failed reading the screen config file."." Please try again, reset the device to factory default or contact ".Yii::app()->user->branding->email);
            return false;
        }
        $config=file_get_contents( $this->fileName );
        $modified=false;
        
        if ( $this->custom===null )
            $this->custom = ""; // make sure that the custom mode are removed if they are not set to a specific value.
            
        foreach ($this->strings as $name => $var){
            
            $found=false;
            $val = $this->$var;
            if ( $name=='HDMI_LINK_FORCE_TYPE' && $val=="auto" )
                $val = 'NONE';
            if ( $val===null ) continue; // this has not beein modified, don;t touch
			if ($name=='CUSTOMMODE' && $this->advancedtype == "builtin" ) 
				$val = ""; // dont save teh custom mode when using built-in settings
            if ($name=='CUSTOMMODE' && $val!="" ){
		        $cnt = explode(" ", $val );
                if ( count($cnt)==5 || count($cnt)==11 )
                    $this->customforcear == "";
                if ( count($cnt)==6 ) {
                    $this->customforcear = $cnt[5];
                    $val = substr($val, 0, -strlen($this->customforcear)-1);
                }
                if ( count($cnt)==12 ){
                    $this->customforcear = $cnt[11];
                    $val = substr($val, 0, -strlen($this->customforcear)-1);
                }
                if ( $this->customforcear!="4:3" && $this->customforcear!="16:9" && $this->customforcear!="16:10" )
                    $this->customforcear = "";
                $val = escapeshellarg($val);
            }
            if ($count = preg_match_all("/^\s*$name=(.*)/m", $config, $matches, PREG_SET_ORDER)) {
                $previous=$matches[$count-1][1];
                $found=true;	
            } else if (preg_match("/^\s*#+\s*$name=/m",$config)) {
                $previous="";
                $found=true;	
            } else {
                $previous="";
            }
            
            if ( $previous!=$val ){
                if ($found) {
                    if ($val=="")
                        $config=preg_replace("/^\s*#*$name=.*/m","#$name=",$config);
                    else
                        $config=preg_replace("/^\s*#*$name=.*/m","$name=$val",$config);
                }else {
                    if ($val=="")
                        $config.="\n#$name=$val\n";
                    else
                        $config.="\n$name=$val\n";
                }
                $modified=true;
            }
        }
        if ( !$modified )
            return true;
        return $config;
        
    }
}
