<?php
class SerialConfig extends CFormModel {
	
    static $confpathsys="/usr/share/raperca/comportfsm/";
    static $confpathusr="/srv/raperca/comportfsm/";
    var $powersavefile="power_save.fsm";

    var $baudRateSet= array( 110, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 128000, 256000 );
    var $paritySet=array("none", "even", "odd");
    var $flowControlSet=array("none", "XonXoff", "RTS/CTS", "RS485");
    var $byteSizeSet=array("7", "8");
    var $stopBitsSet=array("0", "1");

    var $monPower=false;
    var $onTime="00:00";
    var $offTime="24:00";
    var $powerSave="true";
    var $href="";
    var $portNumber=1;

    var $enableSerial = null;
    var $baudRate=9600;
    var $byteSize=8;
    var $stopBits=1;
    var $parity="none";
    var $flowControl="none";
    
    var $uploadedfile;
	
	var $target="";
    
    var $modified = null;
 
    var $playerConf = null;
    public function init() {
        if ( Yii::app()->user->info->model=='Bonsai' ) 
            $this->portNumber=1;
        else
            $this->portNumber=2;
    }
    public function rules() {
		$res = array(
            array( "enablePowerSave, fixedMonPower", 'safe', 
                'on'=>'io, display, backup' ),
            array( 'onTime, offTime', 'checkTime', 
                'on'=>'io, display, backup' ),
            //array( 'href', 'match', 'on'=>'io, backup', 'pattern'=>'/\./', 'not'=>true ),
			//array( 'target', 'match', 'on'=>'dump,delete', 'pattern'=>'/\./', 'not'=>true ),
            array( 'href', 'match', 'pattern'=>'/^(\[disabled\])|([^\.]*.fsm)$/',
                'on'=>'io, backup'),
			array( 'target', 'match', 'pattern'=>'/^[^\.]*.fsm$/', 
                'on'=>'dump, delete' ),
            array( 'enableSerial', 'safe', 'on'=>'io, backup' ),
            array( 'baudRate', 'in', 'range'=>array( "110", "300", "600", 
                    "1200", "2400", "4800", "9600","14400", "19200", "38400", 
                    "57600", "115200", "128000", "256000" ), 
                'on'=>'io, backup' ),
            array( 'byteSize', 'in', 'range'=>array( 7, 8 ), 
                'on'=>'io, backup' ), 
            array( 'stopBits', 'numerical', 'min'=>0, 'max'=>1, 'integerOnly'=>true, 
                'on'=>'io, backup' ), 
            array( 'parity', 'in', 'range'=>array( "none", "even", "odd" ), 
                'on'=>'io, backup' ), 
            array( 'uploadedfile', 'file', 'types'=>'fsm', 
                'on'=>'upload' ),
            
    	);
        return $res;
	}
    public function attributeLabels()
	{
		return array(
            'enablePowerSave'=>'Enable display power saving',
            'fixedMonPower'=>'Use fixed schedule for display power',
            'onTime'=>'Turn monitor ON',
            'offTime'=>'Turn monitor OFF',
            'href'=>'Protocols',
			'target'=>'Protocols',
            'enableSerial'=>'Enable serial port',
            'baudRate'=>'Baud rate',
            'byteSize'=>'Data bits',
            'parity'=>'Parity',
            'stopBits'=>'Stop bits',
            
		);
	}
    
    public function checkTime( $attribute, $params  ) {
        if ( !preg_match('/^(([01]?[0-9]|2[0-3]):[0-5][0-9]|24:00)$/', $this->$attribute) ) {
            $this->addError( $attribute, "Time format is HH:MM (between 00:00 and 24:00)");
        }
    }
    
    function toList($in) {
        $name = $in.'Set';
        $ret = array();
        foreach ($this->$name as $val)
            $ret[$val]=$val;
        return $ret;
    }
    function getRealPath( $href ) {
		if ( substr( $href, 0, 3) == "sys" )
			return self::$confpathsys.substr( $href, 4);
		else if ( substr( $href, 0, 3) == "usr" )
			return self::$confpathusr.substr( $href, 4);
		else 
			return "";
	}
    function getBackupType(){
        if ( $this->href == "[disabled]" || $this->href == "" )
            return "disabled";
		if ( substr( $this->href, 0, 3) == "sys" )
			return "system";
        else 
            return "inline";
    }

    function getFileContent( $href="" ) {
		if ( $href=="" )
			$href = $this->href;
        if ( substr( $href, 0, 3) == "usr" )
            return file_get_contents( $this->getRealPath( $href ) ) ;
        return "";
    }
    
    function getBackupName(){
        if ( $this->href == "[disabled]" || $this->href == "" )
            return "[disabled]";
        
		return substr( $this->href, 4 );
    }
    
    function setBackup($type, $name="", $content=null ){
		if ( $type=='disabled' ) {
            if ( $this->href !== "[disabled]" ) {
                $this->href = "[disabled]";
                $this->modified = true;
            }
			return;
		}
		if ( $name=="" ){
			$this->addError('href', 'A name must be provided for the protocol.');
			return;
		}
        if ( $type=='system' ) {
            if ( $this->href !== "sys/" . $name ) {
                $this->href = "sys/" . $name;
                if ( !file_exists( $this->getRealPath( $this->href ) ) )
                    $this->addError('', 'System protocol do not exist.');
                 $this->modified = true;
            }
        }else if ( $content!=="" || $this->href !== "usr/" . $name) {
            $this->href = "usr/" . $name;
            if ( $content=="" ){
                if ( !file_exists( $this->getRealPath( $this->href ) ) )
                    $this->addError('', 'Protocol do not exist. Must provide the protocol file.');
            } else {           
                file_put_contents( $this->getRealPath( $this->href ) , $content);                
            }
            $this->modified = true;
        }        
    }
    function setEnablePowerSave( $val ) {
        if ( $val ) $this->powerSave="true";
        else $this->powerSave="false";
    }
    function getEnablePowerSave( ) {
        return ( $this->powerSave=="true" );
    }
    
    function setFixedMonPower( $val ) {
        if ( $val ) $this->monPower="true";
        else $this->monPower="false";
    }
    function getFixedMonPower( ) {
        return ( $this->monPower=="true" );
    }
    
    
    function setAttributes( $inputs, $safeOnly=true ) {

        if ( $this->modified===null) 
            $this->load();
        if ( isset( $inputs['href'] ) && $inputs['href']=="" )
            $inputs['href'] = "[disabled]";
            
		$values = $this->getSafeAttributeNames();
        
        foreach ($values as $str ){
			if ( isset( $inputs[$str] ) && (!isset($this->$str) || $inputs[$str]!=$this->$str) ){
				if ( isset($this->$str) )
					$this->modified=true;
				$this->$str = $inputs[$str];
			}
        }
		return $this->modified;
	}
	
	function load( ) {
        if ( $this->playerConf===null ) $this->playerConf = new PlayerConfig;
        if ( !$this->playerConf->loadConfig() ) return false;
        
        $domtree = $this->playerConf->domdoc;
        
		$ComPorts=$domtree->getElementsByTagName("serialPort");
		if ($ComPorts->length>0){
			$ComPorts=$ComPorts->item(0);
			
			if ($ComPorts->hasAttribute("enablePowerSave"))
				$this->powerSave=$ComPorts->getAttribute("enablePowerSave"); 
			if ($ComPorts->hasAttribute("href")) {
				$file = $ComPorts->getAttribute("href");
				if ( strpos( $file, self::$confpathsys )!==false ) {
					$this->href = "sys/" . substr( $file, strlen(self::$confpathsys) );
				} else {
					$this->href = "usr/" . substr( $file, strlen(self::$confpathusr) );
				}
			} else 
				$this->href = "";
			if ( $this->href == "" ) {
				$this->href = "[disabled]";
				$this->powerSave="false";
			}elseif ( $this->href == "sys/".$this->powersavefile ){
				$this->href="[disabled]";
				$this->powerSave="true";
			}
			
			if ($ComPorts->hasAttribute("onTime") && $ComPorts->hasAttribute("offTime")) {
				$this->onTime=$ComPorts->getAttribute("onTime");
				$this->offTime=$ComPorts->getAttribute("offTime");
			}
			if ( $this->onTime!="00:00" || $this->offTime!="24:00" ){
				$this->monPower="true";
			}
			
			$this->enableSerial = 1;
			if ($ComPorts->hasAttribute("portNumber")) $this->portNumber=$ComPorts->getAttribute("portNumber");
			
			if ($ComPorts->hasAttribute("baudRate")) { $this->baudRate=$ComPorts->getAttribute("baudRate"); }
			if ($ComPorts->hasAttribute("byteSize")) { $this->byteSize=$ComPorts->getAttribute("byteSize"); }
			if ($ComPorts->hasAttribute("stopBits")) { $this->stopBits=$ComPorts->getAttribute("stopBits"); }
			if ($ComPorts->hasAttribute("flowControl")) { $this->flowControl=$ComPorts->getAttribute("flowControl"); }
			if ($ComPorts->hasAttribute("parity")) { $this->parity=$ComPorts->getAttribute("parity"); }
			
			
		} else {
            
			$this->href = "[disabled]";
			$this->powerSave="false";
		}
        $this->modified = false;
	}
	
	function save( ) {
        
        if ( !$this->modified ) return false;
        
        if ( $this->playerConf===null ) $this->playerConf = new PlayerConfig;
        if ( !$this->playerConf->loadConfig() ) return false;
        $domtree = $this->playerConf->domdoc;
        
        $ComPorts=$domtree->getElementsByTagName("serialPort");
		
		if ( $this->href=="[disabled]")
			$this->href = "";
		if ( $this->enableSerial === null ){
            $this->enableSerial = 1;
        }
        $useSerial = true;
		$file = "";
        if (  $this->powerSave=="true" && $this->href=="" ){
			$file = self::$confpathsys.$this->powersavefile;            
		} elseif ( $this->href!="" ){
			if ( substr($this->href, 0, 3 ) == "sys" )
				$file = self::$confpathsys . substr( $this->href, 4);
			else
				$file = self::$confpathusr . substr( $this->href, 4);
		}

        $targetPort = null;
        if ($ComPorts->length>0){            
            foreach ( $ComPorts as $port ){
                if ( $port->getAttribute("portNumber") == $this->portNumber ){
                    $targetPort = $port;
                    break;
                }
            }
        }
        if ( $this->enableSerial ) {
            if ( !$targetPort ){
                $targetPort = $domtree->createElement("serialPort");	
                $player=$domtree->documentElement->getElementsByTagName("player");
                if ($player->length>0) {
                    $targetPort = $player->item(0)->appendChild( $targetPort );
                }else{
                    $targetPort = $domtree->documentElement->appendChild( $targetPort );
                    $this->addError( "href", "Warning no player tag found in the config, cannot add SerialPort tag.");
                }
            }
            if ( $file!="" ) {
                if ( $useSerial && PHP_OS!='WINNT' ) {
                    // check if the serial port is actually free to be used
                    $isSilent = shell_exec('fw_printenv -n silent');
                    if ( strcmp($isSilent, "yes\n") != 0) {
                        // Must disable the com port
                        $out = array();
                        exec('fw_setenv silent yes 2>&1', $out, $ret);
                        if ($ret !== 0) {
                            foreach ($out as &$val) {
                                $val = htmlspecialchars($val);
                            }
                            $this->addError( "href", "Warning failed to setup the RS232 interface ($ret): <br/>\n". implode("<br/>\n", $out) );
                        }
                    }
                }			

                $targetPort->setAttribute( "href", $file );
                if ( $this->monPower!==false ) {
                    if ( $this->monPower=="true" && ($this->onTime!="00:00" || $this->offTime!="24:00")){
                        $targetPort->setAttribute( "onTime", $this->onTime );
                        $targetPort->setAttribute( "offTime", $this->offTime );
                    } else {
                        $this->monPower="false";
                        $targetPort->removeAttribute("onTime");
                        $targetPort->removeAttribute("offTime");
                    }
                }
                $targetPort->setAttribute( "enablePowerSave", $this->powerSave );
            } else {
                $targetPort->removeAttribute( "href" );
                $targetPort->removeAttribute( "enablePowerSave" );
                $targetPort->removeAttribute( "onTime" );
                $targetPort->removeAttribute( "offTime" );
            }

            $targetPort->setAttribute("portNumber",$this->portNumber);
            $targetPort->setAttribute("baudRate",$this->baudRate);
            $targetPort->setAttribute("byteSize",$this->byteSize);
            $targetPort->setAttribute("stopBits",$this->stopBits);
            $targetPort->setAttribute("flowControl",$this->flowControl);
            $targetPort->setAttribute("parity",$this->parity);
        } else {
            $this->href = "";
            $this->powerSave = "false";
            if ( $targetPort ){
                $targetPort->parentNode->removeChild($targetPort); 
            }
        }
        if ( !$this->hasErrors() ) {

            $this->playerConf->saveConfig( true );
            if ( $this->getScenario()!='io' && $this->getScenario()!='delete' )
                Yii::app()->user->tools->addReason( "power save config change" );
            else
                Yii::app()->user->tools->addReason( "serial port config change" );
            return true;
        } else
            return false;
		
	}
	
	function getFileList( $showSystem=true, $realpath=false ) {
		$filelist=array( );
		if ( $showSystem ) {
			$filelist1=scandir(self::$confpathsys);
			$filelist['[disabled]'] = '[disabled]';
			foreach ($filelist1 as $file){
				if ($file=="." || $file==".." || $file==$this->powersavefile) continue;
                if ( $realpath )
                    $filelist["sys/".$file] = self::$confpathsys . $file;
                else
                    $filelist["sys/".$file] = "[sys] ".basename($file,".fsm");
			}
		}
	    $filelist2=scandir(self::$confpathusr);
	    foreach ($filelist2 as $file){
			if ($file!="." && $file!="..") {
                if ( $realpath )
                    $filelist["sys/".$file] = self::$confpathusr . $file;
                else
                    $filelist["usr/".$file] = substr($file,0,-4);
            }
	    }
		return $filelist;
	}
	
	function saveFsm( $file ) {
		
        if ( !$file->saveAs( self::$confpathusr. $file->name ) )
            $this->addError('uploadedfile', 'Saving the fsm file failed');
		
		if ( $this->href == "usr/". $file ) 
			Yii::app()->user->tools->addReason( "update of active fsm file" );

	}
	function dump() {
		header("Content-type: text/xml");
        header('Content-Disposition: attachment; filename=\'protocol.fsm\'; filename*=utf-8\'\''.rawurlencode(substr($this->target,4)).'\'');
		
		echo $this->getFileContent( $this->target  );
		
    }
	function delete() {
		if ( $this->href==$this->target) {
			// must reset the config
			$this->href = "[disabled]";
			$this->modified = true;
			$this->save( );
		}
		$file = $this->getRealPath( $this->target );
		if ( file_exists( $file ) )
			unlink( $file );
    }
    function deleteAll() {
		if ( $this->href!=="[disabled]" ) {
			// must reset the config
			$this->href = "[disabled]";
			$this->modified = true;
			$this->save( );
		}
        $list = $this->getFileList( false );
        foreach ( $list as $name => $username ) {
            $file = $this->getRealPath( $name );
            if ( file_exists( $file ) )
                unlink( $file );
        }
    }
    
}
