<?php

require_once dirname(__FILE__).'/../utils/MainInfo.php';

class SerialNumber extends CModel {
	
    protected $_serial=false;
    protected $_serialstring=false;
    protected $_devicename=false;
    
    protected $_model=false;
    protected $_hardware=false;
    
	public function attributeNames() {
        return array("serial", "serialstring");
    }
    public function safeAttributes() {
        return array();
    }
    
    public function getSerial() {
        if ( $this->_serial===false ) {
			getInfoSerial($this->_serial, $this->_model, $this->_hardware);
            if ( preg_match("/[0-9a-f]{12}/", $this->_serial) ){	
                $this->_serialstring =$this->_serial;
                $this->_devicename="#".htmlspecialchars($this->_serial);
            } else {
                // this is not an MAC
                $this->_serialstring =$this->_serial;
                $this->_devicename="";
            }
        }
        return $this->_serial;
    }
    public function getModel() {
        if ( $this->_model===false ) {
            $this->getSerial();
        }
        return $this->_model;
    }
    public function getHardware() {
        if ( $this->_hardware===false ) {
            $this->getSerial();
        }
        return $this->_hardware;
    }
    public function getSerialstring () {
        if ( $this->_serialstring===false ) $this->getSerial();
        return $this->_serialstring;
    }
    
    public function getDevicename () {
        if ( $this->_devicename===false ) $this->getSerial();
        return $this->_devicename;
    }
}