<?php

require_once 'protected/utils/MainInfo.php';

class Status extends CModel {
	
    protected $_safemode=null;
    protected $_installationmode=null;
    protected $_firmwareok=null;
    protected $_pendingChangeList=null;
	
	public function attributeNames() {
        return array("safemode", "installationmode", "firmwareok");
    }
    public function safeAttributes() {
        return array();
    }
    public function getSafemode () {
        if ( $this->_safemode===null ) {
            //check safe mode
            $this->_safemode=getInfoSafeMode();
        }
        return $this->_safemode;
    }
    public function clearInstalationMode() {
        if ( file_exists( "/var/run/reboot-delayed" ) )
            unlink("/var/run/reboot-delayed");
        if ( file_exists( "/var/run/reboot-pending" ) )
            unlink("/var/run/reboot-pending");
        $this->_installationmode = false;
    }
    
    public function getInstallationmode () {
        if ( $this->_installationmode===null ) {
             //check installation mode
            $this->_installationmode=file_exists("/var/run/reboot-delayed");
        }
        return $this->_installationmode;
    }
    public function addToPendingChangeList ( $str ) {
    
        $this->getPendingChangeList();
        $this->_pendingChangeList[] = $str;
        
        file_put_contents("/var/run/reboot-pending", implode("\n", $this->_pendingChangeList) );
    }
    
    public function getPendingChangeList () {
    
        if ( $this->_pendingChangeList===null ) {
            if (file_exists("/var/run/reboot-pending"))
                $pending = file_get_contents("/var/run/reboot-pending");
            else {
                $this->_pendingChangeList = array();
                return $this->_pendingChangeList;
            }
            $this->_pendingChangeList = explode("\n",$pending);
            
        }
        return $this->_pendingChangeList;
    }
    public function getFirmwareok () {
        if ( $this->_firmwareok===null ) {
            $this->_firmwareok = !getInfoFirmwareCorrupted();     
        }
        return $this->_firmwareok;
    }

}