<?php

include_once 'protected/utils/MaintenanceJobs.php';

// This class handle tools function to be derived by many classes 
class Tools extends CFormModel { 
    
    public $shutdownReason = "";
    public $messages = array();
    public $reboot = false;
    public $redirect = false;
    public $hasHeader = false;
    function save_file($name, $data, $secret=false, $group='raperca', $ignore_empty=true) {
    
        $ret = MaintenanceJobs::saveFile( $name, $data, $secret, $group, $ignore_empty);
        if ( $ret!==true && $ret!==false ) {
            $this->addError('file', $ret);
            return false;
        }
        return $ret;
    }
    
    static function get_my_host() {
        if ( isset($_SERVER['HTTP_HOST']) ) {
            $name = $_SERVER['HTTP_HOST'];
            if ( count (explode(":", $name ) ) >2 ) {
                // its ipv6
                if ( $name[0]!="[" )
                    $name = "[".$name."]";
            }
        } else {
            if ( isset($_SERVER['SERVER_NAME']) ){
                $name = $_SERVER['SERVER_NAME'];
            } else {
                $name = $_SERVER['SERVER_ADDR'];
            }
            if ( strpos($name, ":") ){
                $name = "[" . $name . "]";
            }
        }
        return $name;
    }
    # Converts a duration string formatted as an integer and
    # a unit suffix into an integer number of seconds, default
    # unit is seconds.
    function timestr_to_secs($s)
    {
         $s = trim($s);
         if (strcasecmp(substr($s, -5), 'hours') == 0) {
          $m = 3600;
          $o = 5;
         } elseif (strcasecmp(substr($s, -4), 'secs') == 0) {
          $m = 1;
          $o = 4;
         } elseif (strcasecmp(substr($s, -4), 'mins') == 0) {
          $m = 60;
          $o = 4;
         } elseif (strcasecmp(substr($s, -4), 'hour') == 0) {
          $m = 3600;
          $o = 4;
         } elseif (strcasecmp(substr($s, -3), 'sec') == 0) {
          $m = 1;
          $o = 3;
         } elseif (strcasecmp(substr($s, -3), 'min') == 0) {
          $m = 60;
          $o = 3;
         } elseif (strcasecmp(substr($s, -3), 'hrs') == 0) {
          $m = 3600;
          $o = 3;
         } elseif (strcasecmp(substr($s, -2), 'hr') == 0) {
          $m = 3600;
          $o = 2;
         } elseif (strcasecmp(substr($s, -1), 's') == 0) {
          $m = 1;
          $o = 1;
         } elseif (strcasecmp(substr($s, -1), 'm') == 0) {
          $m = 60;
          $o = 1;
         } elseif (strcasecmp(substr($s, -1), 'h') == 0) {
          $m = 3600;
          $o = 1;
         } else {
          $m = 1;
          $o = 0;
         }
         if ( $o!=0 )
            $s = substr($s,0,-$o);
         if ( is_numeric( $s ) )
            return intval(floatval($s) * $m);
         else return false;
    }
    
    # Converts a duration in seconds to a string as an integer
    # and a unit suffix, the unit is chosen so as to have the
    # smallest integer quantity
    function secs_to_timestr($v)
    {
         if ($v != 0 && $v % 3600 == 0) {
          return ($v / 3600) . 'h';
         } elseif ($v != 0 && $v % 60 == 0) {
          return ($v / 60) . 'm';
         } else {
          return $v . 's';
         }
    }

    function reconfig_player() {
        if ( PHP_OS!='WINNT' ) {
            $pid = trim(file_get_contents('/var/run/raperca.pid'));
        
            posix_kill($pid, SIGHUP);
        }
    }
    function restart_content() {
        touch( "/srv/raperca/content/index.svg" );
    }
    function reload_mdns() {
        if ( !isset($_ENV['OS']) || $_ENV['OS']!='Windows_NT' ) 
            exec('/etc/init.d/raperca-mdns reload');
    }
    function doShutdown() {
        return $this->shutdownReason!="";
    }
    function addReason( $str ) {
        if ( $this->shutdownReason!="" )
            $this->shutdownReason .= "; ";
        $this->shutdownReason .= $str;
    }
    
    function shutdown( $forcereboot=false, $recovery=false, $delay=false, $halt=false ) {
        if  ($this->reboot) return;
        if ( $this->shutdownReason == "" ) $this->shutdownReason="unknown reason";
        $msg = $this->shutdownReason;                
        $installationmode = Yii::app()->user->status->installationmode;
        if ($installationmode && !$forcereboot){

            Yii::app()->user->status->addToPendingChangeList( $msg );
            
            syslog(LOG_NOTICE, "configuration change in installation mode:" . $msg);
        } else {
            Yii::app()->user->status->clearInstalationMode();
            
            
            if ($installationmode)
                $msg = "installation mode shutdown" . ($msg ? (": " . $msg) : '');
            else
                $msg = "user initiated shutdown" . ($msg ? (": " . $msg) : '');
            
            if ( $halt ) {
                $this->reboot = 3;
            } else if ( $recovery ) {
                $this->reboot = 2;
            } else {
                $this->reboot = 1;
            }
            MaintenanceJobs::shutdown( $msg, $recovery, $delay,  $halt );
        }
    }
    
    function setSafeModeData($dstfile, $srcdata, $isfile = TRUE){
        return MaintenanceJobs::setSafeModeData( $dstfile, $srcdata, $isfile );
    } 
    
    function save_symlink($target, $link) {
        $ret = MaintenanceJobs::saveSymlink( $target, $link );
        if ( $ret!==true && $ret!==false ) {
            $this->addError('file', $ret);
            return false;
        }
        return $ret;
    }
    function recovery_version() {
	        
        $info = file_get_contents("/proc/mtd");
        
        foreach (explode("\n", $info) as $str ){
            if ( strpos($str, "failsafe-fs")===false ) continue;
            $max = strpos($str, ":");
            $mtd = substr($str, 0, $max);
            if (!file_exists("/dev/".$mtd."ro"))
				return "[dev]";
			$f = fopen("/dev/".$mtd."ro", 'r');
			
            if ($f===false) return "[ro]";
            $data = fread($f, 64);
            if ($data===false) return "[read]";
            
            if (ord(substr($data,0,1))!=0x27 || ord(substr($data,1,1))!=0x05 || ord(substr($data,2,1))!=0x19 || ord(substr($data,3,1))!=0x56 ) return "[magic]";
            $values = explode(" ", substr($data, 32));
            if (count($values)==0) return "[data]";
            return $values[count($values)-1];
        }
        return "[not found]";
    }
    
    function checkRecoverySate() {
        if ( Yii::app()->user->branding->product!="HMP100" ){
            return "bonjour";
        }        
        
        $version = $this->recovery_version();
        $ver = explode( ".", $version );
        if (count($ver)>=2 && (intval($ver[0])>1 || intval($ver[1])>=1) )   
            return "bonjour";
        else {
            $conf = file_get_contents("/etc/network/interfaces");
			$default=true;
			if (strpos($conf, "# Factory default")===false) 
                return "current";
            else 
                return "fixed";
        }
    }
    public function getBootID() {
        return MaintenanceJobs::bootID();
    }
}