<?php

class TouchCalibration extends CFormModel {
    
    public $xx = 1;
    public $xy = 0;
    public $yx = 0;
    public $yy = 1;
    public $tx = 0;
    public $ty = 0;
    
    private static $attrs = array("xx", "xy", "yx", "yy", "tx", "ty");
    
    var $_playerConf=null;
    var $calibon=null;
     
    public function rules() {
        return array(
            array('xx, xy, yx, yy, tx, ty', 'numerical', 'on'=>'config'),
            array('xx, xy, yx, yy, tx, ty', 'required', 'on'=>'config'),
        );
    }

    public function attributeLabels()
    {
        return array(
            'xx'=>'XX =',
            'xy'=>'XY =',
            'yx'=>'YX =',
            'yy'=>'YY =',
            'tx'=>'TX =',
            'ty'=>'TY =',
        );
    }

    function reset() {
        $this->xx = 1;
        $this->xy = 0;
        $this->yx = 0;
        $this->yy = 1;
        $this->tx = 0;
        $this->ty = 0;
    }
    function getPlayerConf(){
        if ( $this->_playerConf == null )
            $this->_playerConf = new PlayerConfig();
        return $this->_playerConf;
    }
    function setPlayerConf( $playerConf ) {
        $this->_playerConf = $playerConf;
    }

    function isIdentity() {
        return ($this->xx == 1 && $this->xy == 0 &&
                $this->yx == 0 && $this->yy == 1 &&
                $this->tx == 0 && $this->ty == 0);
    }
    function load( ) {
        if ( !$this->playerConf->loadConfig() ) return false;
        $domdoc = $this->playerConf->domdoc;
    
        $ts = $domdoc->getElementsByTagName("tscalibration");
        if ($ts->length >= 1) {
            $ts=$ts->item($ts->length-1); // we default to using the last one
            foreach ( self::$attrs as $a) {
                if ($ts->hasAttribute($a) && is_numeric($ts->getAttribute($a)))
                    $this->$a = $ts->getAttribute($a);
            }
        }
    }
    function isEventOn() {
        return $this->playerConf->events;
    }
    function isCalibrationOn() {
        if ( $this->calibon===null ) {
            if ( !$this->playerConf->loadConfig() ) return false;
            $domdoc = $this->playerConf->domdoc;            
            $tempAnim = $domdoc->getElementById("tscalibration_anim"); 
            if ( $tempAnim )
                $this->calibon = true;
            else
                $this->calibon = false;
        }
        return $this->calibon;
    }
    
    
    function startCalibration() {
        if ( !$this->playerConf->loadConfig() ) return false;
        $domdoc = $this->playerConf->domdoc;
        if ( $this->isCalibrationOn() ) return;
        $sources = $domdoc->getElementsByTagName("sources");
		if ($sources->length>0){
			$sources=$sources->item(0);
			$anim = $domdoc->createElementNs("http://www.w3.org/2000/svg", "animation");
			$anim->setAttribute("xml:id", "tscalibration_anim");
			$anim->setAttribute("priority", "10");
			$anim->setAttribute("type", "image/svg+xml");
			$anim->setAttribute("xlink:href", "/usr/share/raperca/www/calibration.svg");
			$sources->appendChild($anim);
		}
        $this->calibon = true;
        $this->reset();
        
        $this->save( false );
    }
    function stopCalibration( $save=true ) {
    
        if ( !$this->playerConf->loadConfig() ) return false;
        $domdoc = $this->playerConf->domdoc;
    
        $tempAnim = $domdoc->getElementById("tscalibration_anim"); 
        if ( $tempAnim ) {
            $tempAnim->parentNode->removeChild($tempAnim);
        }
    
        if ( $save )
            $this->playerConf->saveConfig( true );
            
        $this->calibon = false;
        return true;
    }
    
    function save( $stop=true ) {
        if ( !$this->playerConf->loadConfig() ) return false;
        $domdoc = $this->playerConf->domdoc;
        
        if ( $stop )
            $this->stopCalibration( false );
        
        $ts = $domdoc->getElementsByTagName("tscalibration");
        if ($ts->length >= 1) {
            $ts=$ts->item($ts->length-1); // we default to using the last one
        } else {
            $player = $domdoc->getElementsByTagName("player");
            if ($player->length!=1) {
                $this->addError('file',"Corrupted configuration file; touchscreen data not saved" );
                return false;
            }
            $player = $player->item(0);
            $ts = $domdoc->createElement("tscalibration");
            $player->appendChild($ts);
        }
        foreach (self::$attrs as $a) {
            $ts->setAttribute($a, $this->$a);
        }
        
        $this->playerConf->saveConfig( true );
    }
    
}

