<?php
class USBStorageInfo extends CModel {
	
	var $storage = array();
    var $useUSBAsStorage = null;
    
    var $mainStorage = null;
                                
    public function attributeLabels()
	{
		return array(
            'size'=>'Storage size',
            'useUSBAsStorage'=>'Local Storage set to',            
     	);
	}
    
    public function attributeNames() {
        return array("storage");
    }
    public function rules() {
		$res = array(
    	);
        return $res;
	}
    
    
    public function hasUSB() {
        return ( count($this->storage)>0 );
    } 
    
    public function getStorageStr() {
        if ( $this->useUSBAsStorage!==null )
            return 'USB storage';
        else 
            return Yii::app()->user->branding->product.' internal storage';
    }   
    
    public function load() {
        if ( isset($_ENV['OS']) && $_ENV['OS']=='Windows_NT' )
            $infoUSB = "/sys/block/sda/sda1:/dev/scsi/host2/bus0/target0/lun0/part1:15663055:15663104"; // to test
        else 
            $infoUSB = shell_exec( "/usr/lib/raperca/usb-storage" );
        $infoUSBlst=explode("\n",$infoUSB);

        $this->storage=array();
        foreach ($infoUSBlst as $info){
            $inf=explode(":",$info);
            if ($inf!=$info && count($inf)==4 && $inf[3]>0){
                $usbinf = new USBStorage;
                $usbinf->size = $inf[3];
                $usbinf->device_node = $inf[1];
                $usbinf->sysfs_device_path = $inf[0];
                $this->storage[]=$usbinf;
            }
        }

        if ( count($this->storage)>0 ){
            $mount=file_get_contents("/proc/mounts");
            $mounts=explode("\n",$mount);
            foreach ($mounts as $mount){
                $info=preg_split("/\s/",$mount);
                for ($i=0; $i<count($this->storage); $i++){
                    if ( $this->storage[$i]->device_node==$info[0] ){
                        if ($info[1]=='/srv/raperca/content') {
                            $this->useUSBAsStorage=$i;
                            $this->mainStorage = $this->storage[$i];
                        }
                        $this->storage[$i]->addMountLocation($info[1], $info[3]);
                    }
                }
            }
        }
    }
    
}
