<?php
/*

  Copyright (c) 2010, SpinetiX S.A.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above
      copyright notice, this list of conditions and the following
      disclaimer in the documentation and/or other materials provided
      with the distribution.

    * Neither the name of SpinetiX S.A. nor the names of its
      contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
  COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

*/

/**
 * Description of WebStorageAPI
 *
 * @author jr
 */
class WebStorageAPI {
    protected $socket_src = "unix:///var/run/raperca/rpc/socket";
    protected $timeout = 10;
    protected $socket = false;
    
    public function __construct() {
        $errno = 0;
        $errstr =  null;
        if( PHP_OS == "WINNT" ) // we will emule it
            return;
        
        $this->socket = fsockopen( $this->socket_src, 0, $errno, $errstr, $this->timeout );
        
        if ( $this->socket === false){
            trigger_error("webstorage: cannot open connection to the player. ( $errno:$errstr ) ", E_USER_WARNING);
            return;
        }
        /*
        stream_set_timeout($this->socket, floor($this->timeout), 
                floor( ($this->timeout-floor($this->timeout))*1000000 ) );
         * */
        stream_set_timeout($this->socket, $this->timeout );
        
    }
    protected $readBuffer = array();
    
    protected function emulReadAtoms( $num = 1 ) {
        if ( count( $this->readBuffer )<$num ) {
             $this->readBuffer = array();
             return false;
        }
        $result = array();
        while ( $num-->0 ) {
            $result[] = array_shift( $this->readBuffer );
        } 
        return $result;
    }
    protected function emulSetLocalVar( $name, $value ) {
        $s = @fsockopen( "localhost", 1234 ); 
        if ( $s ) {
            fwrite( $s, "UPDATE ".json_encode( $name )." ".json_encode( $value )."\r\n" ); 
            fclose( $s ); 
        }
    }
    protected function emulWriteAtoms( $atoms ) {
        $emul = "/tmp/webstorage.json";
        if (file_exists($emul))
            $vars = json_decode( file_get_contents( $emul), true );
        else 
            $vars = array();
        if ( count( $atoms ) > 1 )
            $name = $atoms[1];
        if ( count( $atoms ) > 2 )
            $value = $atoms[2];
        switch ($atoms[0]){
            case 'GET':
                if ( isset( $vars[$name] ) ){
                    $this->readBuffer = array( "FOUND", $vars[$name][0], $vars[$name][1] );
                } else {
                    $this->readBuffer = array( "NOT FOUND" );
                }
                break;
            case 'SET':
                if ( isset( $vars[$name] ) ){
                    $this->readBuffer = array( "MODIFIED", $vars[$name][0], $vars[$name][1] );
                } else {
                    $this->readBuffer = array( "CREATED" );
                }
                $vars[$name] = array( $value, time() );
                file_put_contents( $emul, json_encode( $vars ) );
                $this->emulSetLocalVar( $name, $value );
                break;
            case 'REMOVE':
                if ( isset( $vars[$name] ) ){
                    $this->readBuffer = array( "REMOVED", $vars[$name][0], $vars[$name][1] );
                    unset( $vars[$name] );
                    file_put_contents( $emul, json_encode( $vars ) );
                    $this->emulSetLocalVar( $name, "" );
                } else {
                    $this->readBuffer = array( "MISSING" );
                }
                
                break;
            case 'LIST':
                $this->readBuffer = array( "LISTED", count( $vars ) );
                foreach ( $vars as $name=>$val ){
                    $this->readBuffer[] = $name;
                }
                break;
            case 'CMPXCHG':
                if ( isset( $vars[$name] ) ){
                    if ( $vars[$name]==$value ) {
                        $this->readBuffer = array( "EXCHANGED", $vars[$name][0], $vars[$name][1] );
                        $vars[$name] = $atoms[3];
                        file_put_contents( $emul, json_encode( $vars ) );
                        $this->emulSetLocalVar( $name, $value );
                    } else {
                        $this->readBuffer = array( "DIFFERED", $vars[$name][0], $vars[$name][1] );
                    }
                } else {
                    $this->readBuffer = array( "CREATED" );
                    $vars[$name] = array( $atoms[3], time() );
                    file_put_contents( $emul, json_encode( $vars ) );
                }
                break;
            case 'CREATE':
                if ( isset( $vars[$name] ) ){
                    $this->readBuffer = array( "EXISTED", $vars[$name][0], $vars[$name][1] );
                } else {
                    $this->readBuffer = array( "CREATED" );
                    $vars[$name] = array( $value, time() );
                    file_put_contents( $emul, json_encode( $vars ) );
                    $this->emulSetLocalVar( $name, $value );
                }
                break;
        }
    }
    protected function readAtoms( $num = 1 ) {
        $ret = array();
        if( PHP_OS == "WINNT" )
            return $this->emulReadAtoms( $num );
        
        $val = "";
        while (!feof($this->socket)) {
            $buf = stream_get_line( $this->socket, 8192, "\0");
            
            $info = stream_get_meta_data( $this->socket );
            if ( $info['timed_out'] ){
                $this->close();
                trigger_error("webstorage: read connection to the player timed out", E_USER_WARNING);
                return false; // couln't get any of the wanted data
            }      
            
                  
            $val .= $buf;
            if ( strlen( $buf )==8192 )
                continue;
           
            $ret[] = $val;
            
            $val = "";
            if ( count( $ret) == $num ) 
                return $ret;            
        }
        $this->close();
        return false;
    }
    protected function writeAtoms( $atoms ) {
        if( PHP_OS == "WINNT" )
            return $this->emulWriteAtoms( $atoms );
        
        if ( $this->socket === false)
            return false;
         
        $str = implode("\0", $atoms ) ."\0";
        fwrite( $this->socket, $str);    
        
        $info = stream_get_meta_data( $this->socket );
        if ( $info['timed_out'] ){
            $this->close();
            trigger_error("webstorage: write connection to the player timed out", E_USER_WARNING);
            return false; // couln't get any of the wanted data
        }  
        fflush( $this->socket );
    }
    
    public function get( $name ) {
       
        if ( $this->writeAtoms( array( "GET", $name ) )===false )
            return false;
        
        $ret = $this->readAtoms( 1 );
        if ( $ret===false )
            return false;
        
        $res = array( 
                'name' => $name,
                'success' => true,
            );
        if ( $ret[0]=="FOUND" ) {
            $vals = $this->readAtoms( 2 );
            if ( $vals===false )
                return false;
            $res['value'] = $vals[0];
            $res['timestamp'] = substr($vals[1], 0, -3);            
        } else if ( $ret[0]=="NOT FOUND" ) {
            $res['success'] = false;
        } else {
            $this->close();
            return false;
        }
        return $res;
        
    }
    public function set( $name, $value, $offset="+0" ) {
        if ( $this->writeAtoms( array( "SET", $name, $value, $offset."000" ) )===false )
            return false;
        
        $ret = $this->readAtoms( 1 );
        if ( $ret===false )
            return false;
        
        $res = array( 
                'name' => $name,
                'success' => true,
                'created' => false,
            );
        if ( $ret[0]=="CREATED" ) {
            $res['created'] = true;           
        } else if ( $ret[0]=="MODIFIED" ) {
            $vals = $this->readAtoms( 2 );
            if ( $vals===false )
                return false;
            $res['prev_value'] = $vals[0];
            $res['prev_timestamp'] = substr($vals[1], 0, -3);            
        } else if ( $ret[0]=="NOT SET" ) {
            $res['success'] = false;
        } else {
            $this->close();
            return false;
        }
        return $res;
    }
    public function remove( $name ) {
       
        if ( $this->writeAtoms( array( "REMOVE", $name, "+0" ) )===false )
            return false;
        
        $ret = $this->readAtoms( 1 );
        if ( $ret===false )
            return false;
        
        $res = array( 
                'name' => $name,
                'success' => true,
            );
        if ( $ret[0]=="REMOVED" ) {
            $vals = $this->readAtoms( 2 );
            if ( $vals===false )
                return false;
            $res['prev_value'] = $vals[0];
            $res['prev_timestamp'] = substr($vals[1], 0, -3);            
        } else if ( $ret[0]=="MISSING" ) {
            $res['success'] = false;
        } else {
            $this->close();
            return false;
        }
        return $res;
        
    }
    public function getList( ) {
        if ( $this->writeAtoms( array( "LIST" ) )===false )
            return false;
        
        $ret = $this->readAtoms( 2 );
        if ( $ret===false )
            return false;
        
        if ( $ret[0]=="LISTED" ) {
            if ( !is_numeric($ret[1]) )
                return false;
            $num = intval($ret[1]);
            if ( $num==0 )
                return array();
            $res = $this->readAtoms( $num );
        } else {
            $this->close();
            return false;
        }
        return $res;
    }
    
    public function cmpxchg( $name, $expect, $value, $offset="+0" ) {
        if ( $this->writeAtoms( array( "CMPXCHG", $name, $expect, $value, $offset."000" ) )===false )
            return false;
        
        $ret = $this->readAtoms( 1 );
        if ( $ret===false )
            return false;
        
        $res = array( 
                'name' => $name,
                'success' => true
            );
        if ( $ret[0]=="CREATED" ) {
            $res['created'] = true;           
        } else if ( $ret[0]=="EXCHANGED" ){
            $vals = $this->readAtoms( 2 );
            if ( $vals===false )
                return false;
            $res['value'] =  $value;
            $res['prev_value'] = $vals[0];
            $res['prev_timestamp'] = substr($vals[1], 0, -3);            
        } else if ( $ret[0]=="DIFFERED" ) {
            $vals = $this->readAtoms( 2 );
            if ( $vals===false )
                return false;
            $res['success'] = false;
            $res['value'] = $vals[0];           
        } else if ( $ret[0]=="NOT SET" ) {
            $res['success'] = false;                
        } else {
            $this->close();
            return false;
        }
        return $res;
    }
    public function create( $name, $value, $offset="+0" ) {
        if ( $this->writeAtoms( array( "CREATE", $name, $value, $offset."000" ) )===false )
            return false;
        
        $ret = $this->readAtoms( 1 );
        if ( $ret===false )
            return false;
        
        $res = array( 
                'name' => $name,
            );
        if ( $ret[0]=="CREATED" ) {
            $res['success'] = true;            
            $res['value'] = $value;
        } else if ( $ret[0]=="EXISTED" ) {
            $vals = $this->readAtoms( 2 );
            if ( $vals===false )
                return false;
            $res['success'] = false;            
            $res['value'] = $vals[0];            
        } else {
            $this->close();
            return false;
        }
        return $res;
    }
    public function close() {
        if ( $this->socket !== false)
            fclose($this->socket);
    }
    
}
