<?php 

Yii::app()->getClientScript()->registerCoreScript('jquery');

$disabled = $fusion->active;

if ( $sources->message!="" )
    echo $sources->message;
    
echo CHtml::tag("h2", array(), $sources->getAttributeLabel( "title") )."\n";

echo CHtml::errorSummary( $sources )  ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();


echo $sources->getAttributeLabel( "desc");

echo CHtml::openTag("table" );

echo "<tr>\n";
$option1= array( 'size'=>40 );
$option2= array( 'size'=>40, 'disabled'=>'disabled', 'style'=>'display:none;' );
if ( $sources->primaryType=='local' ) $options = $option2;
else $options = $option1;
$opt = array('onchange'=>"enableServer(this, '".CHtml::activeId($sources, "primarySrc")."')");
if ( $disabled ) $opt['disabled']='disabled';
echo CHtml::tag( "td", array(), CHtml::activeLabel($sources, "primarySrc") );
echo CHtml::tag( "td", array(), CHtml::activeDropDownList(  $sources, 
                                                            "primaryType", 
                                                            $sources->sourceTypeList, 
                                                            $opt ) );
echo CHtml::tag( "td", array(), CHtml::activeTextField($sources, "primarySrc", $options ) );
echo "</tr>\n";


echo "<tr>\n";
if ( $sources->secondaryType=='local' ) $options = $option2;
else $options = $option1;
$opt = array('onchange'=>"enableServer(this, '".CHtml::activeId($sources, "secondarySrc")."')");
if ( $disabled ) $opt['disabled']='disabled';

echo CHtml::tag( "td", array(), CHtml::activeLabel($sources, "secondarySrc") );
echo CHtml::tag( "td", array(), CHtml::activeDropDownList(  $sources, 
                                                            "secondaryType", 
                                                            $sources->sourceTypeList, 
                                                            $opt ) );
echo CHtml::tag( "td", array(), CHtml::activeTextField($sources, "secondarySrc", $options ) );
echo "</tr>\n";


echo CHtml::closeTag("table" )."\n";

if ( $disabled ){
	echo CHtml::tag( "p", array( ), "Warning: media sources cannot be modified when Fusion is enabled"); 
}


echo CHtml::openTag("div", array( 'class'=>'space') );
echo CHtml::activeLabel($info, "useUSBAsStorage")." : ";
if ( $info->useUSBAsStorage!==null ) {
    echo CHtml::textField("storage", $info->getStorageStr() , array( 'size'=>15, 'disabled'=>'disabled' ) )." ";
    echo CHtml::submitButton("Clear ".Yii::app()->user->branding->product." internal storage", array('name'=>'clear') );
    if ( $info->mainStorage && $info->mainStorage->writable ) {
        echo CHtml::tag("br");
        echo CHtml::activeHiddenField($info->mainStorage, "sysfs_device_path" );
        echo CHtml::hiddenField("action", "copy" );
        echo CHtml::tag("div", array( 'class'=>'action', "style" => "padding-left: 244px;"),
                        CHtml::button("Copy ".Yii::app()->user->branding->product." internal storage to USB", 
                                        array('class'=>'copy_now') ) .
                        CHtml::image("images/loadingAnimation.gif", "Copying..." , array( 'class'=>'copying' ))
        );
    }
} else {
    echo CHtml::textField("storage", $info->getStorageStr() , array( 'size'=>25, 'disabled'=>'disabled' ) );
}
echo CHtml::closeTag("div")."\n";

echo CHtml::openTag("div", array( 'class'=>'space') );
echo CHtml::activeCheckBox($sources, "useUSB", array())." ";
echo CHtml::activeLabel($sources, "useUSB");
echo CHtml::closeTag("div")."\n";

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'sources') );
echo CHtml::closeTag("div")."\n";



echo CHtml::endForm();
echo CHtml::closeTag("div")."\n";

?>

<script type="text/javascript">//<![CDATA[

function enableServer( el, id )
{

	var text=document.getElementById( id  );
	
	if (el.selectedIndex==0){ // local
        text.disabled=true;
        text.style.display="none"; 
	}else{
        text.disabled=false;
        text.style.display=""; 
	}
}
//]]></script>

<?php

echo CHtml::tag("h2", array(), "Detected USB Storage devices") ."\n";

echo CHtml::errorSummary( $info )  ."\n";

$panels = array();

$devnr=0;
foreach ($info->storage as $inf) {
    $devnr++;  
    ob_start();

    echo CHtml::errorSummary( $inf )  ."\n";
    
    echo $inf->message;
    
    echo CHtml::openTag("div", array("class"=>"yiiForm") );
    echo CHtml::form(  );

    echo CHtml::hiddenField("index", $devnr-1 );
    echo "<table>\n";
    echo "<tr><td>".$inf->getAttributeLabel( "size")." : </td><td>".$inf->getSizeMBytes()." Mbytes</td></tr>";
    if ( !$inf->isUsed() )
        echo "<tr><td>Not currently in use</td></tr>\n";
    else {
        //echo "<tr><td>".$inf->getAttributeLabel( "usedFor")." : </td><td>".$inf->usedFor."</td></tr>";
        if ( $inf->isUserAvailable())
            echo "<tr><td>".$inf->getAttributeLabel( "writable")." : </td><td>".$inf->getWritableStr()."</td></tr>";
    }
    echo "</table>\n";
    
    if ( $inf->isUsed() ) {
        echo CHtml::openTag("div", array( 'class'=>'action') );
        echo CHtml::activeHiddenField($inf, "device_node" );
        if ( $inf->forceUnmount ) {
            echo CHtml::activeHiddenField($inf, "forceUnmount" );
            echo CHtml::submitButton("Disconnect anyway", array('name'=>'unmount') );
        }else
            echo CHtml::submitButton("Disconnect", array('name'=>'unmount') );
        echo CHtml::closeTag("div")."\n";
    } else if ( !$fusion->active || $inf->isFusionContent() ){
        echo CHtml::hiddenField("action", "publish" );
        echo CHtml::tag("div", array( 'class'=>'action'), 
                    CHtml::button("Publish USB content to ".Yii::app()->user->branding->product, 
                                    array('class'=>'publish_now') ) .
                    CHtml::image("images/loadingAnimation.gif", 
                                    "Publishing..." , array( 'class'=>'publishing' ))
            );
        
    }
    if ( !$inf->writable && $inf->isUserAvailable() )
        echo CHtml::tag("div", array( 'class'=>'space'), "USB storage is connected as read-only.")."\n";
        
    echo CHtml::tag("div", array( 'class'=>'space'), "USB storage must be specially formatted to use it as writable local storage, otherwise it is used as read-only.");
    echo CHtml::tag("div", array( 'class'=>'space'), "Warning: formating a USB storage device erases all content on it.")."\n";

    echo CHtml::openTag("div", array( 'class'=>'action') );
    echo CHtml::activeHiddenField($inf, "sysfs_device_path" );
    echo CHtml::activeHiddenField($inf, "formatID", array('class'=>'format_id') );
    echo CHtml::activeHiddenField($inf, "formatPID", array('class'=>'format_pid') );
        
    echo CHtml::activeHiddenField($inf, "forceFormat", array('class'=>'force') );
    echo CHtml::hiddenField("format", $devnr );
    echo CHtml::button("Format Now", array('name'=>'format', 'class'=>'format_now') );

    echo CHtml::closeTag("div")."\n";

	echo CHtml::tag("h3", array( 'class'=>'formats'), "Status:" );
    echo CHtml::image("images/loadingAnimation.gif", "Loading..." , array( 'class'=>'loading' ));
    
    echo CHtml::tag("div", array( 'class'=>'results'), " " );
    
	echo CHtml::tag("h3", array( 'class'=>'formats'), "Log:" );
	echo CHtml::tag("div", array( 'class'=>'logs'), " " );
	
    
	echo CHtml::endForm();
    echo CHtml::closeTag("div")."\n";    
    $panels["Device # $devnr"] = ob_get_clean();    
}
$this->widget('zii.widgets.jui.CJuiAccordion',array(
    'panels' => $panels,
    'theme'=>'cupertino',
    'options' => array(
        'collapsible' => true,
        'heightStyle' => 'content'
    )
));


echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

echo CHtml::tag("div", array( 'class'=>'space'), "Note: it may take some time for a USB storage device to be fully recognized, reload this page if you think the information below is not accurate.")."\n";

if ( !$info->hasUSB() )
    echo CHtml::tag("div", array( 'class'=>'space'), "No USB storage devices (e.g., USB stick) currently attached"),"\n";

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Reload", array('name'=>'reload') );
echo CHtml::closeTag("div")."\n";

echo CHtml::endForm();
echo CHtml::closeTag("div")."\n";

$format_dst = CHtml::normalizeUrl( array("/admin/format") );
$publish_dst = CHtml::normalizeUrl( array("/admin/publish") );
?>
<script type="text/javascript">//<![CDATA[
    
    var publish = function( buttonClass, progressClass ) {
        var self = this;
        $( progressClass ).hide();
        self.refresh = function( data ) {            
            if ( data.state === "queued" || data.state === "partial" ){
                setTimeout( self.update, 5000 );
            } else {
                self.button.disabled = false ;
                $( progressClass, self.parent ).hide();
            }
        };
        self.update = function( ) {
            jQuery.ajax({  
                type    : 'POST',
                data    : { action : 'status', id: self.id },
                url     : "<?php echo $publish_dst; ?>",
                cache   : false,
                dataType:'json',
                success : self.refresh
            });
        };
        
        $(buttonClass).click( function( ) {
            self.button = this;
            self.button.disabled = true ;
            self.parent = $(this).parent();
            var p = self.parent;
            while ( p[0].nodeName!=='form' && p[0].nodeName!=='FORM')
                p = p.parent();
            var data = p.serialize();
            $(progressClass, self.parent ).show();
            jQuery.ajax({  
                'type' : 'POST',
                'data' : data,
                'url'  : "<?php echo $publish_dst; ?>",
                'cache':false,
                'dataType':'json',
                'success': function( json ){
                    self.id = json.id;
                    self.update();
                }
            });
        });
    };
  
    var fromUSB = new publish( '.publish_now', '.publishing' );
    var toUSB = new publish( '.copy_now', '.copying' );
    
    $(".formats").hide();
    $(".loading").hide();
    
	var button;
	var logs;
	var results;
	var id;
	var pid;
	var force;
	var form;
    var loading;
	
	function update ( json ) {
		logs.html( json.logs );
        results.html( json.results );
		if ( !json.finished ) {
           time = setTimeout("refresh_log()",10000);
		} else{
            loading.hide();
			if ( json.forceFormat ) {
				button.show();
				force.val("1");
				button.val("Format Anyways");
			}
		}
	}
	
	$('.format_now').click( function( ) {
		button = $(this);
		form = $(this).parent().parent();
		logs = $(".logs",form);
		results = $(".results",form);
		id = $(".format_id",$(this).parent());
		pid = $(".format_pid",$(this).parent());
		force = $(".force",$(this).parent());
       loading = $(".loading",form);
		$(".formats",form).show();
		
		button.hide();
		loading.show();
        
		jQuery.ajax({  
			'type':'POST',
			'data':form.serialize(),
			'url':"<?php echo $format_dst; ?>",
			'cache':false,
			'dataType':'json',
			'success': function( json ){
				id.val(json.id);
				pid.val(json.pid);
				
				update ( json );
				
			}
		});
	} );
		
	function refresh_log() {
        jQuery.ajax({  
		   'type':'POST',
		   'data':form.serialize(),
		   'url':"<?php echo $format_dst; ?>",
		   'cache':false,
		   'dataType':'json',
		   'success':function(json){ update ( json ); } 
        });
    }

//]]></script>