<?php 



echo CHtml::tag("h2", array(), "Interactivity Settings") ."\n";

echo CHtml::errorSummary( array($config) )  ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

echo CHtml::openTag("div", array("class"=>"space") );
echo CHtml::activeLabel($config, "latency");
echo CHtml::activeDropDownList($config, "latency", $config->latencies);
echo CHtml::closeTag("div" );

echo CHtml::openTag("div", array("class"=>"space") );
echo CHtml::activeCheckBox($config, "events", array( 
    'onclick' => 'enableEvents()',
    'id' => 'EnableEventId'
));
echo CHtml::activeLabel($config, "events");
echo CHtml::closeTag("div" );



echo CHtml::openTag("div", array("class"=>"space") );
echo CHtml::activeCheckBox($config, "interlatency", array(
    'id' => 'ReduceLatencyId'
));
echo CHtml::activeLabel($config, "interlatency");
echo CHtml::closeTag("div" );

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'interactivity') );
echo CHtml::closeTag("div" );

echo CHtml::endForm();
echo CHtml::closeTag("div" );



echo CHtml::tag("h2", array(), "Touchscreen Calibration") ."\n";

echo CHtml::errorSummary( $calib )  ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();

$options = array();
$options['size']='6';
if ( !$config->events ) {
    $options['disabled']='disabled';
    echo "Events must be enabled (above) to use touchscreens.<br/>";
}
echo "<table>\n";
echo "<tr>\n";
echo "<td>".CHtml::activeLabel($calib, "xx").CHtml::activeTextField($calib, "xx", $options )."</td>\n";
echo "<td>".CHtml::activeLabel($calib, "xy").CHtml::activeTextField($calib, "xy", $options )."</td>\n";
echo "<td>".CHtml::activeLabel($calib, "tx").CHtml::activeTextField($calib, "tx", $options )."</td>\n";
echo "</tr><tr>\n";
echo "<td>".CHtml::activeLabel($calib, "yx").CHtml::activeTextField($calib, "yx", $options )."</td>\n";
echo "<td>".CHtml::activeLabel($calib, "yy").CHtml::activeTextField($calib, "yy", $options )."</td>\n";
echo "<td>".CHtml::activeLabel($calib, "ty").CHtml::activeTextField($calib, "ty", $options )."</td>\n";
echo "</tr>\n";
echo "</table>\n";

echo CHtml::openTag("div", array( 'class'=>'action') );
$options['name']='calibration';
echo CHtml::submitButton("Apply", $options )." ";
$options['name']='reset';
echo CHtml::submitButton("Reset to default", $options );
echo CHtml::closeTag("div" );



echo CHtml::openTag("div", array( 'class'=>'action space') );

if ( $calib->isCalibrationOn() ){
    echo "<h2 class='red'>"."Touchscreen Calibration in process"."</h2>";
    echo "<p>"."Please follow the instruction on the screen attached to the ".Yii::app()->user->branding->product." or press the 'Stop calibration procedure' button."."</p>";
    echo CHtml::submitButton("Stop calibration procedure", array('name'=>'stopcal') );
} else {
    $options['name']='startcal';
    echo CHtml::submitButton("Start calibration procedure", $options );
}
echo CHtml::closeTag("div" );

echo CHtml::endForm();
echo CHtml::closeTag("div" );


?>
<script type="text/javascript">//<![CDATA[

function enableEvents()
{
	var events=document.getElementById("EnableEventId");
	document.getElementById("ReduceLatencyId").disabled = !events.checked;    
};
enableEvents();

//]]></script>
