<?php 

echo CHtml::tag("h2", array(), "Current Versions") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") );

echo CHtml::openTag("table" );
echo CHtml::tag("tr", array(), CHtml::tag("td", array(), $firmware->getAttributeLabel("firmwareVersion") . " : " ) .
                                CHtml::tag("td", array(), CHtml::encode($firmware->firmwareVersion) ).
                                CHtml::tag("td", array(), " ( " . $firmware->getAttributeLabel("firmwareBuild") ." ". CHtml::encode($firmware->firmwareBuild) ." ) " )
                                
                );            
echo CHtml::tag("tr", array(), CHtml::tag("td", array(), $firmware->getAttributeLabel("updaterVersion") . " : " ) .
                                CHtml::tag("td", array(), CHtml::encode($firmware->updaterVersion) ).
                                CHtml::tag("td", array(), " ( " . $firmware->getAttributeLabel("updaterBuild") ." ". CHtml::encode($firmware->updaterBuild) ." ) " )
                                
                );            
if ( $firmware->spxjslibsVersion!==false ) {                 
    echo CHtml::tag("tr", array(), CHtml::tag("td", array(), $firmware->getAttributeLabel("spxjslibsVersion") . " : " ) .
                                    CHtml::tag("td", array(), CHtml::encode($firmware->spxjslibsVersion) ).
                                    CHtml::tag("td", array(), " ( " . $firmware->getAttributeLabel("spxjslibsBuild") ." ". CHtml::encode($firmware->spxjslibsBuild) ." ) " )
                                    
                    );
}
echo CHtml::closeTag("table" );

echo CHtml::tag("div", array(), "Information about new firmware releases is available at<br/>" .
                                Yii::app()->user->branding->linkfirmware );
echo CHtml::closeTag("div" );

if ( $firmware->isUpdateRunning() ) {
    
    echo CHtml::errorSummary( $firmware )  ."\n";
    
    echo CHtml::openTag("div", array("class"=>"yiiForm") );
    echo CHtml::form();
    
    echo CHtml::openTag("div", array("id"=>"log_content") )."\n";
    
    $this->renderPartial("firmware/log_content", array( 'firmware'=>$firmware ) );
    
    echo CHtml::closeTag("div" )."\n";
    
    echo CHtml::openTag("div", array("id"=>"log_content_fail") )."\n";
        echo CHtml::tag("h3", array(), "Update failed");    
        echo "Please check the update log for more details.<br/>\n";
         
        echo CHtml::openTag("div", array( 'class'=>'action space') );
        echo CHtml::submitButton("Cancel", array('name'=>'cancel') ) ." ";
        echo CHtml::closeTag("div" );
    echo CHtml::closeTag("div" )."\n";
            
    echo CHtml::endForm();
    echo CHtml::closeTag("div" )."\n";
    
    echo CHtml::form( "", "Post", array('id'=>'refresh_log') );
    echo CHtml::activeHiddenField($firmware, "log_id" );
    echo CHtml::activeHiddenField($firmware, "mode" );
    echo CHtml::activeHiddenField($firmware, "updatesource" );
	// echo CHtml::hiddenField( "jason", true );
            
    //echo CHtml::ajaxSubmitButton( "Refresh", array( 'style'=>'display:none;' ), array( 'update'=>"#log_content" ) );

    echo CHtml::endForm();
	
	$url_alive = CHtml::normalizeUrl( "/boot-id" );
	$bootID = MaintenanceJobs::bootID();

?>
<script type="text/javascript">//<![CDATA[

    function CheckAlive( ) {
        $.ajax({
            url: '<?php echo $url_alive; ?>',
            dataType: 'text',
            success: function( data, status ) {
                if ( $.trim(data)!="" && $.trim(data)!="<?php echo $bootID; ?>" ) {
                    $("#WaitingForBoot").hide();
					$("#NextStep").show();
                } else {
                    setTimeout( CheckAlive ,10000); 
                }
            },
            error: function() {
                // device is not responding yet, should try again in a few seconds
                setTimeout( CheckAlive ,10000); 
            }
        });
    }
	
    var time;
    var log_visible=false;
    function refresh_log() {
        var loc = location.href;
        if ( loc.substr( loc.length-1 )=="#" )
            loc = loc.substr( 0, loc.length-1 );
        jQuery.ajax({   'type':'GET',
                       'data':jQuery("#refresh_log").serialize(),
                       'url': loc,
                       'cache':false,
                       'timeout': 30000,
                       'success':function(html){
                                        jQuery("#log_content").html(html); 
                                        
                                        setlogdisplay( );
                                        var div = $("#hide_log").click( function() { toolge( $(this) ); } );   
                                        
                                        if (html.indexOf("- Stop refresh -")==-1)
                                            time = setTimeout("refresh_log()",10000);
											
										if (html.indexOf("- Device reboot -")!=-1) {
											$("#NextStep").hide();
											setTimeout( CheckAlive ,120000); // we know this should take aroung 2.0 minutes
										}
                                },
                    'error': function () {
                        // something went wrong to the device
                        $('#log_content').hide();
                        $('#log_content_fail').show();
                    }
                });
        
    }
    function setlogdisplay( ) {
        if ( log_visible ) {
            $(".logs").css('display','inherit');
            $("#hide_log").html("[hide]");
        } else {
            $(".logs").css('display','none');
            $("#hide_log").html("[show]");
        }
    }
    function toolge( title ) {
        if ( log_visible ) {
            title.html("[show]");
            $(".logs").fadeOut('fast');
            log_visible = false;
        } else {
            title.html("[hide]");
            $(".logs").fadeIn('fast');
            log_visible = true;
        }
    }
    var div = $("#hide_log").click( function() { toolge( $(this) ); } );
    
    setlogdisplay( );
    
    $('#log_content_fail').hide();
    time = setTimeout("refresh_log()",10000);

//]]></script>
<?php
} else {

    echo CHtml::tag("h2", array(), "Manual Update") ."\n";

    echo CHtml::errorSummary( $firmware )  ."\n";
    
    echo CHtml::openTag("div", array("class"=>"yiiForm") )."\n";
    echo CHtml::form();

    echo CHtml::openTag("div", array('class'=>'simple') );
    echo CHtml::activeHiddenField($firmware, "mode", array('value'=>"check"));
    echo CHtml::activeLabel($firmware, "updatesource") ;
    echo CHtml::activeDropDownList($firmware, "updatesource", $firmware->updatesourceList) ." ";
    echo CHtml::submitButton("Check for Update", array('name'=>'update') );
    echo CHtml::closeTag("div" )."\n";


    echo CHtml::endForm();
    echo CHtml::closeTag("div" )."\n";

}


?>
