<?php

echo CHtml::tag("h2", array(), "Fusion" );

if ( $setup->active ) {
    echo CHtml::tag("h3", array(), "Fusion is curently activated.");
    echo Chtml::tag("br");
    
    $addr = Tools::get_my_host();
    
    echo CHtml::tag("p", array(), "To disable Fusion, click on the Disable button.");
    
    echo CHtml::tag("p", array(), "Note that this will erase all the Fusion content from the unit.");
    
    echo CHtml::beginForm();
    echo CHtml::submitButton("Disable Fusion", array('name'=>'disable'));
    echo CHtml::endForm();
    
    echo Chtml::tag("br");
    echo CHtml::tag("h3", array(), "Fusion Setup" );
    
    echo CHtml::beginForm();
    echo CHtml::openTag("div", array("class"=>"simple") );
    echo CHtml::activeCheckBox($setup, "start" ) . CHtml::activeLabel($setup, "start") ;
    echo CHtml::closeTag("div" );
    echo Chtml::tag("br");
    echo CHtml::tag("div", array("class"=>"action"), CHtml::submitButton("Apply") ) ;
    
    
    echo CHtml::endForm();
    
    echo CHtml::tag("p", array(), CHtml::tag("h3", array(), "Go to fusion: ". CHtml::link("http://$addr/fusion/","http://$addr/fusion/")) );
    
} else {
    echo CHtml::tag("h3", array(), "Fusion is currently not activated.");
    echo Chtml::tag("br");
    echo CHtml::tag("p", array(), "To activate Fusion, click on the Activate button.");
    
    echo CHtml::tag("p", array(), "Note that this will reset the Network sources and erase all content from the unit. ".
                                  "Publishing content to the unit using WebDAV will only be allowed in the '/publish/' folder.");
                                  
    echo CHtml::tag("p", array(), "Once Fusion has been activated, you can return to this page at any time to disable it.");
                                  
    echo CHtml::beginForm();
    echo CHtml::openTag("div", array("class"=>"simple") );
    echo CHtml::activeCheckBox($setup, "start" ) . CHtml::activeLabel($setup, "start", array( 'checked'=>'checked') ) ;
    echo CHtml::closeTag("div" );
    
    echo Chtml::tag("br");
    
    echo CHtml::tag("div", array("class"=>"action"), CHtml::submitButton("Activate Fusion", array('name'=>'activate') ) );
    
    
    echo CHtml::endForm();
}