<?php 

echo CHtml::errorSummary( $maintenance )  ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( );
echo CHtml::tag("h2", array(), "Diagnostic Mode Restart") ."\n";

echo "Pressing 'Restart Now' will restart the ".Yii::app()->user->branding->product." in diagnostic (i.e., recovery) mode";
if ( Yii::app()->user->tools->checkRecoverySate()!="bonjour" )
    echo " with the same network address, if one has been configured, or with a free IP address in the range of 192.168.1.11 to 192.168.1.29 otherwise.<br/>\n";
else {
    $inf = new BasicInfo;
    echo ". The unit is always reachable at <a href='http://".$inf->hostname.".local/'>http://".$inf->hostname.".local</a> from Zeroconf enabled computers on the local network.<br/>\n";
}
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Restart Now", array('name'=>'rebootrecovery') ) );
echo CHtml::endForm() . CHtml::closeTag("div" );


echo CHtml::tag("h2", array(), "Installation Mode") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( );
echo CHtml::tag("div", array( 'class'=>'simple'),   "When the installation mode is enabled the ". Yii::app()->user->branding->product.
                                                    " will NOT automatically reboot to activate configuration changes.\n" ); 
echo CHtml::tag("div", array( 'class'=>'simple'),   "The administrator must manually reboot the ".
                                                    Yii::app()->user->branding->product." at the end of the installation.\n" );
if ( Yii::app()->user->status->installationmode ){
	if ( count(Yii::app()->user->status->pendingChangeList)==0 ) 
		echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Disable", array('name'=>'stop_instalation_mode') ) );       
} else
	echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Enable", array('name'=>'instalation_mode') ) );       
echo CHtml::endForm() . CHtml::closeTag("div" );


echo CHtml::tag("h2", array(), "Extended Reporting") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( array("admin/report") );
echo CHtml::tag("div", array("class"=>"simple space"),  "Before contacting ".Yii::app()->user->branding->vendor." support team ".
                                                        "(<a href='mailto://".Yii::app()->user->branding->email."'>".Yii::app()->user->branding->email."</a>), ".
                                                        "please generate a status report with all display attached to the ".Yii::app()->user->branding->product.".\n");
echo CHtml::tag("div", array("class"=>"simple space"),  "Pressing on the 'Get Extended Report' button will generate an extended report file with all information needed by the support team to help you.<br/>".
                                                        "Note that the extended status generation can take up to 5 minutes to be generated." );
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Get Extended Report", array('name'=>'extended') ) );
echo CHtml::endForm() . CHtml::closeTag("div" );

if ( Yii::app()->user->advancedMode() ) {
    echo "<h2>Remote Support</h2>\n";
    echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( );
    if ($maintenance->checkSSH()){
        echo "<br/>Services for remote ".Yii::app()->user->branding->vendor." support are running.";
        echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Stop Now", array('name'=>'stop_ssh') ) );       
    }else{
        echo "<br/>Start services for remote ".Yii::app()->user->branding->vendor." support on the ".Yii::app()->user->branding->product." for diagnostic and debugging purposes.\n";
        echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Start Services", array('name'=>'start_ssh') ) );           
        echo "Note: the first time it takes a considerable amount of time to start support services, please be patient.<br/><br/>\n";
    }
    echo CHtml::endForm() . CHtml::closeTag("div" );
}

echo CHtml::tag("h2", array(), "Device Self Test") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( array( '/diagnosis' ) );

echo CHtml::tag("div", array( 'class'=>'simple'),   "Starts a set of self tests to verify the hardware components of the ".Yii::app()->user->branding->product.".\n" ); 
echo CHtml::tag("div", array( 'class'=>'action'),   CHtml::submitButton("Start Testing" ) );

echo CHtml::endForm() . CHtml::closeTag("div" );    


echo CHtml::tag("h2", array(), "Clear Data") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( );
echo CHtml::tag("div", array( 'class'=>'action'),   CHtml::submitButton("Clear Logs", array('name'=>'clear_logs') ) ." " .
                                                    CHtml::submitButton("Clear Cache", array('name'=>'clear_cache') ) ." " .
                                                    CHtml::submitButton("Clear Clock Calibration", array('name'=>'clear_ntp') )  );


echo CHtml::endForm() . CHtml::closeTag("div" );    

echo CHtml::tag("h2", array(), "Format Internal Storage") ."\n";
echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( );
//echo CHtml::tag("div", array("class"=>"simple space"),  "Pressing 'Format Internal Storage' will format the internal storage of the ".Yii::app()->user->branding->product." and remove all content.");
echo CHtml::tag("div", array( 'class'=>'action'),   CHtml::submitButton("Format Internal Storage", array('name'=>'format_storage') ) ." " );
echo CHtml::endForm() . CHtml::closeTag("div" );    