<?php 

echo CHtml::tag("h2", array(), "Current Settings") ."\n";
echo CHtml::openTag("table");

echo CHtml::openTag("tr");
echo CHtml::tag("td", array(), $time->getAttributeLabel("time"). " : ");
echo CHtml::tag("td", array(), date("F j, Y, G:i") );
echo CHtml::closeTag("tr");

echo CHtml::openTag("tr");
echo CHtml::tag("td", array(), $time->getAttributeLabel("link"). " : ");
echo CHtml::tag("td", array(), $time->getTimeZoneString() );
echo CHtml::closeTag("tr");

echo CHtml::closeTag("table");



$timezones = $time->getTimezones();
$arealist = array();
$citylist = array();

$arealist["dummy"] = "Please select an area";

foreach($timezones as $name => $val){
	if ( isset($time->tzmap[ $name ]) ){
        $arealist[$name] = $time->tzmap[ $name ];
        if ( $name == $time->tzarea ) 
            $activeArea=$val;
    }
}
if ( isset($activeArea) ) {
	foreach( $activeArea as $name => $path ){
		$citylist[ htmlspecialchars($path) ] = $name;
	}
} else {
	$time->tzarea = "dummy";
    $citylist[ 'dummy' ] = "-------------------";
}

echo CHtml::tag("h2", array(), "Change Time Zone") ."\n";

echo CHtml::errorSummary( $time )  ."\n";

echo CHtml::openTag("div", array("class"=>"yiiForm") );
echo CHtml::form();


echo CHtml::openTag("div", array("class"=>"simple") );
echo CHtml::activeLabel($time, "link", array( 'style'=>"width:120px" ));
echo CHtml::activeDropDownList($time, "tzarea", $arealist, array('id'=>"RegionSelect", 'onchange'=>'selectRegion()', 'style'=>"width: 160px;" ) ) ." ";
echo CHtml::activeDropDownList($time, "link", $citylist, array('id'=>"CitySelect", 'style'=>"width: 225px;") );

echo CHtml::closeTag("div");

echo CHtml::openTag("div", array( 'class'=>'action') );
echo CHtml::submitButton("Apply", array('name'=>'timezone') );
echo CHtml::closeTag("div");


echo CHtml::endForm();
echo CHtml::closeTag("div");

echo CHtml::tag("div", array("class"=>"simple"), $ntp->message );

?>
<script type="text/javascript">//<![CDATA[

var timezonesCity=new Array();
var timezonesUri=new Array();
<?php

$idx=0;
echo "timezonesCity[$idx] = new Array( '-------------------' );\n";
echo "timezonesUri[$idx] = new Array( 'invalid' );\n";

$idx++;
foreach ($timezones as $name => $val){
	$cities="";
	$uris="";
	if (isset($time->tzmap[$name])){
		foreach ($val as $city => $uri){
			$cities.="\"$city\",";
			$uris.="\"$uri\",";		
		}
		$cities=substr($cities,0,strlen($cities)-1);
		$uris=substr($uris,0,strlen($uris)-1);
	
		echo "timezonesCity[$idx]=new Array($cities);\n";
		echo "timezonesUri[$idx]=new Array($uris);\n";
		$idx++;
	}
}

?>
function selectRegion()
{
	var selectRegion=document.getElementById("RegionSelect");
	var selectCity=document.getElementById("CitySelect");
	var reg=selectRegion.selectedIndex;
	var nbCity=selectCity.length;
	for (var i=0; i<nbCity; i++){
		selectCity.remove(0);
	}
	nbCity=timezonesCity[reg].length;
	for (var i=0; i<nbCity; i++){
		var newOption=new Option;
		newOption.text=timezonesCity[reg][i];
		newOption.value=timezonesUri[reg][i];
		try {
			selectCity.add(newOption, null);
		}catch(ex) {
			selectCity.add(newOption);
		}
	}
}

//]]></script>
