<?php

Yii::app()->getClientScript()->registerCoreScript('jquery');

echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form();


echo CHtml::tag("h2", array(), "Config") ."\n";



echo CHtml::tag("div", array("class"=>"simple"), CHtml::label($logs->getAttributeLabel("customOff" ), null) .
                                                 CHtml::activeRadioButton($logs, "custom", array( 'uncheckValue'=>null, 'value'=>'0') )
                    );
echo CHtml::tag("div", array("class"=>"simple"), CHtml::label($logs->getAttributeLabel("customOn" ), null) .
                                                 CHtml::activeRadioButton($logs, "custom", array( 'uncheckValue'=>null, 'value'=>'1') )
                    );

echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Update", array('name'=>'logs') ) );

echo CHtml::tag("h2", array(), "Appender") ."\n";

echo CHtml::tag("h3", array(), "New Appender" ). "\n";
$info = new AppenderConfig;

echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "name" ) .
                                                CHtml::activeTextField($info, "name" )
                        );
echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "type" ) .
                                                CHtml::activeDropDownList($info, "type", $info->appenderList )
                );
                
echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "Threshold" ) .
                                                CHtml::activeDropDownList($info, "Threshold", $info->priorityList )
                    );     
echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "ConversionPattern" ) .
                                                CHtml::activeTextField($info, "ConversionPattern", array('size'=>55) )
                );                    
echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Add", array('name'=>'add') ) );

$idx=0;
foreach( $logs->appenders as $name => $info ) {
    $entry = $info->appender[$info->type];
    $type = $info->appenderList[$info->type];
    
    echo CHtml::openTag( "div" );
    echo CHtml::tag("h3", array(), htmlspecialchars($info->name)). "\n";

    echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "[$idx]AllLoggers" ) .
                                                    CHtml::activeCheckBox($info, "[$idx]AllLoggers" )
                    );
    echo CHtml::activeHiddenField($info, "[$idx]name");
    echo CHtml::activeHiddenField($info, "[$idx]type");
    echo CHtml::tag("div", array("class"=>"simple"),CHtml::label($info->getAttributeLabel("type"), null ) .
                                                    CHtml::textField("dummy",$type, array('disabled'=>'disabled') )
                    );
    
    echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "[$idx]Threshold" ) .
                                                    CHtml::activeDropDownList($info, "[$idx]Threshold", $info->priorityList )
                    );
    
    echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "[$idx]ConversionPattern" ) .
                                                    CHtml::activeTextField($info, "[$idx]ConversionPattern", array('size'=>55) )
                    );
    foreach( $entry as $item ) {
        echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($info, "[$idx]$item" ) .
                                                    CHtml::activeTextField($info, "[$idx]$item" )
                        );
    
    }
    echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Remove", array('onClick'=>'$(this).parent().parent().remove()') ) );
    echo CHtml::closeTag( "div" );
    $idx++;
}


echo CHtml::tag("h2", array(), "Logger") ."\n";

echo CHtml::tag("div", array("class"=>"simple"),CHtml::activeLabel($logs, "priority" ) .
                                                CHtml::activeDropDownList($logs, "priority", $logs->priorityList )
                );

echo CHtml::openTag( "table" );
echo CHtml::openTag( "tr") . CHtml::tag("td");
foreach( $logs->appenders as $name => $info ) {
    echo CHtml::tag("td", array(), CHtml::encode($info->name)  );
}
echo CHtml::tag("td") . CHtml::closeTag( "tr");
    
print_log( $logs->loggernames, 0, "spx.", $logs);

echo CHtml::closeTag( "table" );

echo CHtml::tag("div", array( 'class'=>'action'), CHtml::submitButton("Update", array('name'=>'logs') ) );

echo CHtml::endForm() . CHtml::closeTag("div");

$idx = -1;
function print_log($loggernames, $level, $logger, $logs) {
    global $idx;
    
	foreach($loggernames as $name => $val){
        $logger_name = $logger.$name;
        echo CHtml::openTag( "tr") . CHtml::openTag("td");
        
        
        if ( isset($logs->loggers[$logger_name]) ){
            $logger_obj = $logs->loggers[$logger_name];
            
        }else {
            $logger_obj = new LoggerConfig;
            $logger_obj->name = $logger_name;
        }
        $idx++;
		
        for ($i=0; $i<$level; $i++) print ("--- ");
		echo CHtml::encode($name). CHtml::activeHiddenField($logger_obj, "[$idx]name"). CHtml::closeTag("td");
        
        
        foreach( $logs->appenders as $name => $info ) {
            echo CHtml::tag( "td", array(), CHtml::checkBox("LoggerConfig[".$idx."][".$name."]", isset($logger_obj->refs[$name]) ) );
        }
		
        echo CHtml::tag( "td", array(), CHtml::activeDropDownList($logger_obj, "[$idx]priority", $info->priorityList ) );
        
        echo CHtml::closeTag( "tr");
        
        if (is_array($val)){
			print_log($val, $level+1, $logger_name.".", $logs);
		}
	}
}