<?php 
Yii::app()->getClientScript()->registerCoreScript('jquery');

echo CHtml::openTag("div", array('id'=>'mainFormLoading') )."\n";
echo CHtml::tag("h2", array(), "Generating test report. " );
echo CHtml::tag("p", array(),   "The page will reload itself automatically at the end of the procedure.");
echo CHtml::image("images/loadingAnimation.gif", "Loading..." );
echo CHtml::tag("br");
echo CHtml::closeTag("div" );

echo CHtml::openTag("div", array('id'=>'mainFormData') )."\n";

echo CHtml::errorSummary( $diag )  ."\n";

echo CHtml::tag("h2", array(), "Test log" .
               CHtml::tag("div", array( 'id'=>'show', 'class'=>'right'), 
                          CHtml::link(  "[show]", "#", 
                                        array( 'onclick'=>"$('#showlogs').fadeIn('fast'); $('#show').hide(); $('#hide').show(); " ) )
                          ).
               CHtml::tag("div", array( 'id'=>'hide', 'class'=>'right', "style"=>"display:none"), 
                          CHtml::link(  "[hide]", "#", 
                                        array( 'onclick'=>"$('#showlogs').fadeOut('fast'); $('#show').show(); $('#hide').hide(); ") )
                          )
    );

echo CHtml::openTag("pre", array( 'id'=>'showlogs', "style"=>"display:none" ) ) . "\n";
foreach ( $diag->outputs as $out )
    echo $out . "\n";
echo CHtml::closeTag("pre") . "\n";

echo CHtml::tag("br");

echo CHtml::tag("h2", array(), "Internal test results" ) . "\n";
if ( $diag->setupok ) {
    echo CHtml::tag("p", array(), "Test setup was successful." ) . "\n";
} else {
    echo CHtml::tag("p", array(), "Test setup failed." ) . "\n";
}
echo CHtml::tag("p", array(), "Summary:" ) . "\n";
echo CHtml::openTag("table", array( 'class'=>'diagnosis results' ) );
if ( $diag->status != 0 ) 
    $str = CHtml::tag("td", array("class"=>"fail"), "FAILED");
else
    $str = CHtml::tag("td", array("class"=>"pass"), "PASSED");
echo CHtml::tag("tr", array(), CHtml::tag("td", array(),"Overall result") . $str );

echo CHtml::tag("tr", array(), CHtml::tag("td", array('class'=>'label' ),"Steps passed") . CHtml::tag("td", array(), $diag->nr_passed) );
echo CHtml::tag("tr", array(), CHtml::tag("td", array('class'=>'label'),"Steps skipped") . CHtml::tag("td", array(), $diag->nr_skipped) );
echo CHtml::tag("tr", array(), CHtml::tag("td", array('class'=>'label'),"Steps failed") . CHtml::tag("td", array(), $diag->nr_failed) );
          
echo CHtml::closeTag("table");

echo CHtml::tag("p", array(), "Details:" ) . "\n";
echo CHtml::openTag("table", array( 'class'=>'diagnosis details') );

foreach ($diag->details as $d) {
    echo CHtml::openTag("tr");
    echo CHtml::tag("td", array('class'=>'label'), $d['name'] );
   
   $class = $d['status'] !== 'PASSED' && $d['status'] !== 'SKIPPED' ? "fail" : "pass";
    echo CHtml::tag("td", array( 'class'=>$class ), $d['status'] );
    
    echo CHtml::closeTag("tr");
}

echo CHtml::closeTag("table" );

if ( $feedback ) {
    echo CHtml::tag("h2", array(),"External test results" ) . "\n";
    echo CHtml::tag("p", array(),"Fill in the form below to finish the tests and click the button below to save and obtain the device report. ".
                                 "Use the text boxes below for any additional remarks that should be saved in the report." ) . "\n";
    

    echo CHtml::openTag("div", array("class"=>"yiiForm") ) . CHtml::form( array("report"), 'post', array( 'id'=>'mainForm') ) . "\n";
        
    echo CHtml::hiddenField("pid", $diag->pid ) . "\n";

    if ( ! empty( $diag->fchecks ) ) {
        $str = "";
        foreach ($diag->fchecks as $c)
           $str .= $c['name']  . ' ';
        echo CHtml::hiddenField("checks", $str) . "\n";
        
        echo CHtml::openTag("table", array( 'class'=>'feedback'));
        echo CHtml::tag("tr", array(),  CHtml::tag("th", array(),"Test / Description") . 
                                        
                                        CHtml::tag("th", array(),"OK") .
                                        CHtml::tag("th", array(),"Bad") .
                                        CHtml::tag("th", array(),"Unknown") .
                                        CHtml::tag("th", array(),"Remarks") );

        foreach ($diag->fchecks as $c) {
      
           $hn = htmlspecialchars($c['name']);
           echo CHtml::openTag("tr");
           
           echo CHtml::tag("td", array('class'=>'test' ), $c['label'] );
           
           
           echo CHtml::tag("td", array('class'=>'center'), CHtml::radioButton( 'test_'.$hn , false, array( 'value'=>'ok' ) ) );
           echo CHtml::tag("td", array('class'=>'center'), CHtml::radioButton( 'test_'.$hn , false, array( 'value'=>'bad' ) ) );
           echo CHtml::tag("td", array('class'=>'center'), CHtml::radioButton( 'test_'.$hn , true, array( 'value'=>'unknown' ) ) );
           echo CHtml::closeTag("tr");
           echo CHtml::openTag("tr");
           echo CHtml::tag("td", array('class'=>'desc'), $c['desc'] );
           
           echo CHtml::tag("td", array( 'colspan'=>4 ), CHtml::textArea( 'comm_'. $hn, " ", array( "rows"=>"1", "cols"=>"30" ) ) );
           
           echo CHtml::closeTag("tr");
        }
        echo CHtml::closeTag("table");
      
     }
     echo CHtml::tag("p", array(),"General remarks:" );
     echo CHtml::textArea("comments", "", array( "rows"=>"4", "cols"=>"63" ) );
     echo CHtml::tag("br");
     echo CHtml::tag("br");
     echo CHtml::submitButton("Save results and get report");
     
     echo CHtml::endForm() . CHtml::closeTag("div" );
 }
echo CHtml::closeTag("div" );
 
$script = <<<EOL
var wait = $('#mainFormLoading');
var form = $("#mainFormData");  
var all = $("#mainFormData");  

wait.hide();

form.submit(function(){  

    //hide the form, and show the waiting icon
    all.hide();
    wait.show();
    // We will start a get request a bit latter. This request will be blocked until
    // php has finised generating the report, thus insuring that the index page will only be opened once
    // the report has been generated.
    // Because of chrome small timeout, we try this every 30s until we succeed
    window.setInterval( function() {
        $.get("/info.php", function() {
            window.location.replace("/index.php");
          }
        );
    }, 30*1000 );
    
    return true  
    
}); 
EOL;

echo CHtml::script( $script );